<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmailPerson StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:EmailPerson
 * @subpackage Structs
 */
class EmailPerson extends AbstractStructBase
{
    /**
     * The EmailAddress
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $EmailAddress;
    /**
     * The EmailFormat
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $EmailFormat;
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $LastName;
    /**
     * The emailListKeyId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $emailListKeyId;
    /**
     * Constructor method for EmailPerson
     * @uses EmailPerson::setEmailAddress()
     * @uses EmailPerson::setEmailFormat()
     * @uses EmailPerson::setFirstName()
     * @uses EmailPerson::setLastName()
     * @uses EmailPerson::setEmailListKeyId()
     * @param string $emailAddress
     * @param string $emailFormat
     * @param string $firstName
     * @param string $lastName
     * @param int $emailListKeyId
     */
    public function __construct($emailAddress = null, $emailFormat = null, $firstName = null, $lastName = null, $emailListKeyId = null)
    {
        $this
            ->setEmailAddress($emailAddress)
            ->setEmailFormat($emailFormat)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setEmailListKeyId($emailListKeyId);
    }
    /**
     * Get EmailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->EmailAddress;
    }
    /**
     * Set EmailAddress value
     * @param string $emailAddress
     * @return \StructType\EmailPerson
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailAddress, true), gettype($emailAddress)), __LINE__);
        }
        $this->EmailAddress = $emailAddress;
        return $this;
    }
    /**
     * Get EmailFormat value
     * @return string|null
     */
    public function getEmailFormat()
    {
        return $this->EmailFormat;
    }
    /**
     * Set EmailFormat value
     * @param string $emailFormat
     * @return \StructType\EmailPerson
     */
    public function setEmailFormat($emailFormat = null)
    {
        // validation for constraint: string
        if (!is_null($emailFormat) && !is_string($emailFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailFormat, true), gettype($emailFormat)), __LINE__);
        }
        $this->EmailFormat = $emailFormat;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\EmailPerson
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\EmailPerson
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get emailListKeyId value
     * @return int|null
     */
    public function getEmailListKeyId()
    {
        return $this->emailListKeyId;
    }
    /**
     * Set emailListKeyId value
     * @param int $emailListKeyId
     * @return \StructType\EmailPerson
     */
    public function setEmailListKeyId($emailListKeyId = null)
    {
        // validation for constraint: int
        if (!is_null($emailListKeyId) && !(is_int($emailListKeyId) || ctype_digit($emailListKeyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($emailListKeyId, true), gettype($emailListKeyId)), __LINE__);
        }
        $this->emailListKeyId = $emailListKeyId;
        return $this;
    }
}
