<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DRStopType StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DRStopType
 * @subpackage Structs
 */
class DRStopType extends DRAccountType
{
    /**
     * The cummulativeDrvTmField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $cummulativeDrvTmField;
    /**
     * The cummulativeWrkTmField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $cummulativeWrkTmField;
    /**
     * The legField
     * @var int
     */
    public $legField;
    /**
     * The rtField
     * @var int
     */
    public $rtField;
    /**
     * The selectedField
     * @var bool
     */
    public $selectedField;
    /**
     * The seqField
     * @var int
     */
    public $seqField;
    /**
     * The timeWindowCodeField
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $timeWindowCodeField;
    /**
     * Constructor method for DRStopType
     * @uses DRStopType::setCummulativeDrvTmField()
     * @uses DRStopType::setCummulativeWrkTmField()
     * @uses DRStopType::setLegField()
     * @uses DRStopType::setRtField()
     * @uses DRStopType::setSelectedField()
     * @uses DRStopType::setSeqField()
     * @uses DRStopType::setTimeWindowCodeField()
     * @param string $cummulativeDrvTmField
     * @param string $cummulativeWrkTmField
     * @param int $legField
     * @param int $rtField
     * @param bool $selectedField
     * @param int $seqField
     * @param string $timeWindowCodeField
     */
    public function __construct($cummulativeDrvTmField = null, $cummulativeWrkTmField = null, $legField = null, $rtField = null, $selectedField = null, $seqField = null, $timeWindowCodeField = null)
    {
        $this
            ->setCummulativeDrvTmField($cummulativeDrvTmField)
            ->setCummulativeWrkTmField($cummulativeWrkTmField)
            ->setLegField($legField)
            ->setRtField($rtField)
            ->setSelectedField($selectedField)
            ->setSeqField($seqField)
            ->setTimeWindowCodeField($timeWindowCodeField);
    }
    /**
     * Get cummulativeDrvTmField value
     * @return string|null
     */
    public function getCummulativeDrvTmField()
    {
        return $this->cummulativeDrvTmField;
    }
    /**
     * Set cummulativeDrvTmField value
     * @param string $cummulativeDrvTmField
     * @return \StructType\DRStopType
     */
    public function setCummulativeDrvTmField($cummulativeDrvTmField = null)
    {
        // validation for constraint: string
        if (!is_null($cummulativeDrvTmField) && !is_string($cummulativeDrvTmField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cummulativeDrvTmField, true), gettype($cummulativeDrvTmField)), __LINE__);
        }
        $this->cummulativeDrvTmField = $cummulativeDrvTmField;
        return $this;
    }
    /**
     * Get cummulativeWrkTmField value
     * @return string|null
     */
    public function getCummulativeWrkTmField()
    {
        return $this->cummulativeWrkTmField;
    }
    /**
     * Set cummulativeWrkTmField value
     * @param string $cummulativeWrkTmField
     * @return \StructType\DRStopType
     */
    public function setCummulativeWrkTmField($cummulativeWrkTmField = null)
    {
        // validation for constraint: string
        if (!is_null($cummulativeWrkTmField) && !is_string($cummulativeWrkTmField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cummulativeWrkTmField, true), gettype($cummulativeWrkTmField)), __LINE__);
        }
        $this->cummulativeWrkTmField = $cummulativeWrkTmField;
        return $this;
    }
    /**
     * Get legField value
     * @return int|null
     */
    public function getLegField()
    {
        return $this->legField;
    }
    /**
     * Set legField value
     * @param int $legField
     * @return \StructType\DRStopType
     */
    public function setLegField($legField = null)
    {
        // validation for constraint: int
        if (!is_null($legField) && !(is_int($legField) || ctype_digit($legField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($legField, true), gettype($legField)), __LINE__);
        }
        $this->legField = $legField;
        return $this;
    }
    /**
     * Get rtField value
     * @return int|null
     */
    public function getRtField()
    {
        return $this->rtField;
    }
    /**
     * Set rtField value
     * @param int $rtField
     * @return \StructType\DRStopType
     */
    public function setRtField($rtField = null)
    {
        // validation for constraint: int
        if (!is_null($rtField) && !(is_int($rtField) || ctype_digit($rtField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rtField, true), gettype($rtField)), __LINE__);
        }
        $this->rtField = $rtField;
        return $this;
    }
    /**
     * Get selectedField value
     * @return bool|null
     */
    public function getSelectedField()
    {
        return $this->selectedField;
    }
    /**
     * Set selectedField value
     * @param bool $selectedField
     * @return \StructType\DRStopType
     */
    public function setSelectedField($selectedField = null)
    {
        // validation for constraint: boolean
        if (!is_null($selectedField) && !is_bool($selectedField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($selectedField, true), gettype($selectedField)), __LINE__);
        }
        $this->selectedField = $selectedField;
        return $this;
    }
    /**
     * Get seqField value
     * @return int|null
     */
    public function getSeqField()
    {
        return $this->seqField;
    }
    /**
     * Set seqField value
     * @param int $seqField
     * @return \StructType\DRStopType
     */
    public function setSeqField($seqField = null)
    {
        // validation for constraint: int
        if (!is_null($seqField) && !(is_int($seqField) || ctype_digit($seqField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seqField, true), gettype($seqField)), __LINE__);
        }
        $this->seqField = $seqField;
        return $this;
    }
    /**
     * Get timeWindowCodeField value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTimeWindowCodeField()
    {
        return isset($this->timeWindowCodeField) ? $this->timeWindowCodeField : null;
    }
    /**
     * Set timeWindowCodeField value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $timeWindowCodeField
     * @return \StructType\DRStopType
     */
    public function setTimeWindowCodeField($timeWindowCodeField = null)
    {
        // validation for constraint: string
        if (!is_null($timeWindowCodeField) && !is_string($timeWindowCodeField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeWindowCodeField, true), gettype($timeWindowCodeField)), __LINE__);
        }
        if (is_null($timeWindowCodeField) || (is_array($timeWindowCodeField) && empty($timeWindowCodeField))) {
            unset($this->timeWindowCodeField);
        } else {
            $this->timeWindowCodeField = $timeWindowCodeField;
        }
        return $this;
    }
}
