<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DRStop StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DRStop
 * @subpackage Structs
 */
class DRStop extends DRLineItemType
{
    /**
     * The estimatedDeliveryDateField
     * @var string
     */
    public $estimatedDeliveryDateField;
    /**
     * The fixedRoute
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $fixedRoute;
    /**
     * The importOrderTypeField
     * @var string
     */
    public $importOrderTypeField;
    /**
     * The keyField
     * @var int
     */
    public $keyField;
    /**
     * The keyFieldSpecified
     * @var bool
     */
    public $keyFieldSpecified;
    /**
     * Constructor method for DRStop
     * @uses DRStop::setEstimatedDeliveryDateField()
     * @uses DRStop::setFixedRoute()
     * @uses DRStop::setImportOrderTypeField()
     * @uses DRStop::setKeyField()
     * @uses DRStop::setKeyFieldSpecified()
     * @param string $estimatedDeliveryDateField
     * @param string $fixedRoute
     * @param string $importOrderTypeField
     * @param int $keyField
     * @param bool $keyFieldSpecified
     */
    public function __construct($estimatedDeliveryDateField = null, $fixedRoute = null, $importOrderTypeField = null, $keyField = null, $keyFieldSpecified = null)
    {
        $this
            ->setEstimatedDeliveryDateField($estimatedDeliveryDateField)
            ->setFixedRoute($fixedRoute)
            ->setImportOrderTypeField($importOrderTypeField)
            ->setKeyField($keyField)
            ->setKeyFieldSpecified($keyFieldSpecified);
    }
    /**
     * Get estimatedDeliveryDateField value
     * @return string|null
     */
    public function getEstimatedDeliveryDateField()
    {
        return $this->estimatedDeliveryDateField;
    }
    /**
     * Set estimatedDeliveryDateField value
     * @param string $estimatedDeliveryDateField
     * @return \StructType\DRStop
     */
    public function setEstimatedDeliveryDateField($estimatedDeliveryDateField = null)
    {
        // validation for constraint: string
        if (!is_null($estimatedDeliveryDateField) && !is_string($estimatedDeliveryDateField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estimatedDeliveryDateField, true), gettype($estimatedDeliveryDateField)), __LINE__);
        }
        $this->estimatedDeliveryDateField = $estimatedDeliveryDateField;
        return $this;
    }
    /**
     * Get fixedRoute value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFixedRoute()
    {
        return isset($this->fixedRoute) ? $this->fixedRoute : null;
    }
    /**
     * Set fixedRoute value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fixedRoute
     * @return \StructType\DRStop
     */
    public function setFixedRoute($fixedRoute = null)
    {
        // validation for constraint: string
        if (!is_null($fixedRoute) && !is_string($fixedRoute)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fixedRoute, true), gettype($fixedRoute)), __LINE__);
        }
        if (is_null($fixedRoute) || (is_array($fixedRoute) && empty($fixedRoute))) {
            unset($this->fixedRoute);
        } else {
            $this->fixedRoute = $fixedRoute;
        }
        return $this;
    }
    /**
     * Get importOrderTypeField value
     * @return string|null
     */
    public function getImportOrderTypeField()
    {
        return $this->importOrderTypeField;
    }
    /**
     * Set importOrderTypeField value
     * @uses \EnumType\ImportOrderType::valueIsValid()
     * @uses \EnumType\ImportOrderType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $importOrderTypeField
     * @return \StructType\DRStop
     */
    public function setImportOrderTypeField($importOrderTypeField = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ImportOrderType::valueIsValid($importOrderTypeField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ImportOrderType', is_array($importOrderTypeField) ? implode(', ', $importOrderTypeField) : var_export($importOrderTypeField, true), implode(', ', \EnumType\ImportOrderType::getValidValues())), __LINE__);
        }
        $this->importOrderTypeField = $importOrderTypeField;
        return $this;
    }
    /**
     * Get keyField value
     * @return int|null
     */
    public function getKeyField()
    {
        return $this->keyField;
    }
    /**
     * Set keyField value
     * @param int $keyField
     * @return \StructType\DRStop
     */
    public function setKeyField($keyField = null)
    {
        // validation for constraint: int
        if (!is_null($keyField) && !(is_int($keyField) || ctype_digit($keyField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($keyField, true), gettype($keyField)), __LINE__);
        }
        $this->keyField = $keyField;
        return $this;
    }
    /**
     * Get keyFieldSpecified value
     * @return bool|null
     */
    public function getKeyFieldSpecified()
    {
        return $this->keyFieldSpecified;
    }
    /**
     * Set keyFieldSpecified value
     * @param bool $keyFieldSpecified
     * @return \StructType\DRStop
     */
    public function setKeyFieldSpecified($keyFieldSpecified = null)
    {
        // validation for constraint: boolean
        if (!is_null($keyFieldSpecified) && !is_bool($keyFieldSpecified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($keyFieldSpecified, true), gettype($keyFieldSpecified)), __LINE__);
        }
        $this->keyFieldSpecified = $keyFieldSpecified;
        return $this;
    }
}
