<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DRAccountSchedule StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DRAccountSchedule
 * @subpackage Structs
 */
class DRAccountSchedule extends AbstractStructBase
{
    /**
     * The activationDateField
     * @var string
     */
    public $activationDateField;
    /**
     * The frequencyField
     * @var float
     */
    public $frequencyField;
    /**
     * The maxDaysBtwnDeliveriesField
     * @var int
     */
    public $maxDaysBtwnDeliveriesField;
    /**
     * The minDaysBtwnDeliveriesField
     * @var int
     */
    public $minDaysBtwnDeliveriesField;
    /**
     * The profilesField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $profilesField;
    /**
     * The servicesPerDayField
     * @var int
     */
    public $servicesPerDayField;
    /**
     * The terminationDateField
     * @var string
     */
    public $terminationDateField;
    /**
     * Constructor method for DRAccountSchedule
     * @uses DRAccountSchedule::setActivationDateField()
     * @uses DRAccountSchedule::setFrequencyField()
     * @uses DRAccountSchedule::setMaxDaysBtwnDeliveriesField()
     * @uses DRAccountSchedule::setMinDaysBtwnDeliveriesField()
     * @uses DRAccountSchedule::setProfilesField()
     * @uses DRAccountSchedule::setServicesPerDayField()
     * @uses DRAccountSchedule::setTerminationDateField()
     * @param string $activationDateField
     * @param float $frequencyField
     * @param int $maxDaysBtwnDeliveriesField
     * @param int $minDaysBtwnDeliveriesField
     * @param \ArrayType\ArrayOfstring $profilesField
     * @param int $servicesPerDayField
     * @param string $terminationDateField
     */
    public function __construct($activationDateField = null, $frequencyField = null, $maxDaysBtwnDeliveriesField = null, $minDaysBtwnDeliveriesField = null, \ArrayType\ArrayOfstring $profilesField = null, $servicesPerDayField = null, $terminationDateField = null)
    {
        $this
            ->setActivationDateField($activationDateField)
            ->setFrequencyField($frequencyField)
            ->setMaxDaysBtwnDeliveriesField($maxDaysBtwnDeliveriesField)
            ->setMinDaysBtwnDeliveriesField($minDaysBtwnDeliveriesField)
            ->setProfilesField($profilesField)
            ->setServicesPerDayField($servicesPerDayField)
            ->setTerminationDateField($terminationDateField);
    }
    /**
     * Get activationDateField value
     * @return string|null
     */
    public function getActivationDateField()
    {
        return $this->activationDateField;
    }
    /**
     * Set activationDateField value
     * @param string $activationDateField
     * @return \StructType\DRAccountSchedule
     */
    public function setActivationDateField($activationDateField = null)
    {
        // validation for constraint: string
        if (!is_null($activationDateField) && !is_string($activationDateField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activationDateField, true), gettype($activationDateField)), __LINE__);
        }
        $this->activationDateField = $activationDateField;
        return $this;
    }
    /**
     * Get frequencyField value
     * @return float|null
     */
    public function getFrequencyField()
    {
        return $this->frequencyField;
    }
    /**
     * Set frequencyField value
     * @param float $frequencyField
     * @return \StructType\DRAccountSchedule
     */
    public function setFrequencyField($frequencyField = null)
    {
        // validation for constraint: float
        if (!is_null($frequencyField) && !(is_float($frequencyField) || is_numeric($frequencyField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($frequencyField, true), gettype($frequencyField)), __LINE__);
        }
        $this->frequencyField = $frequencyField;
        return $this;
    }
    /**
     * Get maxDaysBtwnDeliveriesField value
     * @return int|null
     */
    public function getMaxDaysBtwnDeliveriesField()
    {
        return $this->maxDaysBtwnDeliveriesField;
    }
    /**
     * Set maxDaysBtwnDeliveriesField value
     * @param int $maxDaysBtwnDeliveriesField
     * @return \StructType\DRAccountSchedule
     */
    public function setMaxDaysBtwnDeliveriesField($maxDaysBtwnDeliveriesField = null)
    {
        // validation for constraint: int
        if (!is_null($maxDaysBtwnDeliveriesField) && !(is_int($maxDaysBtwnDeliveriesField) || ctype_digit($maxDaysBtwnDeliveriesField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxDaysBtwnDeliveriesField, true), gettype($maxDaysBtwnDeliveriesField)), __LINE__);
        }
        $this->maxDaysBtwnDeliveriesField = $maxDaysBtwnDeliveriesField;
        return $this;
    }
    /**
     * Get minDaysBtwnDeliveriesField value
     * @return int|null
     */
    public function getMinDaysBtwnDeliveriesField()
    {
        return $this->minDaysBtwnDeliveriesField;
    }
    /**
     * Set minDaysBtwnDeliveriesField value
     * @param int $minDaysBtwnDeliveriesField
     * @return \StructType\DRAccountSchedule
     */
    public function setMinDaysBtwnDeliveriesField($minDaysBtwnDeliveriesField = null)
    {
        // validation for constraint: int
        if (!is_null($minDaysBtwnDeliveriesField) && !(is_int($minDaysBtwnDeliveriesField) || ctype_digit($minDaysBtwnDeliveriesField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minDaysBtwnDeliveriesField, true), gettype($minDaysBtwnDeliveriesField)), __LINE__);
        }
        $this->minDaysBtwnDeliveriesField = $minDaysBtwnDeliveriesField;
        return $this;
    }
    /**
     * Get profilesField value
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getProfilesField()
    {
        return $this->profilesField;
    }
    /**
     * Set profilesField value
     * @param \ArrayType\ArrayOfstring $profilesField
     * @return \StructType\DRAccountSchedule
     */
    public function setProfilesField(\ArrayType\ArrayOfstring $profilesField = null)
    {
        $this->profilesField = $profilesField;
        return $this;
    }
    /**
     * Get servicesPerDayField value
     * @return int|null
     */
    public function getServicesPerDayField()
    {
        return $this->servicesPerDayField;
    }
    /**
     * Set servicesPerDayField value
     * @param int $servicesPerDayField
     * @return \StructType\DRAccountSchedule
     */
    public function setServicesPerDayField($servicesPerDayField = null)
    {
        // validation for constraint: int
        if (!is_null($servicesPerDayField) && !(is_int($servicesPerDayField) || ctype_digit($servicesPerDayField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($servicesPerDayField, true), gettype($servicesPerDayField)), __LINE__);
        }
        $this->servicesPerDayField = $servicesPerDayField;
        return $this;
    }
    /**
     * Get terminationDateField value
     * @return string|null
     */
    public function getTerminationDateField()
    {
        return $this->terminationDateField;
    }
    /**
     * Set terminationDateField value
     * @param string $terminationDateField
     * @return \StructType\DRAccountSchedule
     */
    public function setTerminationDateField($terminationDateField = null)
    {
        // validation for constraint: string
        if (!is_null($terminationDateField) && !is_string($terminationDateField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($terminationDateField, true), gettype($terminationDateField)), __LINE__);
        }
        $this->terminationDateField = $terminationDateField;
        return $this;
    }
}
