<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Coordinates StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Coordinates
 * @subpackage Structs
 */
class Coordinates extends AbstractStructBase
{
    /**
     * The latitudeField
     * @var float
     */
    public $latitudeField;
    /**
     * The longitudeField
     * @var float
     */
    public $longitudeField;
    /**
     * Constructor method for Coordinates
     * @uses Coordinates::setLatitudeField()
     * @uses Coordinates::setLongitudeField()
     * @param float $latitudeField
     * @param float $longitudeField
     */
    public function __construct($latitudeField = null, $longitudeField = null)
    {
        $this
            ->setLatitudeField($latitudeField)
            ->setLongitudeField($longitudeField);
    }
    /**
     * Get latitudeField value
     * @return float|null
     */
    public function getLatitudeField()
    {
        return $this->latitudeField;
    }
    /**
     * Set latitudeField value
     * @param float $latitudeField
     * @return \StructType\Coordinates
     */
    public function setLatitudeField($latitudeField = null)
    {
        // validation for constraint: float
        if (!is_null($latitudeField) && !(is_float($latitudeField) || is_numeric($latitudeField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($latitudeField, true), gettype($latitudeField)), __LINE__);
        }
        $this->latitudeField = $latitudeField;
        return $this;
    }
    /**
     * Get longitudeField value
     * @return float|null
     */
    public function getLongitudeField()
    {
        return $this->longitudeField;
    }
    /**
     * Set longitudeField value
     * @param float $longitudeField
     * @return \StructType\Coordinates
     */
    public function setLongitudeField($longitudeField = null)
    {
        // validation for constraint: float
        if (!is_null($longitudeField) && !(is_float($longitudeField) || is_numeric($longitudeField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($longitudeField, true), gettype($longitudeField)), __LINE__);
        }
        $this->longitudeField = $longitudeField;
        return $this;
    }
}
