<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountMasterDetailsAccountUserFlds StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AccountMasterDetailsAccountUserFlds
 * @subpackage Structs
 */
class AccountMasterDetailsAccountUserFlds extends AbstractStructBase
{
    /**
     * The accountKeyIdField
     * @var int
     */
    public $accountKeyIdField;
    /**
     * The fieldValueField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $fieldValueField;
    /**
     * The userFieldKeyIdField
     * @var int
     */
    public $userFieldKeyIdField;
    /**
     * Constructor method for AccountMasterDetailsAccountUserFlds
     * @uses AccountMasterDetailsAccountUserFlds::setAccountKeyIdField()
     * @uses AccountMasterDetailsAccountUserFlds::setFieldValueField()
     * @uses AccountMasterDetailsAccountUserFlds::setUserFieldKeyIdField()
     * @param int $accountKeyIdField
     * @param string $fieldValueField
     * @param int $userFieldKeyIdField
     */
    public function __construct($accountKeyIdField = null, $fieldValueField = null, $userFieldKeyIdField = null)
    {
        $this
            ->setAccountKeyIdField($accountKeyIdField)
            ->setFieldValueField($fieldValueField)
            ->setUserFieldKeyIdField($userFieldKeyIdField);
    }
    /**
     * Get accountKeyIdField value
     * @return int|null
     */
    public function getAccountKeyIdField()
    {
        return $this->accountKeyIdField;
    }
    /**
     * Set accountKeyIdField value
     * @param int $accountKeyIdField
     * @return \StructType\AccountMasterDetailsAccountUserFlds
     */
    public function setAccountKeyIdField($accountKeyIdField = null)
    {
        // validation for constraint: int
        if (!is_null($accountKeyIdField) && !(is_int($accountKeyIdField) || ctype_digit($accountKeyIdField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountKeyIdField, true), gettype($accountKeyIdField)), __LINE__);
        }
        $this->accountKeyIdField = $accountKeyIdField;
        return $this;
    }
    /**
     * Get fieldValueField value
     * @return string|null
     */
    public function getFieldValueField()
    {
        return $this->fieldValueField;
    }
    /**
     * Set fieldValueField value
     * @param string $fieldValueField
     * @return \StructType\AccountMasterDetailsAccountUserFlds
     */
    public function setFieldValueField($fieldValueField = null)
    {
        // validation for constraint: string
        if (!is_null($fieldValueField) && !is_string($fieldValueField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fieldValueField, true), gettype($fieldValueField)), __LINE__);
        }
        $this->fieldValueField = $fieldValueField;
        return $this;
    }
    /**
     * Get userFieldKeyIdField value
     * @return int|null
     */
    public function getUserFieldKeyIdField()
    {
        return $this->userFieldKeyIdField;
    }
    /**
     * Set userFieldKeyIdField value
     * @param int $userFieldKeyIdField
     * @return \StructType\AccountMasterDetailsAccountUserFlds
     */
    public function setUserFieldKeyIdField($userFieldKeyIdField = null)
    {
        // validation for constraint: int
        if (!is_null($userFieldKeyIdField) && !(is_int($userFieldKeyIdField) || ctype_digit($userFieldKeyIdField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($userFieldKeyIdField, true), gettype($userFieldKeyIdField)), __LINE__);
        }
        $this->userFieldKeyIdField = $userFieldKeyIdField;
        return $this;
    }
}
