<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountMasterDetailsAccountInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AccountMasterDetailsAccountInfo
 * @subpackage Structs
 */
class AccountMasterDetailsAccountInfo extends AbstractStructBase
{
    /**
     * The accountKeyIdField
     * @var int
     */
    public $accountKeyIdField;
    /**
     * The closeTWField
     * @var int
     */
    public $closeTWField;
    /**
     * The contactNameField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $contactNameField;
    /**
     * The defaultEQCodeField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $defaultEQCodeField;
    /**
     * The earlyBufferField
     * @var int
     */
    public $earlyBufferField;
    /**
     * The lateBufferField
     * @var int
     */
    public $lateBufferField;
    /**
     * The penaltyCostField
     * @var float
     */
    public $penaltyCostField;
    /**
     * The phoneField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $phoneField;
    /**
     * The sizeRestrictField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $sizeRestrictField;
    /**
     * The zoneField
     * @var int
     */
    public $zoneField;
    /**
     * Constructor method for AccountMasterDetailsAccountInfo
     * @uses AccountMasterDetailsAccountInfo::setAccountKeyIdField()
     * @uses AccountMasterDetailsAccountInfo::setCloseTWField()
     * @uses AccountMasterDetailsAccountInfo::setContactNameField()
     * @uses AccountMasterDetailsAccountInfo::setDefaultEQCodeField()
     * @uses AccountMasterDetailsAccountInfo::setEarlyBufferField()
     * @uses AccountMasterDetailsAccountInfo::setLateBufferField()
     * @uses AccountMasterDetailsAccountInfo::setPenaltyCostField()
     * @uses AccountMasterDetailsAccountInfo::setPhoneField()
     * @uses AccountMasterDetailsAccountInfo::setSizeRestrictField()
     * @uses AccountMasterDetailsAccountInfo::setZoneField()
     * @param int $accountKeyIdField
     * @param int $closeTWField
     * @param string $contactNameField
     * @param string $defaultEQCodeField
     * @param int $earlyBufferField
     * @param int $lateBufferField
     * @param float $penaltyCostField
     * @param string $phoneField
     * @param string $sizeRestrictField
     * @param int $zoneField
     */
    public function __construct($accountKeyIdField = null, $closeTWField = null, $contactNameField = null, $defaultEQCodeField = null, $earlyBufferField = null, $lateBufferField = null, $penaltyCostField = null, $phoneField = null, $sizeRestrictField = null, $zoneField = null)
    {
        $this
            ->setAccountKeyIdField($accountKeyIdField)
            ->setCloseTWField($closeTWField)
            ->setContactNameField($contactNameField)
            ->setDefaultEQCodeField($defaultEQCodeField)
            ->setEarlyBufferField($earlyBufferField)
            ->setLateBufferField($lateBufferField)
            ->setPenaltyCostField($penaltyCostField)
            ->setPhoneField($phoneField)
            ->setSizeRestrictField($sizeRestrictField)
            ->setZoneField($zoneField);
    }
    /**
     * Get accountKeyIdField value
     * @return int|null
     */
    public function getAccountKeyIdField()
    {
        return $this->accountKeyIdField;
    }
    /**
     * Set accountKeyIdField value
     * @param int $accountKeyIdField
     * @return \StructType\AccountMasterDetailsAccountInfo
     */
    public function setAccountKeyIdField($accountKeyIdField = null)
    {
        // validation for constraint: int
        if (!is_null($accountKeyIdField) && !(is_int($accountKeyIdField) || ctype_digit($accountKeyIdField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountKeyIdField, true), gettype($accountKeyIdField)), __LINE__);
        }
        $this->accountKeyIdField = $accountKeyIdField;
        return $this;
    }
    /**
     * Get closeTWField value
     * @return int|null
     */
    public function getCloseTWField()
    {
        return $this->closeTWField;
    }
    /**
     * Set closeTWField value
     * @param int $closeTWField
     * @return \StructType\AccountMasterDetailsAccountInfo
     */
    public function setCloseTWField($closeTWField = null)
    {
        // validation for constraint: int
        if (!is_null($closeTWField) && !(is_int($closeTWField) || ctype_digit($closeTWField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($closeTWField, true), gettype($closeTWField)), __LINE__);
        }
        $this->closeTWField = $closeTWField;
        return $this;
    }
    /**
     * Get contactNameField value
     * @return string|null
     */
    public function getContactNameField()
    {
        return $this->contactNameField;
    }
    /**
     * Set contactNameField value
     * @param string $contactNameField
     * @return \StructType\AccountMasterDetailsAccountInfo
     */
    public function setContactNameField($contactNameField = null)
    {
        // validation for constraint: string
        if (!is_null($contactNameField) && !is_string($contactNameField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactNameField, true), gettype($contactNameField)), __LINE__);
        }
        $this->contactNameField = $contactNameField;
        return $this;
    }
    /**
     * Get defaultEQCodeField value
     * @return string|null
     */
    public function getDefaultEQCodeField()
    {
        return $this->defaultEQCodeField;
    }
    /**
     * Set defaultEQCodeField value
     * @param string $defaultEQCodeField
     * @return \StructType\AccountMasterDetailsAccountInfo
     */
    public function setDefaultEQCodeField($defaultEQCodeField = null)
    {
        // validation for constraint: string
        if (!is_null($defaultEQCodeField) && !is_string($defaultEQCodeField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultEQCodeField, true), gettype($defaultEQCodeField)), __LINE__);
        }
        $this->defaultEQCodeField = $defaultEQCodeField;
        return $this;
    }
    /**
     * Get earlyBufferField value
     * @return int|null
     */
    public function getEarlyBufferField()
    {
        return $this->earlyBufferField;
    }
    /**
     * Set earlyBufferField value
     * @param int $earlyBufferField
     * @return \StructType\AccountMasterDetailsAccountInfo
     */
    public function setEarlyBufferField($earlyBufferField = null)
    {
        // validation for constraint: int
        if (!is_null($earlyBufferField) && !(is_int($earlyBufferField) || ctype_digit($earlyBufferField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($earlyBufferField, true), gettype($earlyBufferField)), __LINE__);
        }
        $this->earlyBufferField = $earlyBufferField;
        return $this;
    }
    /**
     * Get lateBufferField value
     * @return int|null
     */
    public function getLateBufferField()
    {
        return $this->lateBufferField;
    }
    /**
     * Set lateBufferField value
     * @param int $lateBufferField
     * @return \StructType\AccountMasterDetailsAccountInfo
     */
    public function setLateBufferField($lateBufferField = null)
    {
        // validation for constraint: int
        if (!is_null($lateBufferField) && !(is_int($lateBufferField) || ctype_digit($lateBufferField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lateBufferField, true), gettype($lateBufferField)), __LINE__);
        }
        $this->lateBufferField = $lateBufferField;
        return $this;
    }
    /**
     * Get penaltyCostField value
     * @return float|null
     */
    public function getPenaltyCostField()
    {
        return $this->penaltyCostField;
    }
    /**
     * Set penaltyCostField value
     * @param float $penaltyCostField
     * @return \StructType\AccountMasterDetailsAccountInfo
     */
    public function setPenaltyCostField($penaltyCostField = null)
    {
        // validation for constraint: float
        if (!is_null($penaltyCostField) && !(is_float($penaltyCostField) || is_numeric($penaltyCostField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($penaltyCostField, true), gettype($penaltyCostField)), __LINE__);
        }
        $this->penaltyCostField = $penaltyCostField;
        return $this;
    }
    /**
     * Get phoneField value
     * @return string|null
     */
    public function getPhoneField()
    {
        return $this->phoneField;
    }
    /**
     * Set phoneField value
     * @param string $phoneField
     * @return \StructType\AccountMasterDetailsAccountInfo
     */
    public function setPhoneField($phoneField = null)
    {
        // validation for constraint: string
        if (!is_null($phoneField) && !is_string($phoneField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneField, true), gettype($phoneField)), __LINE__);
        }
        $this->phoneField = $phoneField;
        return $this;
    }
    /**
     * Get sizeRestrictField value
     * @return string|null
     */
    public function getSizeRestrictField()
    {
        return $this->sizeRestrictField;
    }
    /**
     * Set sizeRestrictField value
     * @param string $sizeRestrictField
     * @return \StructType\AccountMasterDetailsAccountInfo
     */
    public function setSizeRestrictField($sizeRestrictField = null)
    {
        // validation for constraint: string
        if (!is_null($sizeRestrictField) && !is_string($sizeRestrictField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sizeRestrictField, true), gettype($sizeRestrictField)), __LINE__);
        }
        $this->sizeRestrictField = $sizeRestrictField;
        return $this;
    }
    /**
     * Get zoneField value
     * @return int|null
     */
    public function getZoneField()
    {
        return $this->zoneField;
    }
    /**
     * Set zoneField value
     * @param int $zoneField
     * @return \StructType\AccountMasterDetailsAccountInfo
     */
    public function setZoneField($zoneField = null)
    {
        // validation for constraint: int
        if (!is_null($zoneField) && !(is_int($zoneField) || ctype_digit($zoneField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($zoneField, true), gettype($zoneField)), __LINE__);
        }
        $this->zoneField = $zoneField;
        return $this;
    }
}
