<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountDetailRequestByDateRangeEnvelope StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AccountDetailRequestByDateRangeEnvelope
 * @subpackage Structs
 */
class AccountDetailRequestByDateRangeEnvelope extends AbstractStructBase
{
    /**
     * The accountDetailReturnOptionsField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\AccountDetailReturnOptions
     */
    public $accountDetailReturnOptionsField;
    /**
     * The branchIDField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $branchIDField;
    /**
     * The fromDateField
     * @var string
     */
    public $fromDateField;
    /**
     * The pageField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $pageField;
    /**
     * The searchByOptionsField
     * @var string
     */
    public $searchByOptionsField;
    /**
     * The toDateField
     * @var string
     */
    public $toDateField;
    /**
     * Constructor method for AccountDetailRequestByDateRangeEnvelope
     * @uses AccountDetailRequestByDateRangeEnvelope::setAccountDetailReturnOptionsField()
     * @uses AccountDetailRequestByDateRangeEnvelope::setBranchIDField()
     * @uses AccountDetailRequestByDateRangeEnvelope::setFromDateField()
     * @uses AccountDetailRequestByDateRangeEnvelope::setPageField()
     * @uses AccountDetailRequestByDateRangeEnvelope::setSearchByOptionsField()
     * @uses AccountDetailRequestByDateRangeEnvelope::setToDateField()
     * @param \StructType\AccountDetailReturnOptions $accountDetailReturnOptionsField
     * @param string $branchIDField
     * @param string $fromDateField
     * @param int $pageField
     * @param string $searchByOptionsField
     * @param string $toDateField
     */
    public function __construct(\StructType\AccountDetailReturnOptions $accountDetailReturnOptionsField = null, $branchIDField = null, $fromDateField = null, $pageField = null, $searchByOptionsField = null, $toDateField = null)
    {
        $this
            ->setAccountDetailReturnOptionsField($accountDetailReturnOptionsField)
            ->setBranchIDField($branchIDField)
            ->setFromDateField($fromDateField)
            ->setPageField($pageField)
            ->setSearchByOptionsField($searchByOptionsField)
            ->setToDateField($toDateField);
    }
    /**
     * Get accountDetailReturnOptionsField value
     * @return \StructType\AccountDetailReturnOptions|null
     */
    public function getAccountDetailReturnOptionsField()
    {
        return $this->accountDetailReturnOptionsField;
    }
    /**
     * Set accountDetailReturnOptionsField value
     * @param \StructType\AccountDetailReturnOptions $accountDetailReturnOptionsField
     * @return \StructType\AccountDetailRequestByDateRangeEnvelope
     */
    public function setAccountDetailReturnOptionsField(\StructType\AccountDetailReturnOptions $accountDetailReturnOptionsField = null)
    {
        $this->accountDetailReturnOptionsField = $accountDetailReturnOptionsField;
        return $this;
    }
    /**
     * Get branchIDField value
     * @return string|null
     */
    public function getBranchIDField()
    {
        return $this->branchIDField;
    }
    /**
     * Set branchIDField value
     * @param string $branchIDField
     * @return \StructType\AccountDetailRequestByDateRangeEnvelope
     */
    public function setBranchIDField($branchIDField = null)
    {
        // validation for constraint: string
        if (!is_null($branchIDField) && !is_string($branchIDField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($branchIDField, true), gettype($branchIDField)), __LINE__);
        }
        $this->branchIDField = $branchIDField;
        return $this;
    }
    /**
     * Get fromDateField value
     * @return string|null
     */
    public function getFromDateField()
    {
        return $this->fromDateField;
    }
    /**
     * Set fromDateField value
     * @param string $fromDateField
     * @return \StructType\AccountDetailRequestByDateRangeEnvelope
     */
    public function setFromDateField($fromDateField = null)
    {
        // validation for constraint: string
        if (!is_null($fromDateField) && !is_string($fromDateField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromDateField, true), gettype($fromDateField)), __LINE__);
        }
        $this->fromDateField = $fromDateField;
        return $this;
    }
    /**
     * Get pageField value
     * @return int|null
     */
    public function getPageField()
    {
        return $this->pageField;
    }
    /**
     * Set pageField value
     * @param int $pageField
     * @return \StructType\AccountDetailRequestByDateRangeEnvelope
     */
    public function setPageField($pageField = null)
    {
        // validation for constraint: int
        if (!is_null($pageField) && !(is_int($pageField) || ctype_digit($pageField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageField, true), gettype($pageField)), __LINE__);
        }
        $this->pageField = $pageField;
        return $this;
    }
    /**
     * Get searchByOptionsField value
     * @return string|null
     */
    public function getSearchByOptionsField()
    {
        return $this->searchByOptionsField;
    }
    /**
     * Set searchByOptionsField value
     * @uses \EnumType\AccountDetailSearchByOptions::valueIsValid()
     * @uses \EnumType\AccountDetailSearchByOptions::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $searchByOptionsField
     * @return \StructType\AccountDetailRequestByDateRangeEnvelope
     */
    public function setSearchByOptionsField($searchByOptionsField = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AccountDetailSearchByOptions::valueIsValid($searchByOptionsField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AccountDetailSearchByOptions', is_array($searchByOptionsField) ? implode(', ', $searchByOptionsField) : var_export($searchByOptionsField, true), implode(', ', \EnumType\AccountDetailSearchByOptions::getValidValues())), __LINE__);
        }
        $this->searchByOptionsField = $searchByOptionsField;
        return $this;
    }
    /**
     * Get toDateField value
     * @return string|null
     */
    public function getToDateField()
    {
        return $this->toDateField;
    }
    /**
     * Set toDateField value
     * @param string $toDateField
     * @return \StructType\AccountDetailRequestByDateRangeEnvelope
     */
    public function setToDateField($toDateField = null)
    {
        // validation for constraint: string
        if (!is_null($toDateField) && !is_string($toDateField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toDateField, true), gettype($toDateField)), __LINE__);
        }
        $this->toDateField = $toDateField;
        return $this;
    }
}
