<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Unlock ServiceType
 * @subpackage Services
 */
class Unlock extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named UnlockStops
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UnlockStops $parameters
     * @return \StructType\UnlockStopsResponse|bool
     */
    public function UnlockStops(\StructType\UnlockStops $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UnlockStops($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UnlockStopsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
