<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetAuthenticationToken
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAuthenticationToken $parameters
     * @return \StructType\GetAuthenticationTokenResponse|bool
     */
    public function GetAuthenticationToken(\StructType\GetAuthenticationToken $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAuthenticationToken($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBranches
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBranches $parameters
     * @return \StructType\GetBranchesResponse|bool
     */
    public function GetBranches(\StructType\GetBranches $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetBranches($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetForms
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetForms $parameters
     * @return \StructType\GetFormsResponse|bool
     */
    public function GetForms(\StructType\GetForms $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetForms($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRouteSummaryByPlannedStartDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRouteSummaryByPlannedStartDate $parameters
     * @return \StructType\GetRouteSummaryByPlannedStartDateResponse|bool
     */
    public function GetRouteSummaryByPlannedStartDate(\StructType\GetRouteSummaryByPlannedStartDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRouteSummaryByPlannedStartDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRouteDetailByPlannedStartDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRouteDetailByPlannedStartDate $parameters
     * @return \StructType\GetRouteDetailByPlannedStartDateResponse|bool
     */
    public function GetRouteDetailByPlannedStartDate(\StructType\GetRouteDetailByPlannedStartDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRouteDetailByPlannedStartDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRouteDetailByModifiedDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRouteDetailByModifiedDate $parameters
     * @return \StructType\GetRouteDetailByModifiedDateResponse|bool
     */
    public function GetRouteDetailByModifiedDate(\StructType\GetRouteDetailByModifiedDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRouteDetailByModifiedDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetRouteDetailAndBranchIdByModifiedDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRouteDetailAndBranchIdByModifiedDate $parameters
     * @return \StructType\GetRouteDetailAndBranchIdByModifiedDateResponse|bool
     */
    public function GetRouteDetailAndBranchIdByModifiedDate(\StructType\GetRouteDetailAndBranchIdByModifiedDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRouteDetailAndBranchIdByModifiedDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRouteDetailByDateRange
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRouteDetailByDateRange $parameters
     * @return \StructType\GetRouteDetailByDateRangeResponse|bool
     */
    public function GetRouteDetailByDateRange(\StructType\GetRouteDetailByDateRange $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRouteDetailByDateRange($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOrderDetailByDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOrderDetailByDate $parameters
     * @return \StructType\GetOrderDetailByDateResponse|bool
     */
    public function GetOrderDetailByDate(\StructType\GetOrderDetailByDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetOrderDetailByDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOrderDetailByModifiedDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOrderDetailByModifiedDate $parameters
     * @return \StructType\GetOrderDetailByModifiedDateResponse|bool
     */
    public function GetOrderDetailByModifiedDate(\StructType\GetOrderDetailByModifiedDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetOrderDetailByModifiedDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetOrderDetailsByModifiedDateAndBranchIds
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOrderDetailsByModifiedDateAndBranchIds $parameters
     * @return \StructType\GetOrderDetailsByModifiedDateAndBranchIdsResponse|bool
     */
    public function GetOrderDetailsByModifiedDateAndBranchIds(\StructType\GetOrderDetailsByModifiedDateAndBranchIds $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetOrderDetailsByModifiedDateAndBranchIds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUserAndQuantityFields
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetUserAndQuantityFields $parameters
     * @return \StructType\GetUserAndQuantityFieldsResponse|bool
     */
    public function GetUserAndQuantityFields(\StructType\GetUserAndQuantityFields $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetUserAndQuantityFields($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAccountDetailsByBranch
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAccountDetailsByBranch $parameters
     * @return \StructType\GetAccountDetailsByBranchResponse|bool
     */
    public function GetAccountDetailsByBranch(\StructType\GetAccountDetailsByBranch $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAccountDetailsByBranch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetAccountDetailsByModifiedDateAndBranch
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAccountDetailsByModifiedDateAndBranch $parameters
     * @return \StructType\GetAccountDetailsByModifiedDateAndBranchResponse|bool
     */
    public function GetAccountDetailsByModifiedDateAndBranch(\StructType\GetAccountDetailsByModifiedDateAndBranch $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAccountDetailsByModifiedDateAndBranch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOrderDetailsByOrderIds
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOrderDetailsByOrderIds $parameters
     * @return \StructType\GetOrderDetailsByOrderIdsResponse|bool
     */
    public function GetOrderDetailsByOrderIds(\StructType\GetOrderDetailsByOrderIds $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetOrderDetailsByOrderIds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOrderDetailsAndEventsByOrderIDs
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOrderDetailsAndEventsByOrderIDs $parameters
     * @return \StructType\GetOrderDetailsAndEventsByOrderIDsResponse|bool
     */
    public function GetOrderDetailsAndEventsByOrderIDs(\StructType\GetOrderDetailsAndEventsByOrderIDs $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetOrderDetailsAndEventsByOrderIDs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOrderEventsByTypeAndDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOrderEventsByTypeAndDate $parameters
     * @return \StructType\GetOrderEventsByTypeAndDateResponse|bool
     */
    public function GetOrderEventsByTypeAndDate(\StructType\GetOrderEventsByTypeAndDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetOrderEventsByTypeAndDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMasterRoutes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMasterRoutes $parameters
     * @return \StructType\GetMasterRoutesResponse|bool
     */
    public function GetMasterRoutes(\StructType\GetMasterRoutes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMasterRoutes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTruckProfiles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTruckProfiles $parameters
     * @return \StructType\GetTruckProfilesResponse|bool
     */
    public function GetTruckProfiles(\StructType\GetTruckProfiles $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTruckProfiles($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetMaxRouteDetailByBranchAndDispatchDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMaxRouteDetailByBranchAndDispatchDate $parameters
     * @return \StructType\GetMaxRouteDetailByBranchAndDispatchDateResponse|bool
     */
    public function GetMaxRouteDetailByBranchAndDispatchDate(\StructType\GetMaxRouteDetailByBranchAndDispatchDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMaxRouteDetailByBranchAndDispatchDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCostingRulesByBranch
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCostingRulesByBranch $parameters
     * @return \StructType\GetCostingRulesByBranchResponse|bool
     */
    public function GetCostingRulesByBranch(\StructType\GetCostingRulesByBranch $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCostingRulesByBranch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetAccountDetailsByBranchResponse|\StructType\GetAccountDetailsByModifiedDateAndBranchResponse|\StructType\GetAuthenticationTokenResponse|\StructType\GetBranchesResponse|\StructType\GetCostingRulesByBranchResponse|\StructType\GetFormsResponse|\StructType\GetMasterRoutesResponse|\StructType\GetMaxRouteDetailByBranchAndDispatchDateResponse|\StructType\GetOrderDetailByDateResponse|\StructType\GetOrderDetailByModifiedDateResponse|\StructType\GetOrderDetailsAndEventsByOrderIDsResponse|\StructType\GetOrderDetailsByModifiedDateAndBranchIdsResponse|\StructType\GetOrderDetailsByOrderIdsResponse|\StructType\GetOrderEventsByTypeAndDateResponse|\StructType\GetRouteDetailAndBranchIdByModifiedDateResponse|\StructType\GetRouteDetailByDateRangeResponse|\StructType\GetRouteDetailByModifiedDateResponse|\StructType\GetRouteDetailByPlannedStartDateResponse|\StructType\GetRouteSummaryByPlannedStartDateResponse|\StructType\GetTruckProfilesResponse|\StructType\GetUserAndQuantityFieldsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
