<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Build ServiceType
 * @subpackage Services
 */
class Build extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named BuildRouteFromOrderIds
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\BuildRouteFromOrderIds $parameters
     * @return \StructType\BuildRouteFromOrderIdsResponse|bool
     */
    public function BuildRouteFromOrderIds(\StructType\BuildRouteFromOrderIds $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->BuildRouteFromOrderIds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\BuildRouteFromOrderIdsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
