<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPhotoResource ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfPhotoResource
 * @subpackage Arrays
 */
class ArrayOfPhotoResource extends AbstractStructArrayBase
{
    /**
     * The PhotoResource
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PhotoResource[]
     */
    public $PhotoResource;
    /**
     * Constructor method for ArrayOfPhotoResource
     * @uses ArrayOfPhotoResource::setPhotoResource()
     * @param \StructType\PhotoResource[] $photoResource
     */
    public function __construct(array $photoResource = array())
    {
        $this
            ->setPhotoResource($photoResource);
    }
    /**
     * Get PhotoResource value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PhotoResource[]|null
     */
    public function getPhotoResource()
    {
        return isset($this->PhotoResource) ? $this->PhotoResource : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPhotoResource method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPhotoResource method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePhotoResourceForArrayConstraintsFromSetPhotoResource(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPhotoResourcePhotoResourceItem) {
            // validation for constraint: itemType
            if (!$arrayOfPhotoResourcePhotoResourceItem instanceof \StructType\PhotoResource) {
                $invalidValues[] = is_object($arrayOfPhotoResourcePhotoResourceItem) ? get_class($arrayOfPhotoResourcePhotoResourceItem) : sprintf('%s(%s)', gettype($arrayOfPhotoResourcePhotoResourceItem), var_export($arrayOfPhotoResourcePhotoResourceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PhotoResource property can only contain items of type \StructType\PhotoResource, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PhotoResource value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PhotoResource[] $photoResource
     * @return \ArrayType\ArrayOfPhotoResource
     */
    public function setPhotoResource(array $photoResource = array())
    {
        // validation for constraint: array
        if ('' !== ($photoResourceArrayErrorMessage = self::validatePhotoResourceForArrayConstraintsFromSetPhotoResource($photoResource))) {
            throw new \InvalidArgumentException($photoResourceArrayErrorMessage, __LINE__);
        }
        if (is_null($photoResource) || (is_array($photoResource) && empty($photoResource))) {
            unset($this->PhotoResource);
        } else {
            $this->PhotoResource = $photoResource;
        }
        return $this;
    }
    /**
     * Add item to PhotoResource value
     * @throws \InvalidArgumentException
     * @param \StructType\PhotoResource $item
     * @return \ArrayType\ArrayOfPhotoResource
     */
    public function addToPhotoResource(\StructType\PhotoResource $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PhotoResource) {
            throw new \InvalidArgumentException(sprintf('The PhotoResource property can only contain items of type \StructType\PhotoResource, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PhotoResource[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PhotoResource|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PhotoResource|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PhotoResource|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PhotoResource|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PhotoResource|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PhotoResource
     */
    public function getAttributeName()
    {
        return 'PhotoResource';
    }
}
