<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Resource StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Resource
 * @subpackage Structs
 */
class _Resource extends AbstractStructBase
{
    /**
     * The createdField
     * @var string
     */
    public $createdField;
    /**
     * The gUIDField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $gUIDField;
    /**
     * The uRLField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $uRLField;
    /**
     * Constructor method for Resource
     * @uses _Resource::setCreatedField()
     * @uses _Resource::setGUIDField()
     * @uses _Resource::setURLField()
     * @param string $createdField
     * @param string $gUIDField
     * @param string $uRLField
     */
    public function __construct($createdField = null, $gUIDField = null, $uRLField = null)
    {
        $this
            ->setCreatedField($createdField)
            ->setGUIDField($gUIDField)
            ->setURLField($uRLField);
    }
    /**
     * Get createdField value
     * @return string|null
     */
    public function getCreatedField()
    {
        return $this->createdField;
    }
    /**
     * Set createdField value
     * @param string $createdField
     * @return \StructType\_Resource
     */
    public function setCreatedField($createdField = null)
    {
        // validation for constraint: string
        if (!is_null($createdField) && !is_string($createdField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdField, true), gettype($createdField)), __LINE__);
        }
        $this->createdField = $createdField;
        return $this;
    }
    /**
     * Get gUIDField value
     * @return string|null
     */
    public function getGUIDField()
    {
        return $this->gUIDField;
    }
    /**
     * Set gUIDField value
     * @param string $gUIDField
     * @return \StructType\_Resource
     */
    public function setGUIDField($gUIDField = null)
    {
        // validation for constraint: string
        if (!is_null($gUIDField) && !is_string($gUIDField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gUIDField, true), gettype($gUIDField)), __LINE__);
        }
        $this->gUIDField = $gUIDField;
        return $this;
    }
    /**
     * Get uRLField value
     * @return string|null
     */
    public function getURLField()
    {
        return $this->uRLField;
    }
    /**
     * Set uRLField value
     * @param string $uRLField
     * @return \StructType\_Resource
     */
    public function setURLField($uRLField = null)
    {
        // validation for constraint: string
        if (!is_null($uRLField) && !is_string($uRLField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uRLField, true), gettype($uRLField)), __LINE__);
        }
        $this->uRLField = $uRLField;
        return $this;
    }
}
