<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ViolationsTypeLeg StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ViolationsTypeLeg
 * @subpackage Structs
 */
class ViolationsTypeLeg extends AbstractStructBase
{
    /**
     * The numField
     * @var int
     */
    public $numField;
    /**
     * The numFieldSpecified
     * @var bool
     */
    public $numFieldSpecified;
    /**
     * The violationField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $violationField;
    /**
     * Constructor method for ViolationsTypeLeg
     * @uses ViolationsTypeLeg::setNumField()
     * @uses ViolationsTypeLeg::setNumFieldSpecified()
     * @uses ViolationsTypeLeg::setViolationField()
     * @param int $numField
     * @param bool $numFieldSpecified
     * @param \ArrayType\ArrayOfstring $violationField
     */
    public function __construct($numField = null, $numFieldSpecified = null, \ArrayType\ArrayOfstring $violationField = null)
    {
        $this
            ->setNumField($numField)
            ->setNumFieldSpecified($numFieldSpecified)
            ->setViolationField($violationField);
    }
    /**
     * Get numField value
     * @return int|null
     */
    public function getNumField()
    {
        return $this->numField;
    }
    /**
     * Set numField value
     * @param int $numField
     * @return \StructType\ViolationsTypeLeg
     */
    public function setNumField($numField = null)
    {
        // validation for constraint: int
        if (!is_null($numField) && !(is_int($numField) || ctype_digit($numField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numField, true), gettype($numField)), __LINE__);
        }
        $this->numField = $numField;
        return $this;
    }
    /**
     * Get numFieldSpecified value
     * @return bool|null
     */
    public function getNumFieldSpecified()
    {
        return $this->numFieldSpecified;
    }
    /**
     * Set numFieldSpecified value
     * @param bool $numFieldSpecified
     * @return \StructType\ViolationsTypeLeg
     */
    public function setNumFieldSpecified($numFieldSpecified = null)
    {
        // validation for constraint: boolean
        if (!is_null($numFieldSpecified) && !is_bool($numFieldSpecified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($numFieldSpecified, true), gettype($numFieldSpecified)), __LINE__);
        }
        $this->numFieldSpecified = $numFieldSpecified;
        return $this;
    }
    /**
     * Get violationField value
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getViolationField()
    {
        return $this->violationField;
    }
    /**
     * Set violationField value
     * @param \ArrayType\ArrayOfstring $violationField
     * @return \StructType\ViolationsTypeLeg
     */
    public function setViolationField(\ArrayType\ArrayOfstring $violationField = null)
    {
        $this->violationField = $violationField;
        return $this;
    }
}
