<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateAccountEmailEventRequestEnvelope StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UpdateAccountEmailEventRequestEnvelope
 * @subpackage Structs
 */
class UpdateAccountEmailEventRequestEnvelope extends AbstractStructBase
{
    /**
     * The AccountEmailEventList
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfAccountEmailEvent
     */
    public $AccountEmailEventList;
    /**
     * The Command
     * @var string
     */
    public $Command;
    /**
     * The accountIDField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $accountIDField;
    /**
     * The branchIDField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $branchIDField;
    /**
     * Constructor method for UpdateAccountEmailEventRequestEnvelope
     * @uses UpdateAccountEmailEventRequestEnvelope::setAccountEmailEventList()
     * @uses UpdateAccountEmailEventRequestEnvelope::setCommand()
     * @uses UpdateAccountEmailEventRequestEnvelope::setAccountIDField()
     * @uses UpdateAccountEmailEventRequestEnvelope::setBranchIDField()
     * @param \ArrayType\ArrayOfAccountEmailEvent $accountEmailEventList
     * @param string $command
     * @param string $accountIDField
     * @param string $branchIDField
     */
    public function __construct(\ArrayType\ArrayOfAccountEmailEvent $accountEmailEventList = null, $command = null, $accountIDField = null, $branchIDField = null)
    {
        $this
            ->setAccountEmailEventList($accountEmailEventList)
            ->setCommand($command)
            ->setAccountIDField($accountIDField)
            ->setBranchIDField($branchIDField);
    }
    /**
     * Get AccountEmailEventList value
     * @return \ArrayType\ArrayOfAccountEmailEvent|null
     */
    public function getAccountEmailEventList()
    {
        return $this->AccountEmailEventList;
    }
    /**
     * Set AccountEmailEventList value
     * @param \ArrayType\ArrayOfAccountEmailEvent $accountEmailEventList
     * @return \StructType\UpdateAccountEmailEventRequestEnvelope
     */
    public function setAccountEmailEventList(\ArrayType\ArrayOfAccountEmailEvent $accountEmailEventList = null)
    {
        $this->AccountEmailEventList = $accountEmailEventList;
        return $this;
    }
    /**
     * Get Command value
     * @return string|null
     */
    public function getCommand()
    {
        return $this->Command;
    }
    /**
     * Set Command value
     * @uses \EnumType\AccountEmailCommand::valueIsValid()
     * @uses \EnumType\AccountEmailCommand::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $command
     * @return \StructType\UpdateAccountEmailEventRequestEnvelope
     */
    public function setCommand($command = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AccountEmailCommand::valueIsValid($command)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AccountEmailCommand', is_array($command) ? implode(', ', $command) : var_export($command, true), implode(', ', \EnumType\AccountEmailCommand::getValidValues())), __LINE__);
        }
        $this->Command = $command;
        return $this;
    }
    /**
     * Get accountIDField value
     * @return string|null
     */
    public function getAccountIDField()
    {
        return $this->accountIDField;
    }
    /**
     * Set accountIDField value
     * @param string $accountIDField
     * @return \StructType\UpdateAccountEmailEventRequestEnvelope
     */
    public function setAccountIDField($accountIDField = null)
    {
        // validation for constraint: string
        if (!is_null($accountIDField) && !is_string($accountIDField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountIDField, true), gettype($accountIDField)), __LINE__);
        }
        $this->accountIDField = $accountIDField;
        return $this;
    }
    /**
     * Get branchIDField value
     * @return string|null
     */
    public function getBranchIDField()
    {
        return $this->branchIDField;
    }
    /**
     * Set branchIDField value
     * @param string $branchIDField
     * @return \StructType\UpdateAccountEmailEventRequestEnvelope
     */
    public function setBranchIDField($branchIDField = null)
    {
        // validation for constraint: string
        if (!is_null($branchIDField) && !is_string($branchIDField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($branchIDField, true), gettype($branchIDField)), __LINE__);
        }
        $this->branchIDField = $branchIDField;
        return $this;
    }
}
