<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Truck StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Truck
 * @subpackage Structs
 */
class Truck extends AbstractStructBase
{
    /**
     * The aMAdjField
     * @var int
     */
    public $aMAdjField;
    /**
     * The aMEndField
     * @var string
     */
    public $aMEndField;
    /**
     * The aMStartField
     * @var string
     */
    public $aMStartField;
    /**
     * The absStartTmField
     * @var string
     */
    public $absStartTmField;
    /**
     * The addressField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $addressField;
    /**
     * The availableField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var bool
     */
    public $availableField;
    /**
     * The branchField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $branchField;
    /**
     * The breakTimeField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfBreakTime
     */
    public $breakTimeField;
    /**
     * The cityField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $cityField;
    /**
     * The colorField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $colorField;
    /**
     * The countryField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $countryField;
    /**
     * The driverField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $driverField;
    /**
     * The dropCostField
     * @var float
     */
    public $dropCostField;
    /**
     * The eDayField
     * @var int
     */
    public $eDayField;
    /**
     * The earStartField
     * @var string
     */
    public $earStartField;
    /**
     * The eqCodeField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $eqCodeField;
    /**
     * The fixedCostField
     * @var float
     */
    public $fixedCostField;
    /**
     * The geoResultField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $geoResultField;
    /**
     * The hrCostField
     * @var float
     */
    public $hrCostField;
    /**
     * The keyField
     * @var int
     */
    public $keyField;
    /**
     * The lDayField
     * @var int
     */
    public $lDayField;
    /**
     * The latFinishField
     * @var string
     */
    public $latFinishField;
    /**
     * The latStartField
     * @var string
     */
    public $latStartField;
    /**
     * The latitudeField
     * @var float
     */
    public $latitudeField;
    /**
     * The layoverCostField
     * @var float
     */
    public $layoverCostField;
    /**
     * The longitudeField
     * @var float
     */
    public $longitudeField;
    /**
     * The maxDrvTmB4LayoverField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $maxDrvTmB4LayoverField;
    /**
     * The maxDrvTmField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $maxDrvTmField;
    /**
     * The maxLayoverTmField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $maxLayoverTmField;
    /**
     * The maxLayoversField
     * @var int
     */
    public $maxLayoversField;
    /**
     * The maxWorkTmField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $maxWorkTmField;
    /**
     * The miCostField
     * @var float
     */
    public $miCostField;
    /**
     * The minLayoverTmField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $minLayoverTmField;
    /**
     * The minTmField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $minTmField;
    /**
     * The normalStartField
     * @var string
     */
    public $normalStartField;
    /**
     * The oneWayField
     * @var bool
     */
    public $oneWayField;
    /**
     * The overTimeField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfOverTime
     */
    public $overTimeField;
    /**
     * The pMAdjField
     * @var int
     */
    public $pMAdjField;
    /**
     * The pMEndField
     * @var string
     */
    public $pMEndField;
    /**
     * The pMStartField
     * @var string
     */
    public $pMStartField;
    /**
     * The postTripTmField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $postTripTmField;
    /**
     * The preTripTmField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $preTripTmField;
    /**
     * The redispatchField
     * @var bool
     */
    public $redispatchField;
    /**
     * The stateField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $stateField;
    /**
     * The statusField
     * @var int
     */
    public $statusField;
    /**
     * The targetWrkTmField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $targetWrkTmField;
    /**
     * The trkIdField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $trkIdField;
    /**
     * The turnTmField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $turnTmField;
    /**
     * The unitCostField
     * @var float
     */
    public $unitCostField;
    /**
     * The unldHrCostField
     * @var float
     */
    public $unldHrCostField;
    /**
     * The unldPerfField
     * @var int
     */
    public $unldPerfField;
    /**
     * The userFieldField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfUserField
     */
    public $userFieldField;
    /**
     * The volumeField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfVolume
     */
    public $volumeField;
    /**
     * The waitHrCostField
     * @var float
     */
    public $waitHrCostField;
    /**
     * The workHrsField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $workHrsField;
    /**
     * The zipField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $zipField;
    /**
     * The zoneField
     * @var int
     */
    public $zoneField;
    /**
     * Constructor method for Truck
     * @uses Truck::setAMAdjField()
     * @uses Truck::setAMEndField()
     * @uses Truck::setAMStartField()
     * @uses Truck::setAbsStartTmField()
     * @uses Truck::setAddressField()
     * @uses Truck::setAvailableField()
     * @uses Truck::setBranchField()
     * @uses Truck::setBreakTimeField()
     * @uses Truck::setCityField()
     * @uses Truck::setColorField()
     * @uses Truck::setCountryField()
     * @uses Truck::setDriverField()
     * @uses Truck::setDropCostField()
     * @uses Truck::setEDayField()
     * @uses Truck::setEarStartField()
     * @uses Truck::setEqCodeField()
     * @uses Truck::setFixedCostField()
     * @uses Truck::setGeoResultField()
     * @uses Truck::setHrCostField()
     * @uses Truck::setKeyField()
     * @uses Truck::setLDayField()
     * @uses Truck::setLatFinishField()
     * @uses Truck::setLatStartField()
     * @uses Truck::setLatitudeField()
     * @uses Truck::setLayoverCostField()
     * @uses Truck::setLongitudeField()
     * @uses Truck::setMaxDrvTmB4LayoverField()
     * @uses Truck::setMaxDrvTmField()
     * @uses Truck::setMaxLayoverTmField()
     * @uses Truck::setMaxLayoversField()
     * @uses Truck::setMaxWorkTmField()
     * @uses Truck::setMiCostField()
     * @uses Truck::setMinLayoverTmField()
     * @uses Truck::setMinTmField()
     * @uses Truck::setNormalStartField()
     * @uses Truck::setOneWayField()
     * @uses Truck::setOverTimeField()
     * @uses Truck::setPMAdjField()
     * @uses Truck::setPMEndField()
     * @uses Truck::setPMStartField()
     * @uses Truck::setPostTripTmField()
     * @uses Truck::setPreTripTmField()
     * @uses Truck::setRedispatchField()
     * @uses Truck::setStateField()
     * @uses Truck::setStatusField()
     * @uses Truck::setTargetWrkTmField()
     * @uses Truck::setTrkIdField()
     * @uses Truck::setTurnTmField()
     * @uses Truck::setUnitCostField()
     * @uses Truck::setUnldHrCostField()
     * @uses Truck::setUnldPerfField()
     * @uses Truck::setUserFieldField()
     * @uses Truck::setVolumeField()
     * @uses Truck::setWaitHrCostField()
     * @uses Truck::setWorkHrsField()
     * @uses Truck::setZipField()
     * @uses Truck::setZoneField()
     * @param int $aMAdjField
     * @param string $aMEndField
     * @param string $aMStartField
     * @param string $absStartTmField
     * @param string $addressField
     * @param bool $availableField
     * @param string $branchField
     * @param \ArrayType\ArrayOfBreakTime $breakTimeField
     * @param string $cityField
     * @param string $colorField
     * @param string $countryField
     * @param string $driverField
     * @param float $dropCostField
     * @param int $eDayField
     * @param string $earStartField
     * @param string $eqCodeField
     * @param float $fixedCostField
     * @param string $geoResultField
     * @param float $hrCostField
     * @param int $keyField
     * @param int $lDayField
     * @param string $latFinishField
     * @param string $latStartField
     * @param float $latitudeField
     * @param float $layoverCostField
     * @param float $longitudeField
     * @param string $maxDrvTmB4LayoverField
     * @param string $maxDrvTmField
     * @param string $maxLayoverTmField
     * @param int $maxLayoversField
     * @param string $maxWorkTmField
     * @param float $miCostField
     * @param string $minLayoverTmField
     * @param string $minTmField
     * @param string $normalStartField
     * @param bool $oneWayField
     * @param \ArrayType\ArrayOfOverTime $overTimeField
     * @param int $pMAdjField
     * @param string $pMEndField
     * @param string $pMStartField
     * @param string $postTripTmField
     * @param string $preTripTmField
     * @param bool $redispatchField
     * @param string $stateField
     * @param int $statusField
     * @param string $targetWrkTmField
     * @param string $trkIdField
     * @param string $turnTmField
     * @param float $unitCostField
     * @param float $unldHrCostField
     * @param int $unldPerfField
     * @param \ArrayType\ArrayOfUserField $userFieldField
     * @param \ArrayType\ArrayOfVolume $volumeField
     * @param float $waitHrCostField
     * @param string $workHrsField
     * @param string $zipField
     * @param int $zoneField
     */
    public function __construct($aMAdjField = null, $aMEndField = null, $aMStartField = null, $absStartTmField = null, $addressField = null, $availableField = null, $branchField = null, \ArrayType\ArrayOfBreakTime $breakTimeField = null, $cityField = null, $colorField = null, $countryField = null, $driverField = null, $dropCostField = null, $eDayField = null, $earStartField = null, $eqCodeField = null, $fixedCostField = null, $geoResultField = null, $hrCostField = null, $keyField = null, $lDayField = null, $latFinishField = null, $latStartField = null, $latitudeField = null, $layoverCostField = null, $longitudeField = null, $maxDrvTmB4LayoverField = null, $maxDrvTmField = null, $maxLayoverTmField = null, $maxLayoversField = null, $maxWorkTmField = null, $miCostField = null, $minLayoverTmField = null, $minTmField = null, $normalStartField = null, $oneWayField = null, \ArrayType\ArrayOfOverTime $overTimeField = null, $pMAdjField = null, $pMEndField = null, $pMStartField = null, $postTripTmField = null, $preTripTmField = null, $redispatchField = null, $stateField = null, $statusField = null, $targetWrkTmField = null, $trkIdField = null, $turnTmField = null, $unitCostField = null, $unldHrCostField = null, $unldPerfField = null, \ArrayType\ArrayOfUserField $userFieldField = null, \ArrayType\ArrayOfVolume $volumeField = null, $waitHrCostField = null, $workHrsField = null, $zipField = null, $zoneField = null)
    {
        $this
            ->setAMAdjField($aMAdjField)
            ->setAMEndField($aMEndField)
            ->setAMStartField($aMStartField)
            ->setAbsStartTmField($absStartTmField)
            ->setAddressField($addressField)
            ->setAvailableField($availableField)
            ->setBranchField($branchField)
            ->setBreakTimeField($breakTimeField)
            ->setCityField($cityField)
            ->setColorField($colorField)
            ->setCountryField($countryField)
            ->setDriverField($driverField)
            ->setDropCostField($dropCostField)
            ->setEDayField($eDayField)
            ->setEarStartField($earStartField)
            ->setEqCodeField($eqCodeField)
            ->setFixedCostField($fixedCostField)
            ->setGeoResultField($geoResultField)
            ->setHrCostField($hrCostField)
            ->setKeyField($keyField)
            ->setLDayField($lDayField)
            ->setLatFinishField($latFinishField)
            ->setLatStartField($latStartField)
            ->setLatitudeField($latitudeField)
            ->setLayoverCostField($layoverCostField)
            ->setLongitudeField($longitudeField)
            ->setMaxDrvTmB4LayoverField($maxDrvTmB4LayoverField)
            ->setMaxDrvTmField($maxDrvTmField)
            ->setMaxLayoverTmField($maxLayoverTmField)
            ->setMaxLayoversField($maxLayoversField)
            ->setMaxWorkTmField($maxWorkTmField)
            ->setMiCostField($miCostField)
            ->setMinLayoverTmField($minLayoverTmField)
            ->setMinTmField($minTmField)
            ->setNormalStartField($normalStartField)
            ->setOneWayField($oneWayField)
            ->setOverTimeField($overTimeField)
            ->setPMAdjField($pMAdjField)
            ->setPMEndField($pMEndField)
            ->setPMStartField($pMStartField)
            ->setPostTripTmField($postTripTmField)
            ->setPreTripTmField($preTripTmField)
            ->setRedispatchField($redispatchField)
            ->setStateField($stateField)
            ->setStatusField($statusField)
            ->setTargetWrkTmField($targetWrkTmField)
            ->setTrkIdField($trkIdField)
            ->setTurnTmField($turnTmField)
            ->setUnitCostField($unitCostField)
            ->setUnldHrCostField($unldHrCostField)
            ->setUnldPerfField($unldPerfField)
            ->setUserFieldField($userFieldField)
            ->setVolumeField($volumeField)
            ->setWaitHrCostField($waitHrCostField)
            ->setWorkHrsField($workHrsField)
            ->setZipField($zipField)
            ->setZoneField($zoneField);
    }
    /**
     * Get aMAdjField value
     * @return int|null
     */
    public function getAMAdjField()
    {
        return $this->aMAdjField;
    }
    /**
     * Set aMAdjField value
     * @param int $aMAdjField
     * @return \StructType\Truck
     */
    public function setAMAdjField($aMAdjField = null)
    {
        // validation for constraint: int
        if (!is_null($aMAdjField) && !(is_int($aMAdjField) || ctype_digit($aMAdjField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aMAdjField, true), gettype($aMAdjField)), __LINE__);
        }
        $this->aMAdjField = $aMAdjField;
        return $this;
    }
    /**
     * Get aMEndField value
     * @return string|null
     */
    public function getAMEndField()
    {
        return $this->aMEndField;
    }
    /**
     * Set aMEndField value
     * @param string $aMEndField
     * @return \StructType\Truck
     */
    public function setAMEndField($aMEndField = null)
    {
        // validation for constraint: string
        if (!is_null($aMEndField) && !is_string($aMEndField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aMEndField, true), gettype($aMEndField)), __LINE__);
        }
        $this->aMEndField = $aMEndField;
        return $this;
    }
    /**
     * Get aMStartField value
     * @return string|null
     */
    public function getAMStartField()
    {
        return $this->aMStartField;
    }
    /**
     * Set aMStartField value
     * @param string $aMStartField
     * @return \StructType\Truck
     */
    public function setAMStartField($aMStartField = null)
    {
        // validation for constraint: string
        if (!is_null($aMStartField) && !is_string($aMStartField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aMStartField, true), gettype($aMStartField)), __LINE__);
        }
        $this->aMStartField = $aMStartField;
        return $this;
    }
    /**
     * Get absStartTmField value
     * @return string|null
     */
    public function getAbsStartTmField()
    {
        return $this->absStartTmField;
    }
    /**
     * Set absStartTmField value
     * @param string $absStartTmField
     * @return \StructType\Truck
     */
    public function setAbsStartTmField($absStartTmField = null)
    {
        // validation for constraint: string
        if (!is_null($absStartTmField) && !is_string($absStartTmField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($absStartTmField, true), gettype($absStartTmField)), __LINE__);
        }
        $this->absStartTmField = $absStartTmField;
        return $this;
    }
    /**
     * Get addressField value
     * @return string|null
     */
    public function getAddressField()
    {
        return $this->addressField;
    }
    /**
     * Set addressField value
     * @param string $addressField
     * @return \StructType\Truck
     */
    public function setAddressField($addressField = null)
    {
        // validation for constraint: string
        if (!is_null($addressField) && !is_string($addressField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressField, true), gettype($addressField)), __LINE__);
        }
        $this->addressField = $addressField;
        return $this;
    }
    /**
     * Get availableField value
     * @return bool|null
     */
    public function getAvailableField()
    {
        return $this->availableField;
    }
    /**
     * Set availableField value
     * @param bool $availableField
     * @return \StructType\Truck
     */
    public function setAvailableField($availableField = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableField) && !is_bool($availableField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($availableField, true), gettype($availableField)), __LINE__);
        }
        $this->availableField = $availableField;
        return $this;
    }
    /**
     * Get branchField value
     * @return string|null
     */
    public function getBranchField()
    {
        return $this->branchField;
    }
    /**
     * Set branchField value
     * @param string $branchField
     * @return \StructType\Truck
     */
    public function setBranchField($branchField = null)
    {
        // validation for constraint: string
        if (!is_null($branchField) && !is_string($branchField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($branchField, true), gettype($branchField)), __LINE__);
        }
        $this->branchField = $branchField;
        return $this;
    }
    /**
     * Get breakTimeField value
     * @return \ArrayType\ArrayOfBreakTime|null
     */
    public function getBreakTimeField()
    {
        return $this->breakTimeField;
    }
    /**
     * Set breakTimeField value
     * @param \ArrayType\ArrayOfBreakTime $breakTimeField
     * @return \StructType\Truck
     */
    public function setBreakTimeField(\ArrayType\ArrayOfBreakTime $breakTimeField = null)
    {
        $this->breakTimeField = $breakTimeField;
        return $this;
    }
    /**
     * Get cityField value
     * @return string|null
     */
    public function getCityField()
    {
        return $this->cityField;
    }
    /**
     * Set cityField value
     * @param string $cityField
     * @return \StructType\Truck
     */
    public function setCityField($cityField = null)
    {
        // validation for constraint: string
        if (!is_null($cityField) && !is_string($cityField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cityField, true), gettype($cityField)), __LINE__);
        }
        $this->cityField = $cityField;
        return $this;
    }
    /**
     * Get colorField value
     * @return string|null
     */
    public function getColorField()
    {
        return $this->colorField;
    }
    /**
     * Set colorField value
     * @param string $colorField
     * @return \StructType\Truck
     */
    public function setColorField($colorField = null)
    {
        // validation for constraint: string
        if (!is_null($colorField) && !is_string($colorField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($colorField, true), gettype($colorField)), __LINE__);
        }
        $this->colorField = $colorField;
        return $this;
    }
    /**
     * Get countryField value
     * @return string|null
     */
    public function getCountryField()
    {
        return $this->countryField;
    }
    /**
     * Set countryField value
     * @param string $countryField
     * @return \StructType\Truck
     */
    public function setCountryField($countryField = null)
    {
        // validation for constraint: string
        if (!is_null($countryField) && !is_string($countryField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryField, true), gettype($countryField)), __LINE__);
        }
        $this->countryField = $countryField;
        return $this;
    }
    /**
     * Get driverField value
     * @return string|null
     */
    public function getDriverField()
    {
        return $this->driverField;
    }
    /**
     * Set driverField value
     * @param string $driverField
     * @return \StructType\Truck
     */
    public function setDriverField($driverField = null)
    {
        // validation for constraint: string
        if (!is_null($driverField) && !is_string($driverField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($driverField, true), gettype($driverField)), __LINE__);
        }
        $this->driverField = $driverField;
        return $this;
    }
    /**
     * Get dropCostField value
     * @return float|null
     */
    public function getDropCostField()
    {
        return $this->dropCostField;
    }
    /**
     * Set dropCostField value
     * @param float $dropCostField
     * @return \StructType\Truck
     */
    public function setDropCostField($dropCostField = null)
    {
        // validation for constraint: float
        if (!is_null($dropCostField) && !(is_float($dropCostField) || is_numeric($dropCostField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dropCostField, true), gettype($dropCostField)), __LINE__);
        }
        $this->dropCostField = $dropCostField;
        return $this;
    }
    /**
     * Get eDayField value
     * @return int|null
     */
    public function getEDayField()
    {
        return $this->eDayField;
    }
    /**
     * Set eDayField value
     * @param int $eDayField
     * @return \StructType\Truck
     */
    public function setEDayField($eDayField = null)
    {
        // validation for constraint: int
        if (!is_null($eDayField) && !(is_int($eDayField) || ctype_digit($eDayField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eDayField, true), gettype($eDayField)), __LINE__);
        }
        $this->eDayField = $eDayField;
        return $this;
    }
    /**
     * Get earStartField value
     * @return string|null
     */
    public function getEarStartField()
    {
        return $this->earStartField;
    }
    /**
     * Set earStartField value
     * @param string $earStartField
     * @return \StructType\Truck
     */
    public function setEarStartField($earStartField = null)
    {
        // validation for constraint: string
        if (!is_null($earStartField) && !is_string($earStartField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($earStartField, true), gettype($earStartField)), __LINE__);
        }
        $this->earStartField = $earStartField;
        return $this;
    }
    /**
     * Get eqCodeField value
     * @return string|null
     */
    public function getEqCodeField()
    {
        return $this->eqCodeField;
    }
    /**
     * Set eqCodeField value
     * @param string $eqCodeField
     * @return \StructType\Truck
     */
    public function setEqCodeField($eqCodeField = null)
    {
        // validation for constraint: string
        if (!is_null($eqCodeField) && !is_string($eqCodeField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eqCodeField, true), gettype($eqCodeField)), __LINE__);
        }
        $this->eqCodeField = $eqCodeField;
        return $this;
    }
    /**
     * Get fixedCostField value
     * @return float|null
     */
    public function getFixedCostField()
    {
        return $this->fixedCostField;
    }
    /**
     * Set fixedCostField value
     * @param float $fixedCostField
     * @return \StructType\Truck
     */
    public function setFixedCostField($fixedCostField = null)
    {
        // validation for constraint: float
        if (!is_null($fixedCostField) && !(is_float($fixedCostField) || is_numeric($fixedCostField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fixedCostField, true), gettype($fixedCostField)), __LINE__);
        }
        $this->fixedCostField = $fixedCostField;
        return $this;
    }
    /**
     * Get geoResultField value
     * @return string|null
     */
    public function getGeoResultField()
    {
        return $this->geoResultField;
    }
    /**
     * Set geoResultField value
     * @param string $geoResultField
     * @return \StructType\Truck
     */
    public function setGeoResultField($geoResultField = null)
    {
        // validation for constraint: string
        if (!is_null($geoResultField) && !is_string($geoResultField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($geoResultField, true), gettype($geoResultField)), __LINE__);
        }
        $this->geoResultField = $geoResultField;
        return $this;
    }
    /**
     * Get hrCostField value
     * @return float|null
     */
    public function getHrCostField()
    {
        return $this->hrCostField;
    }
    /**
     * Set hrCostField value
     * @param float $hrCostField
     * @return \StructType\Truck
     */
    public function setHrCostField($hrCostField = null)
    {
        // validation for constraint: float
        if (!is_null($hrCostField) && !(is_float($hrCostField) || is_numeric($hrCostField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($hrCostField, true), gettype($hrCostField)), __LINE__);
        }
        $this->hrCostField = $hrCostField;
        return $this;
    }
    /**
     * Get keyField value
     * @return int|null
     */
    public function getKeyField()
    {
        return $this->keyField;
    }
    /**
     * Set keyField value
     * @param int $keyField
     * @return \StructType\Truck
     */
    public function setKeyField($keyField = null)
    {
        // validation for constraint: int
        if (!is_null($keyField) && !(is_int($keyField) || ctype_digit($keyField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($keyField, true), gettype($keyField)), __LINE__);
        }
        $this->keyField = $keyField;
        return $this;
    }
    /**
     * Get lDayField value
     * @return int|null
     */
    public function getLDayField()
    {
        return $this->lDayField;
    }
    /**
     * Set lDayField value
     * @param int $lDayField
     * @return \StructType\Truck
     */
    public function setLDayField($lDayField = null)
    {
        // validation for constraint: int
        if (!is_null($lDayField) && !(is_int($lDayField) || ctype_digit($lDayField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lDayField, true), gettype($lDayField)), __LINE__);
        }
        $this->lDayField = $lDayField;
        return $this;
    }
    /**
     * Get latFinishField value
     * @return string|null
     */
    public function getLatFinishField()
    {
        return $this->latFinishField;
    }
    /**
     * Set latFinishField value
     * @param string $latFinishField
     * @return \StructType\Truck
     */
    public function setLatFinishField($latFinishField = null)
    {
        // validation for constraint: string
        if (!is_null($latFinishField) && !is_string($latFinishField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($latFinishField, true), gettype($latFinishField)), __LINE__);
        }
        $this->latFinishField = $latFinishField;
        return $this;
    }
    /**
     * Get latStartField value
     * @return string|null
     */
    public function getLatStartField()
    {
        return $this->latStartField;
    }
    /**
     * Set latStartField value
     * @param string $latStartField
     * @return \StructType\Truck
     */
    public function setLatStartField($latStartField = null)
    {
        // validation for constraint: string
        if (!is_null($latStartField) && !is_string($latStartField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($latStartField, true), gettype($latStartField)), __LINE__);
        }
        $this->latStartField = $latStartField;
        return $this;
    }
    /**
     * Get latitudeField value
     * @return float|null
     */
    public function getLatitudeField()
    {
        return $this->latitudeField;
    }
    /**
     * Set latitudeField value
     * @param float $latitudeField
     * @return \StructType\Truck
     */
    public function setLatitudeField($latitudeField = null)
    {
        // validation for constraint: float
        if (!is_null($latitudeField) && !(is_float($latitudeField) || is_numeric($latitudeField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($latitudeField, true), gettype($latitudeField)), __LINE__);
        }
        $this->latitudeField = $latitudeField;
        return $this;
    }
    /**
     * Get layoverCostField value
     * @return float|null
     */
    public function getLayoverCostField()
    {
        return $this->layoverCostField;
    }
    /**
     * Set layoverCostField value
     * @param float $layoverCostField
     * @return \StructType\Truck
     */
    public function setLayoverCostField($layoverCostField = null)
    {
        // validation for constraint: float
        if (!is_null($layoverCostField) && !(is_float($layoverCostField) || is_numeric($layoverCostField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($layoverCostField, true), gettype($layoverCostField)), __LINE__);
        }
        $this->layoverCostField = $layoverCostField;
        return $this;
    }
    /**
     * Get longitudeField value
     * @return float|null
     */
    public function getLongitudeField()
    {
        return $this->longitudeField;
    }
    /**
     * Set longitudeField value
     * @param float $longitudeField
     * @return \StructType\Truck
     */
    public function setLongitudeField($longitudeField = null)
    {
        // validation for constraint: float
        if (!is_null($longitudeField) && !(is_float($longitudeField) || is_numeric($longitudeField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($longitudeField, true), gettype($longitudeField)), __LINE__);
        }
        $this->longitudeField = $longitudeField;
        return $this;
    }
    /**
     * Get maxDrvTmB4LayoverField value
     * @return string|null
     */
    public function getMaxDrvTmB4LayoverField()
    {
        return $this->maxDrvTmB4LayoverField;
    }
    /**
     * Set maxDrvTmB4LayoverField value
     * @param string $maxDrvTmB4LayoverField
     * @return \StructType\Truck
     */
    public function setMaxDrvTmB4LayoverField($maxDrvTmB4LayoverField = null)
    {
        // validation for constraint: string
        if (!is_null($maxDrvTmB4LayoverField) && !is_string($maxDrvTmB4LayoverField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maxDrvTmB4LayoverField, true), gettype($maxDrvTmB4LayoverField)), __LINE__);
        }
        $this->maxDrvTmB4LayoverField = $maxDrvTmB4LayoverField;
        return $this;
    }
    /**
     * Get maxDrvTmField value
     * @return string|null
     */
    public function getMaxDrvTmField()
    {
        return $this->maxDrvTmField;
    }
    /**
     * Set maxDrvTmField value
     * @param string $maxDrvTmField
     * @return \StructType\Truck
     */
    public function setMaxDrvTmField($maxDrvTmField = null)
    {
        // validation for constraint: string
        if (!is_null($maxDrvTmField) && !is_string($maxDrvTmField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maxDrvTmField, true), gettype($maxDrvTmField)), __LINE__);
        }
        $this->maxDrvTmField = $maxDrvTmField;
        return $this;
    }
    /**
     * Get maxLayoverTmField value
     * @return string|null
     */
    public function getMaxLayoverTmField()
    {
        return $this->maxLayoverTmField;
    }
    /**
     * Set maxLayoverTmField value
     * @param string $maxLayoverTmField
     * @return \StructType\Truck
     */
    public function setMaxLayoverTmField($maxLayoverTmField = null)
    {
        // validation for constraint: string
        if (!is_null($maxLayoverTmField) && !is_string($maxLayoverTmField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maxLayoverTmField, true), gettype($maxLayoverTmField)), __LINE__);
        }
        $this->maxLayoverTmField = $maxLayoverTmField;
        return $this;
    }
    /**
     * Get maxLayoversField value
     * @return int|null
     */
    public function getMaxLayoversField()
    {
        return $this->maxLayoversField;
    }
    /**
     * Set maxLayoversField value
     * @param int $maxLayoversField
     * @return \StructType\Truck
     */
    public function setMaxLayoversField($maxLayoversField = null)
    {
        // validation for constraint: int
        if (!is_null($maxLayoversField) && !(is_int($maxLayoversField) || ctype_digit($maxLayoversField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxLayoversField, true), gettype($maxLayoversField)), __LINE__);
        }
        $this->maxLayoversField = $maxLayoversField;
        return $this;
    }
    /**
     * Get maxWorkTmField value
     * @return string|null
     */
    public function getMaxWorkTmField()
    {
        return $this->maxWorkTmField;
    }
    /**
     * Set maxWorkTmField value
     * @param string $maxWorkTmField
     * @return \StructType\Truck
     */
    public function setMaxWorkTmField($maxWorkTmField = null)
    {
        // validation for constraint: string
        if (!is_null($maxWorkTmField) && !is_string($maxWorkTmField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maxWorkTmField, true), gettype($maxWorkTmField)), __LINE__);
        }
        $this->maxWorkTmField = $maxWorkTmField;
        return $this;
    }
    /**
     * Get miCostField value
     * @return float|null
     */
    public function getMiCostField()
    {
        return $this->miCostField;
    }
    /**
     * Set miCostField value
     * @param float $miCostField
     * @return \StructType\Truck
     */
    public function setMiCostField($miCostField = null)
    {
        // validation for constraint: float
        if (!is_null($miCostField) && !(is_float($miCostField) || is_numeric($miCostField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($miCostField, true), gettype($miCostField)), __LINE__);
        }
        $this->miCostField = $miCostField;
        return $this;
    }
    /**
     * Get minLayoverTmField value
     * @return string|null
     */
    public function getMinLayoverTmField()
    {
        return $this->minLayoverTmField;
    }
    /**
     * Set minLayoverTmField value
     * @param string $minLayoverTmField
     * @return \StructType\Truck
     */
    public function setMinLayoverTmField($minLayoverTmField = null)
    {
        // validation for constraint: string
        if (!is_null($minLayoverTmField) && !is_string($minLayoverTmField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minLayoverTmField, true), gettype($minLayoverTmField)), __LINE__);
        }
        $this->minLayoverTmField = $minLayoverTmField;
        return $this;
    }
    /**
     * Get minTmField value
     * @return string|null
     */
    public function getMinTmField()
    {
        return $this->minTmField;
    }
    /**
     * Set minTmField value
     * @param string $minTmField
     * @return \StructType\Truck
     */
    public function setMinTmField($minTmField = null)
    {
        // validation for constraint: string
        if (!is_null($minTmField) && !is_string($minTmField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minTmField, true), gettype($minTmField)), __LINE__);
        }
        $this->minTmField = $minTmField;
        return $this;
    }
    /**
     * Get normalStartField value
     * @return string|null
     */
    public function getNormalStartField()
    {
        return $this->normalStartField;
    }
    /**
     * Set normalStartField value
     * @param string $normalStartField
     * @return \StructType\Truck
     */
    public function setNormalStartField($normalStartField = null)
    {
        // validation for constraint: string
        if (!is_null($normalStartField) && !is_string($normalStartField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($normalStartField, true), gettype($normalStartField)), __LINE__);
        }
        $this->normalStartField = $normalStartField;
        return $this;
    }
    /**
     * Get oneWayField value
     * @return bool|null
     */
    public function getOneWayField()
    {
        return $this->oneWayField;
    }
    /**
     * Set oneWayField value
     * @param bool $oneWayField
     * @return \StructType\Truck
     */
    public function setOneWayField($oneWayField = null)
    {
        // validation for constraint: boolean
        if (!is_null($oneWayField) && !is_bool($oneWayField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($oneWayField, true), gettype($oneWayField)), __LINE__);
        }
        $this->oneWayField = $oneWayField;
        return $this;
    }
    /**
     * Get overTimeField value
     * @return \ArrayType\ArrayOfOverTime|null
     */
    public function getOverTimeField()
    {
        return $this->overTimeField;
    }
    /**
     * Set overTimeField value
     * @param \ArrayType\ArrayOfOverTime $overTimeField
     * @return \StructType\Truck
     */
    public function setOverTimeField(\ArrayType\ArrayOfOverTime $overTimeField = null)
    {
        $this->overTimeField = $overTimeField;
        return $this;
    }
    /**
     * Get pMAdjField value
     * @return int|null
     */
    public function getPMAdjField()
    {
        return $this->pMAdjField;
    }
    /**
     * Set pMAdjField value
     * @param int $pMAdjField
     * @return \StructType\Truck
     */
    public function setPMAdjField($pMAdjField = null)
    {
        // validation for constraint: int
        if (!is_null($pMAdjField) && !(is_int($pMAdjField) || ctype_digit($pMAdjField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pMAdjField, true), gettype($pMAdjField)), __LINE__);
        }
        $this->pMAdjField = $pMAdjField;
        return $this;
    }
    /**
     * Get pMEndField value
     * @return string|null
     */
    public function getPMEndField()
    {
        return $this->pMEndField;
    }
    /**
     * Set pMEndField value
     * @param string $pMEndField
     * @return \StructType\Truck
     */
    public function setPMEndField($pMEndField = null)
    {
        // validation for constraint: string
        if (!is_null($pMEndField) && !is_string($pMEndField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pMEndField, true), gettype($pMEndField)), __LINE__);
        }
        $this->pMEndField = $pMEndField;
        return $this;
    }
    /**
     * Get pMStartField value
     * @return string|null
     */
    public function getPMStartField()
    {
        return $this->pMStartField;
    }
    /**
     * Set pMStartField value
     * @param string $pMStartField
     * @return \StructType\Truck
     */
    public function setPMStartField($pMStartField = null)
    {
        // validation for constraint: string
        if (!is_null($pMStartField) && !is_string($pMStartField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pMStartField, true), gettype($pMStartField)), __LINE__);
        }
        $this->pMStartField = $pMStartField;
        return $this;
    }
    /**
     * Get postTripTmField value
     * @return string|null
     */
    public function getPostTripTmField()
    {
        return $this->postTripTmField;
    }
    /**
     * Set postTripTmField value
     * @param string $postTripTmField
     * @return \StructType\Truck
     */
    public function setPostTripTmField($postTripTmField = null)
    {
        // validation for constraint: string
        if (!is_null($postTripTmField) && !is_string($postTripTmField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postTripTmField, true), gettype($postTripTmField)), __LINE__);
        }
        $this->postTripTmField = $postTripTmField;
        return $this;
    }
    /**
     * Get preTripTmField value
     * @return string|null
     */
    public function getPreTripTmField()
    {
        return $this->preTripTmField;
    }
    /**
     * Set preTripTmField value
     * @param string $preTripTmField
     * @return \StructType\Truck
     */
    public function setPreTripTmField($preTripTmField = null)
    {
        // validation for constraint: string
        if (!is_null($preTripTmField) && !is_string($preTripTmField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($preTripTmField, true), gettype($preTripTmField)), __LINE__);
        }
        $this->preTripTmField = $preTripTmField;
        return $this;
    }
    /**
     * Get redispatchField value
     * @return bool|null
     */
    public function getRedispatchField()
    {
        return $this->redispatchField;
    }
    /**
     * Set redispatchField value
     * @param bool $redispatchField
     * @return \StructType\Truck
     */
    public function setRedispatchField($redispatchField = null)
    {
        // validation for constraint: boolean
        if (!is_null($redispatchField) && !is_bool($redispatchField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($redispatchField, true), gettype($redispatchField)), __LINE__);
        }
        $this->redispatchField = $redispatchField;
        return $this;
    }
    /**
     * Get stateField value
     * @return string|null
     */
    public function getStateField()
    {
        return $this->stateField;
    }
    /**
     * Set stateField value
     * @param string $stateField
     * @return \StructType\Truck
     */
    public function setStateField($stateField = null)
    {
        // validation for constraint: string
        if (!is_null($stateField) && !is_string($stateField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stateField, true), gettype($stateField)), __LINE__);
        }
        $this->stateField = $stateField;
        return $this;
    }
    /**
     * Get statusField value
     * @return int|null
     */
    public function getStatusField()
    {
        return $this->statusField;
    }
    /**
     * Set statusField value
     * @param int $statusField
     * @return \StructType\Truck
     */
    public function setStatusField($statusField = null)
    {
        // validation for constraint: int
        if (!is_null($statusField) && !(is_int($statusField) || ctype_digit($statusField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($statusField, true), gettype($statusField)), __LINE__);
        }
        $this->statusField = $statusField;
        return $this;
    }
    /**
     * Get targetWrkTmField value
     * @return string|null
     */
    public function getTargetWrkTmField()
    {
        return $this->targetWrkTmField;
    }
    /**
     * Set targetWrkTmField value
     * @param string $targetWrkTmField
     * @return \StructType\Truck
     */
    public function setTargetWrkTmField($targetWrkTmField = null)
    {
        // validation for constraint: string
        if (!is_null($targetWrkTmField) && !is_string($targetWrkTmField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetWrkTmField, true), gettype($targetWrkTmField)), __LINE__);
        }
        $this->targetWrkTmField = $targetWrkTmField;
        return $this;
    }
    /**
     * Get trkIdField value
     * @return string|null
     */
    public function getTrkIdField()
    {
        return $this->trkIdField;
    }
    /**
     * Set trkIdField value
     * @param string $trkIdField
     * @return \StructType\Truck
     */
    public function setTrkIdField($trkIdField = null)
    {
        // validation for constraint: string
        if (!is_null($trkIdField) && !is_string($trkIdField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trkIdField, true), gettype($trkIdField)), __LINE__);
        }
        $this->trkIdField = $trkIdField;
        return $this;
    }
    /**
     * Get turnTmField value
     * @return string|null
     */
    public function getTurnTmField()
    {
        return $this->turnTmField;
    }
    /**
     * Set turnTmField value
     * @param string $turnTmField
     * @return \StructType\Truck
     */
    public function setTurnTmField($turnTmField = null)
    {
        // validation for constraint: string
        if (!is_null($turnTmField) && !is_string($turnTmField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($turnTmField, true), gettype($turnTmField)), __LINE__);
        }
        $this->turnTmField = $turnTmField;
        return $this;
    }
    /**
     * Get unitCostField value
     * @return float|null
     */
    public function getUnitCostField()
    {
        return $this->unitCostField;
    }
    /**
     * Set unitCostField value
     * @param float $unitCostField
     * @return \StructType\Truck
     */
    public function setUnitCostField($unitCostField = null)
    {
        // validation for constraint: float
        if (!is_null($unitCostField) && !(is_float($unitCostField) || is_numeric($unitCostField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unitCostField, true), gettype($unitCostField)), __LINE__);
        }
        $this->unitCostField = $unitCostField;
        return $this;
    }
    /**
     * Get unldHrCostField value
     * @return float|null
     */
    public function getUnldHrCostField()
    {
        return $this->unldHrCostField;
    }
    /**
     * Set unldHrCostField value
     * @param float $unldHrCostField
     * @return \StructType\Truck
     */
    public function setUnldHrCostField($unldHrCostField = null)
    {
        // validation for constraint: float
        if (!is_null($unldHrCostField) && !(is_float($unldHrCostField) || is_numeric($unldHrCostField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unldHrCostField, true), gettype($unldHrCostField)), __LINE__);
        }
        $this->unldHrCostField = $unldHrCostField;
        return $this;
    }
    /**
     * Get unldPerfField value
     * @return int|null
     */
    public function getUnldPerfField()
    {
        return $this->unldPerfField;
    }
    /**
     * Set unldPerfField value
     * @param int $unldPerfField
     * @return \StructType\Truck
     */
    public function setUnldPerfField($unldPerfField = null)
    {
        // validation for constraint: int
        if (!is_null($unldPerfField) && !(is_int($unldPerfField) || ctype_digit($unldPerfField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($unldPerfField, true), gettype($unldPerfField)), __LINE__);
        }
        $this->unldPerfField = $unldPerfField;
        return $this;
    }
    /**
     * Get userFieldField value
     * @return \ArrayType\ArrayOfUserField|null
     */
    public function getUserFieldField()
    {
        return $this->userFieldField;
    }
    /**
     * Set userFieldField value
     * @param \ArrayType\ArrayOfUserField $userFieldField
     * @return \StructType\Truck
     */
    public function setUserFieldField(\ArrayType\ArrayOfUserField $userFieldField = null)
    {
        $this->userFieldField = $userFieldField;
        return $this;
    }
    /**
     * Get volumeField value
     * @return \ArrayType\ArrayOfVolume|null
     */
    public function getVolumeField()
    {
        return $this->volumeField;
    }
    /**
     * Set volumeField value
     * @param \ArrayType\ArrayOfVolume $volumeField
     * @return \StructType\Truck
     */
    public function setVolumeField(\ArrayType\ArrayOfVolume $volumeField = null)
    {
        $this->volumeField = $volumeField;
        return $this;
    }
    /**
     * Get waitHrCostField value
     * @return float|null
     */
    public function getWaitHrCostField()
    {
        return $this->waitHrCostField;
    }
    /**
     * Set waitHrCostField value
     * @param float $waitHrCostField
     * @return \StructType\Truck
     */
    public function setWaitHrCostField($waitHrCostField = null)
    {
        // validation for constraint: float
        if (!is_null($waitHrCostField) && !(is_float($waitHrCostField) || is_numeric($waitHrCostField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($waitHrCostField, true), gettype($waitHrCostField)), __LINE__);
        }
        $this->waitHrCostField = $waitHrCostField;
        return $this;
    }
    /**
     * Get workHrsField value
     * @return string|null
     */
    public function getWorkHrsField()
    {
        return $this->workHrsField;
    }
    /**
     * Set workHrsField value
     * @param string $workHrsField
     * @return \StructType\Truck
     */
    public function setWorkHrsField($workHrsField = null)
    {
        // validation for constraint: string
        if (!is_null($workHrsField) && !is_string($workHrsField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workHrsField, true), gettype($workHrsField)), __LINE__);
        }
        $this->workHrsField = $workHrsField;
        return $this;
    }
    /**
     * Get zipField value
     * @return string|null
     */
    public function getZipField()
    {
        return $this->zipField;
    }
    /**
     * Set zipField value
     * @param string $zipField
     * @return \StructType\Truck
     */
    public function setZipField($zipField = null)
    {
        // validation for constraint: string
        if (!is_null($zipField) && !is_string($zipField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipField, true), gettype($zipField)), __LINE__);
        }
        $this->zipField = $zipField;
        return $this;
    }
    /**
     * Get zoneField value
     * @return int|null
     */
    public function getZoneField()
    {
        return $this->zoneField;
    }
    /**
     * Set zoneField value
     * @param int $zoneField
     * @return \StructType\Truck
     */
    public function setZoneField($zoneField = null)
    {
        // validation for constraint: int
        if (!is_null($zoneField) && !(is_int($zoneField) || ctype_digit($zoneField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($zoneField, true), gettype($zoneField)), __LINE__);
        }
        $this->zoneField = $zoneField;
        return $this;
    }
}
