<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RouteActualDetailType StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RouteActualDetailType
 * @subpackage Structs
 */
class RouteActualDetailType extends AbstractStructBase
{
    /**
     * The delayField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $delayField;
    /**
     * The deviceIDField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $deviceIDField;
    /**
     * The driverIDField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $driverIDField;
    /**
     * The driverNameField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $driverNameField;
    /**
     * The endOdometerField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $endOdometerField;
    /**
     * The endTimeField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $endTimeField;
    /**
     * The gPSPointListField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfGPSPointDetailType
     */
    public $gPSPointListField;
    /**
     * The lastGPSTransmissionTimeField
     * @var string
     */
    public $lastGPSTransmissionTimeField;
    /**
     * The routeFormsListField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfRouteFormsDetailType
     */
    public $routeFormsListField;
    /**
     * The routeIDField
     * @var int
     */
    public $routeIDField;
    /**
     * The startOdometerField
     * @var int
     */
    public $startOdometerField;
    /**
     * The startTimeField
     * @var string
     */
    public $startTimeField;
    /**
     * The stopField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfStopActualDetailType
     */
    public $stopField;
    /**
     * The vehicleIDField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $vehicleIDField;
    /**
     * Constructor method for RouteActualDetailType
     * @uses RouteActualDetailType::setDelayField()
     * @uses RouteActualDetailType::setDeviceIDField()
     * @uses RouteActualDetailType::setDriverIDField()
     * @uses RouteActualDetailType::setDriverNameField()
     * @uses RouteActualDetailType::setEndOdometerField()
     * @uses RouteActualDetailType::setEndTimeField()
     * @uses RouteActualDetailType::setGPSPointListField()
     * @uses RouteActualDetailType::setLastGPSTransmissionTimeField()
     * @uses RouteActualDetailType::setRouteFormsListField()
     * @uses RouteActualDetailType::setRouteIDField()
     * @uses RouteActualDetailType::setStartOdometerField()
     * @uses RouteActualDetailType::setStartTimeField()
     * @uses RouteActualDetailType::setStopField()
     * @uses RouteActualDetailType::setVehicleIDField()
     * @param string $delayField
     * @param string $deviceIDField
     * @param string $driverIDField
     * @param string $driverNameField
     * @param int $endOdometerField
     * @param string $endTimeField
     * @param \ArrayType\ArrayOfGPSPointDetailType $gPSPointListField
     * @param string $lastGPSTransmissionTimeField
     * @param \ArrayType\ArrayOfRouteFormsDetailType $routeFormsListField
     * @param int $routeIDField
     * @param int $startOdometerField
     * @param string $startTimeField
     * @param \ArrayType\ArrayOfStopActualDetailType $stopField
     * @param string $vehicleIDField
     */
    public function __construct($delayField = null, $deviceIDField = null, $driverIDField = null, $driverNameField = null, $endOdometerField = null, $endTimeField = null, \ArrayType\ArrayOfGPSPointDetailType $gPSPointListField = null, $lastGPSTransmissionTimeField = null, \ArrayType\ArrayOfRouteFormsDetailType $routeFormsListField = null, $routeIDField = null, $startOdometerField = null, $startTimeField = null, \ArrayType\ArrayOfStopActualDetailType $stopField = null, $vehicleIDField = null)
    {
        $this
            ->setDelayField($delayField)
            ->setDeviceIDField($deviceIDField)
            ->setDriverIDField($driverIDField)
            ->setDriverNameField($driverNameField)
            ->setEndOdometerField($endOdometerField)
            ->setEndTimeField($endTimeField)
            ->setGPSPointListField($gPSPointListField)
            ->setLastGPSTransmissionTimeField($lastGPSTransmissionTimeField)
            ->setRouteFormsListField($routeFormsListField)
            ->setRouteIDField($routeIDField)
            ->setStartOdometerField($startOdometerField)
            ->setStartTimeField($startTimeField)
            ->setStopField($stopField)
            ->setVehicleIDField($vehicleIDField);
    }
    /**
     * Get delayField value
     * @return string|null
     */
    public function getDelayField()
    {
        return $this->delayField;
    }
    /**
     * Set delayField value
     * @param string $delayField
     * @return \StructType\RouteActualDetailType
     */
    public function setDelayField($delayField = null)
    {
        // validation for constraint: string
        if (!is_null($delayField) && !is_string($delayField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($delayField, true), gettype($delayField)), __LINE__);
        }
        $this->delayField = $delayField;
        return $this;
    }
    /**
     * Get deviceIDField value
     * @return string|null
     */
    public function getDeviceIDField()
    {
        return $this->deviceIDField;
    }
    /**
     * Set deviceIDField value
     * @param string $deviceIDField
     * @return \StructType\RouteActualDetailType
     */
    public function setDeviceIDField($deviceIDField = null)
    {
        // validation for constraint: string
        if (!is_null($deviceIDField) && !is_string($deviceIDField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceIDField, true), gettype($deviceIDField)), __LINE__);
        }
        $this->deviceIDField = $deviceIDField;
        return $this;
    }
    /**
     * Get driverIDField value
     * @return string|null
     */
    public function getDriverIDField()
    {
        return $this->driverIDField;
    }
    /**
     * Set driverIDField value
     * @param string $driverIDField
     * @return \StructType\RouteActualDetailType
     */
    public function setDriverIDField($driverIDField = null)
    {
        // validation for constraint: string
        if (!is_null($driverIDField) && !is_string($driverIDField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($driverIDField, true), gettype($driverIDField)), __LINE__);
        }
        $this->driverIDField = $driverIDField;
        return $this;
    }
    /**
     * Get driverNameField value
     * @return string|null
     */
    public function getDriverNameField()
    {
        return $this->driverNameField;
    }
    /**
     * Set driverNameField value
     * @param string $driverNameField
     * @return \StructType\RouteActualDetailType
     */
    public function setDriverNameField($driverNameField = null)
    {
        // validation for constraint: string
        if (!is_null($driverNameField) && !is_string($driverNameField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($driverNameField, true), gettype($driverNameField)), __LINE__);
        }
        $this->driverNameField = $driverNameField;
        return $this;
    }
    /**
     * Get endOdometerField value
     * @return int|null
     */
    public function getEndOdometerField()
    {
        return $this->endOdometerField;
    }
    /**
     * Set endOdometerField value
     * @param int $endOdometerField
     * @return \StructType\RouteActualDetailType
     */
    public function setEndOdometerField($endOdometerField = null)
    {
        // validation for constraint: int
        if (!is_null($endOdometerField) && !(is_int($endOdometerField) || ctype_digit($endOdometerField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($endOdometerField, true), gettype($endOdometerField)), __LINE__);
        }
        $this->endOdometerField = $endOdometerField;
        return $this;
    }
    /**
     * Get endTimeField value
     * @return string|null
     */
    public function getEndTimeField()
    {
        return $this->endTimeField;
    }
    /**
     * Set endTimeField value
     * @param string $endTimeField
     * @return \StructType\RouteActualDetailType
     */
    public function setEndTimeField($endTimeField = null)
    {
        // validation for constraint: string
        if (!is_null($endTimeField) && !is_string($endTimeField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endTimeField, true), gettype($endTimeField)), __LINE__);
        }
        $this->endTimeField = $endTimeField;
        return $this;
    }
    /**
     * Get gPSPointListField value
     * @return \ArrayType\ArrayOfGPSPointDetailType|null
     */
    public function getGPSPointListField()
    {
        return $this->gPSPointListField;
    }
    /**
     * Set gPSPointListField value
     * @param \ArrayType\ArrayOfGPSPointDetailType $gPSPointListField
     * @return \StructType\RouteActualDetailType
     */
    public function setGPSPointListField(\ArrayType\ArrayOfGPSPointDetailType $gPSPointListField = null)
    {
        $this->gPSPointListField = $gPSPointListField;
        return $this;
    }
    /**
     * Get lastGPSTransmissionTimeField value
     * @return string|null
     */
    public function getLastGPSTransmissionTimeField()
    {
        return $this->lastGPSTransmissionTimeField;
    }
    /**
     * Set lastGPSTransmissionTimeField value
     * @param string $lastGPSTransmissionTimeField
     * @return \StructType\RouteActualDetailType
     */
    public function setLastGPSTransmissionTimeField($lastGPSTransmissionTimeField = null)
    {
        // validation for constraint: string
        if (!is_null($lastGPSTransmissionTimeField) && !is_string($lastGPSTransmissionTimeField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastGPSTransmissionTimeField, true), gettype($lastGPSTransmissionTimeField)), __LINE__);
        }
        $this->lastGPSTransmissionTimeField = $lastGPSTransmissionTimeField;
        return $this;
    }
    /**
     * Get routeFormsListField value
     * @return \ArrayType\ArrayOfRouteFormsDetailType|null
     */
    public function getRouteFormsListField()
    {
        return $this->routeFormsListField;
    }
    /**
     * Set routeFormsListField value
     * @param \ArrayType\ArrayOfRouteFormsDetailType $routeFormsListField
     * @return \StructType\RouteActualDetailType
     */
    public function setRouteFormsListField(\ArrayType\ArrayOfRouteFormsDetailType $routeFormsListField = null)
    {
        $this->routeFormsListField = $routeFormsListField;
        return $this;
    }
    /**
     * Get routeIDField value
     * @return int|null
     */
    public function getRouteIDField()
    {
        return $this->routeIDField;
    }
    /**
     * Set routeIDField value
     * @param int $routeIDField
     * @return \StructType\RouteActualDetailType
     */
    public function setRouteIDField($routeIDField = null)
    {
        // validation for constraint: int
        if (!is_null($routeIDField) && !(is_int($routeIDField) || ctype_digit($routeIDField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($routeIDField, true), gettype($routeIDField)), __LINE__);
        }
        $this->routeIDField = $routeIDField;
        return $this;
    }
    /**
     * Get startOdometerField value
     * @return int|null
     */
    public function getStartOdometerField()
    {
        return $this->startOdometerField;
    }
    /**
     * Set startOdometerField value
     * @param int $startOdometerField
     * @return \StructType\RouteActualDetailType
     */
    public function setStartOdometerField($startOdometerField = null)
    {
        // validation for constraint: int
        if (!is_null($startOdometerField) && !(is_int($startOdometerField) || ctype_digit($startOdometerField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($startOdometerField, true), gettype($startOdometerField)), __LINE__);
        }
        $this->startOdometerField = $startOdometerField;
        return $this;
    }
    /**
     * Get startTimeField value
     * @return string|null
     */
    public function getStartTimeField()
    {
        return $this->startTimeField;
    }
    /**
     * Set startTimeField value
     * @param string $startTimeField
     * @return \StructType\RouteActualDetailType
     */
    public function setStartTimeField($startTimeField = null)
    {
        // validation for constraint: string
        if (!is_null($startTimeField) && !is_string($startTimeField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startTimeField, true), gettype($startTimeField)), __LINE__);
        }
        $this->startTimeField = $startTimeField;
        return $this;
    }
    /**
     * Get stopField value
     * @return \ArrayType\ArrayOfStopActualDetailType|null
     */
    public function getStopField()
    {
        return $this->stopField;
    }
    /**
     * Set stopField value
     * @param \ArrayType\ArrayOfStopActualDetailType $stopField
     * @return \StructType\RouteActualDetailType
     */
    public function setStopField(\ArrayType\ArrayOfStopActualDetailType $stopField = null)
    {
        $this->stopField = $stopField;
        return $this;
    }
    /**
     * Get vehicleIDField value
     * @return string|null
     */
    public function getVehicleIDField()
    {
        return $this->vehicleIDField;
    }
    /**
     * Set vehicleIDField value
     * @param string $vehicleIDField
     * @return \StructType\RouteActualDetailType
     */
    public function setVehicleIDField($vehicleIDField = null)
    {
        // validation for constraint: string
        if (!is_null($vehicleIDField) && !is_string($vehicleIDField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vehicleIDField, true), gettype($vehicleIDField)), __LINE__);
        }
        $this->vehicleIDField = $vehicleIDField;
        return $this;
    }
}
