<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderFormInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OrderFormInfo
 * @subpackage Structs
 */
class OrderFormInfo extends AbstractStructBase
{
    /**
     * The deviceFormListField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfForm
     */
    public $deviceFormListField;
    /**
     * The externalIdField
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $externalIdField;
    /**
     * The internalOrderIDField
     * @var int
     */
    public $internalOrderIDField;
    /**
     * The orderIDField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $orderIDField;
    /**
     * Constructor method for OrderFormInfo
     * @uses OrderFormInfo::setDeviceFormListField()
     * @uses OrderFormInfo::setExternalIdField()
     * @uses OrderFormInfo::setInternalOrderIDField()
     * @uses OrderFormInfo::setOrderIDField()
     * @param \ArrayType\ArrayOfForm $deviceFormListField
     * @param string $externalIdField
     * @param int $internalOrderIDField
     * @param string $orderIDField
     */
    public function __construct(\ArrayType\ArrayOfForm $deviceFormListField = null, $externalIdField = null, $internalOrderIDField = null, $orderIDField = null)
    {
        $this
            ->setDeviceFormListField($deviceFormListField)
            ->setExternalIdField($externalIdField)
            ->setInternalOrderIDField($internalOrderIDField)
            ->setOrderIDField($orderIDField);
    }
    /**
     * Get deviceFormListField value
     * @return \ArrayType\ArrayOfForm|null
     */
    public function getDeviceFormListField()
    {
        return $this->deviceFormListField;
    }
    /**
     * Set deviceFormListField value
     * @param \ArrayType\ArrayOfForm $deviceFormListField
     * @return \StructType\OrderFormInfo
     */
    public function setDeviceFormListField(\ArrayType\ArrayOfForm $deviceFormListField = null)
    {
        $this->deviceFormListField = $deviceFormListField;
        return $this;
    }
    /**
     * Get externalIdField value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalIdField()
    {
        return isset($this->externalIdField) ? $this->externalIdField : null;
    }
    /**
     * Set externalIdField value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalIdField
     * @return \StructType\OrderFormInfo
     */
    public function setExternalIdField($externalIdField = null)
    {
        // validation for constraint: string
        if (!is_null($externalIdField) && !is_string($externalIdField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalIdField, true), gettype($externalIdField)), __LINE__);
        }
        if (is_null($externalIdField) || (is_array($externalIdField) && empty($externalIdField))) {
            unset($this->externalIdField);
        } else {
            $this->externalIdField = $externalIdField;
        }
        return $this;
    }
    /**
     * Get internalOrderIDField value
     * @return int|null
     */
    public function getInternalOrderIDField()
    {
        return $this->internalOrderIDField;
    }
    /**
     * Set internalOrderIDField value
     * @param int $internalOrderIDField
     * @return \StructType\OrderFormInfo
     */
    public function setInternalOrderIDField($internalOrderIDField = null)
    {
        // validation for constraint: int
        if (!is_null($internalOrderIDField) && !(is_int($internalOrderIDField) || ctype_digit($internalOrderIDField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($internalOrderIDField, true), gettype($internalOrderIDField)), __LINE__);
        }
        $this->internalOrderIDField = $internalOrderIDField;
        return $this;
    }
    /**
     * Get orderIDField value
     * @return string|null
     */
    public function getOrderIDField()
    {
        return $this->orderIDField;
    }
    /**
     * Set orderIDField value
     * @param string $orderIDField
     * @return \StructType\OrderFormInfo
     */
    public function setOrderIDField($orderIDField = null)
    {
        // validation for constraint: string
        if (!is_null($orderIDField) && !is_string($orderIDField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderIDField, true), gettype($orderIDField)), __LINE__);
        }
        $this->orderIDField = $orderIDField;
        return $this;
    }
}
