<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderEventRequestEnvelope StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OrderEventRequestEnvelope
 * @subpackage Structs
 */
class OrderEventRequestEnvelope extends AbstractStructBase
{
    /**
     * The BranchID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BranchID;
    /**
     * The EventType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EventType;
    /**
     * The FromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FromDate;
    /**
     * The Page
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Page;
    /**
     * The ToDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ToDate;
    /**
     * Constructor method for OrderEventRequestEnvelope
     * @uses OrderEventRequestEnvelope::setBranchID()
     * @uses OrderEventRequestEnvelope::setEventType()
     * @uses OrderEventRequestEnvelope::setFromDate()
     * @uses OrderEventRequestEnvelope::setPage()
     * @uses OrderEventRequestEnvelope::setToDate()
     * @param string $branchID
     * @param string $eventType
     * @param string $fromDate
     * @param string $page
     * @param string $toDate
     */
    public function __construct($branchID = null, $eventType = null, $fromDate = null, $page = null, $toDate = null)
    {
        $this
            ->setBranchID($branchID)
            ->setEventType($eventType)
            ->setFromDate($fromDate)
            ->setPage($page)
            ->setToDate($toDate);
    }
    /**
     * Get BranchID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBranchID()
    {
        return isset($this->BranchID) ? $this->BranchID : null;
    }
    /**
     * Set BranchID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $branchID
     * @return \StructType\OrderEventRequestEnvelope
     */
    public function setBranchID($branchID = null)
    {
        // validation for constraint: string
        if (!is_null($branchID) && !is_string($branchID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($branchID, true), gettype($branchID)), __LINE__);
        }
        if (is_null($branchID) || (is_array($branchID) && empty($branchID))) {
            unset($this->BranchID);
        } else {
            $this->BranchID = $branchID;
        }
        return $this;
    }
    /**
     * Get EventType value
     * @return string|null
     */
    public function getEventType()
    {
        return $this->EventType;
    }
    /**
     * Set EventType value
     * @uses \EnumType\OrderEventType::valueIsValid()
     * @uses \EnumType\OrderEventType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $eventType
     * @return \StructType\OrderEventRequestEnvelope
     */
    public function setEventType($eventType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OrderEventType::valueIsValid($eventType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\OrderEventType', is_array($eventType) ? implode(', ', $eventType) : var_export($eventType, true), implode(', ', \EnumType\OrderEventType::getValidValues())), __LINE__);
        }
        $this->EventType = $eventType;
        return $this;
    }
    /**
     * Get FromDate value
     * @return string|null
     */
    public function getFromDate()
    {
        return $this->FromDate;
    }
    /**
     * Set FromDate value
     * @param string $fromDate
     * @return \StructType\OrderEventRequestEnvelope
     */
    public function setFromDate($fromDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromDate) && !is_string($fromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromDate, true), gettype($fromDate)), __LINE__);
        }
        $this->FromDate = $fromDate;
        return $this;
    }
    /**
     * Get Page value
     * @return string|null
     */
    public function getPage()
    {
        return $this->Page;
    }
    /**
     * Set Page value
     * @param string $page
     * @return \StructType\OrderEventRequestEnvelope
     */
    public function setPage($page = null)
    {
        // validation for constraint: string
        if (!is_null($page) && !is_string($page)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($page, true), gettype($page)), __LINE__);
        }
        $this->Page = $page;
        return $this;
    }
    /**
     * Get ToDate value
     * @return string|null
     */
    public function getToDate()
    {
        return $this->ToDate;
    }
    /**
     * Set ToDate value
     * @param string $toDate
     * @return \StructType\OrderEventRequestEnvelope
     */
    public function setToDate($toDate = null)
    {
        // validation for constraint: string
        if (!is_null($toDate) && !is_string($toDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toDate, true), gettype($toDate)), __LINE__);
        }
        $this->ToDate = $toDate;
        return $this;
    }
}
