<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderDetailType StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OrderDetailType
 * @subpackage Structs
 */
class OrderDetailType extends OrderBaseType
{
    /**
     * The actualField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\OrderDetailActualType
     */
    public $actualField;
    /**
     * The eventDetailField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfEventDetail
     */
    public $eventDetailField;
    /**
     * The orderStatusField
     * @var string
     */
    public $orderStatusField;
    /**
     * The planField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\OrderDetailPlanType
     */
    public $planField;
    /**
     * The stopNotesField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $stopNotesField;
    /**
     * Constructor method for OrderDetailType
     * @uses OrderDetailType::setActualField()
     * @uses OrderDetailType::setEventDetailField()
     * @uses OrderDetailType::setOrderStatusField()
     * @uses OrderDetailType::setPlanField()
     * @uses OrderDetailType::setStopNotesField()
     * @param \StructType\OrderDetailActualType $actualField
     * @param \ArrayType\ArrayOfEventDetail $eventDetailField
     * @param string $orderStatusField
     * @param \StructType\OrderDetailPlanType $planField
     * @param string $stopNotesField
     */
    public function __construct(\StructType\OrderDetailActualType $actualField = null, \ArrayType\ArrayOfEventDetail $eventDetailField = null, $orderStatusField = null, \StructType\OrderDetailPlanType $planField = null, $stopNotesField = null)
    {
        $this
            ->setActualField($actualField)
            ->setEventDetailField($eventDetailField)
            ->setOrderStatusField($orderStatusField)
            ->setPlanField($planField)
            ->setStopNotesField($stopNotesField);
    }
    /**
     * Get actualField value
     * @return \StructType\OrderDetailActualType|null
     */
    public function getActualField()
    {
        return $this->actualField;
    }
    /**
     * Set actualField value
     * @param \StructType\OrderDetailActualType $actualField
     * @return \StructType\OrderDetailType
     */
    public function setActualField(\StructType\OrderDetailActualType $actualField = null)
    {
        $this->actualField = $actualField;
        return $this;
    }
    /**
     * Get eventDetailField value
     * @return \ArrayType\ArrayOfEventDetail|null
     */
    public function getEventDetailField()
    {
        return $this->eventDetailField;
    }
    /**
     * Set eventDetailField value
     * @param \ArrayType\ArrayOfEventDetail $eventDetailField
     * @return \StructType\OrderDetailType
     */
    public function setEventDetailField(\ArrayType\ArrayOfEventDetail $eventDetailField = null)
    {
        $this->eventDetailField = $eventDetailField;
        return $this;
    }
    /**
     * Get orderStatusField value
     * @return string|null
     */
    public function getOrderStatusField()
    {
        return $this->orderStatusField;
    }
    /**
     * Set orderStatusField value
     * @uses \EnumType\OrderDetailTypeStatusType::valueIsValid()
     * @uses \EnumType\OrderDetailTypeStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $orderStatusField
     * @return \StructType\OrderDetailType
     */
    public function setOrderStatusField($orderStatusField = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OrderDetailTypeStatusType::valueIsValid($orderStatusField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\OrderDetailTypeStatusType', is_array($orderStatusField) ? implode(', ', $orderStatusField) : var_export($orderStatusField, true), implode(', ', \EnumType\OrderDetailTypeStatusType::getValidValues())), __LINE__);
        }
        $this->orderStatusField = $orderStatusField;
        return $this;
    }
    /**
     * Get planField value
     * @return \StructType\OrderDetailPlanType|null
     */
    public function getPlanField()
    {
        return $this->planField;
    }
    /**
     * Set planField value
     * @param \StructType\OrderDetailPlanType $planField
     * @return \StructType\OrderDetailType
     */
    public function setPlanField(\StructType\OrderDetailPlanType $planField = null)
    {
        $this->planField = $planField;
        return $this;
    }
    /**
     * Get stopNotesField value
     * @return string|null
     */
    public function getStopNotesField()
    {
        return $this->stopNotesField;
    }
    /**
     * Set stopNotesField value
     * @param string $stopNotesField
     * @return \StructType\OrderDetailType
     */
    public function setStopNotesField($stopNotesField = null)
    {
        // validation for constraint: string
        if (!is_null($stopNotesField) && !is_string($stopNotesField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stopNotesField, true), gettype($stopNotesField)), __LINE__);
        }
        $this->stopNotesField = $stopNotesField;
        return $this;
    }
}
