<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderDetailRequestEnvelope StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OrderDetailRequestEnvelope
 * @subpackage Structs
 */
class OrderDetailRequestEnvelope extends AbstractStructBase
{
    /**
     * The branchIDField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $branchIDField;
    /**
     * The externalIdField
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $externalIdField;
    /**
     * The fromDateField
     * @var string
     */
    public $fromDateField;
    /**
     * The orderDetailReturnOptionsField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\OrderDetailReturnOptions
     */
    public $orderDetailReturnOptionsField;
    /**
     * The orderEventTypeField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfOrderEventType
     */
    public $orderEventTypeField;
    /**
     * The pageField
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $pageField;
    /**
     * The toDateField
     * @var string
     */
    public $toDateField;
    /**
     * Constructor method for OrderDetailRequestEnvelope
     * @uses OrderDetailRequestEnvelope::setBranchIDField()
     * @uses OrderDetailRequestEnvelope::setExternalIdField()
     * @uses OrderDetailRequestEnvelope::setFromDateField()
     * @uses OrderDetailRequestEnvelope::setOrderDetailReturnOptionsField()
     * @uses OrderDetailRequestEnvelope::setOrderEventTypeField()
     * @uses OrderDetailRequestEnvelope::setPageField()
     * @uses OrderDetailRequestEnvelope::setToDateField()
     * @param string $branchIDField
     * @param string $externalIdField
     * @param string $fromDateField
     * @param \StructType\OrderDetailReturnOptions $orderDetailReturnOptionsField
     * @param \ArrayType\ArrayOfOrderEventType $orderEventTypeField
     * @param int $pageField
     * @param string $toDateField
     */
    public function __construct($branchIDField = null, $externalIdField = null, $fromDateField = null, \StructType\OrderDetailReturnOptions $orderDetailReturnOptionsField = null, \ArrayType\ArrayOfOrderEventType $orderEventTypeField = null, $pageField = null, $toDateField = null)
    {
        $this
            ->setBranchIDField($branchIDField)
            ->setExternalIdField($externalIdField)
            ->setFromDateField($fromDateField)
            ->setOrderDetailReturnOptionsField($orderDetailReturnOptionsField)
            ->setOrderEventTypeField($orderEventTypeField)
            ->setPageField($pageField)
            ->setToDateField($toDateField);
    }
    /**
     * Get branchIDField value
     * @return string|null
     */
    public function getBranchIDField()
    {
        return $this->branchIDField;
    }
    /**
     * Set branchIDField value
     * @param string $branchIDField
     * @return \StructType\OrderDetailRequestEnvelope
     */
    public function setBranchIDField($branchIDField = null)
    {
        // validation for constraint: string
        if (!is_null($branchIDField) && !is_string($branchIDField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($branchIDField, true), gettype($branchIDField)), __LINE__);
        }
        $this->branchIDField = $branchIDField;
        return $this;
    }
    /**
     * Get externalIdField value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalIdField()
    {
        return isset($this->externalIdField) ? $this->externalIdField : null;
    }
    /**
     * Set externalIdField value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalIdField
     * @return \StructType\OrderDetailRequestEnvelope
     */
    public function setExternalIdField($externalIdField = null)
    {
        // validation for constraint: string
        if (!is_null($externalIdField) && !is_string($externalIdField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalIdField, true), gettype($externalIdField)), __LINE__);
        }
        if (is_null($externalIdField) || (is_array($externalIdField) && empty($externalIdField))) {
            unset($this->externalIdField);
        } else {
            $this->externalIdField = $externalIdField;
        }
        return $this;
    }
    /**
     * Get fromDateField value
     * @return string|null
     */
    public function getFromDateField()
    {
        return $this->fromDateField;
    }
    /**
     * Set fromDateField value
     * @param string $fromDateField
     * @return \StructType\OrderDetailRequestEnvelope
     */
    public function setFromDateField($fromDateField = null)
    {
        // validation for constraint: string
        if (!is_null($fromDateField) && !is_string($fromDateField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromDateField, true), gettype($fromDateField)), __LINE__);
        }
        $this->fromDateField = $fromDateField;
        return $this;
    }
    /**
     * Get orderDetailReturnOptionsField value
     * @return \StructType\OrderDetailReturnOptions|null
     */
    public function getOrderDetailReturnOptionsField()
    {
        return $this->orderDetailReturnOptionsField;
    }
    /**
     * Set orderDetailReturnOptionsField value
     * @param \StructType\OrderDetailReturnOptions $orderDetailReturnOptionsField
     * @return \StructType\OrderDetailRequestEnvelope
     */
    public function setOrderDetailReturnOptionsField(\StructType\OrderDetailReturnOptions $orderDetailReturnOptionsField = null)
    {
        $this->orderDetailReturnOptionsField = $orderDetailReturnOptionsField;
        return $this;
    }
    /**
     * Get orderEventTypeField value
     * @return \ArrayType\ArrayOfOrderEventType|null
     */
    public function getOrderEventTypeField()
    {
        return $this->orderEventTypeField;
    }
    /**
     * Set orderEventTypeField value
     * @param \ArrayType\ArrayOfOrderEventType $orderEventTypeField
     * @return \StructType\OrderDetailRequestEnvelope
     */
    public function setOrderEventTypeField(\ArrayType\ArrayOfOrderEventType $orderEventTypeField = null)
    {
        $this->orderEventTypeField = $orderEventTypeField;
        return $this;
    }
    /**
     * Get pageField value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPageField()
    {
        return isset($this->pageField) ? $this->pageField : null;
    }
    /**
     * Set pageField value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $pageField
     * @return \StructType\OrderDetailRequestEnvelope
     */
    public function setPageField($pageField = null)
    {
        // validation for constraint: int
        if (!is_null($pageField) && !(is_int($pageField) || ctype_digit($pageField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageField, true), gettype($pageField)), __LINE__);
        }
        if (is_null($pageField) || (is_array($pageField) && empty($pageField))) {
            unset($this->pageField);
        } else {
            $this->pageField = $pageField;
        }
        return $this;
    }
    /**
     * Get toDateField value
     * @return string|null
     */
    public function getToDateField()
    {
        return $this->toDateField;
    }
    /**
     * Set toDateField value
     * @param string $toDateField
     * @return \StructType\OrderDetailRequestEnvelope
     */
    public function setToDateField($toDateField = null)
    {
        // validation for constraint: string
        if (!is_null($toDateField) && !is_string($toDateField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toDateField, true), gettype($toDateField)), __LINE__);
        }
        $this->toDateField = $toDateField;
        return $this;
    }
}
