<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderDetailActualDetailType StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OrderDetailActualDetailType
 * @subpackage Structs
 */
class OrderDetailActualDetailType extends AbstractStructBase
{
    /**
     * The accountKeyIDField
     * @var int
     */
    public $accountKeyIDField;
    /**
     * The lineItemField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfLineItemDetailActualType
     */
    public $lineItemField;
    /**
     * The orderIDField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $orderIDField;
    /**
     * The orderKeyIDField
     * @var int
     */
    public $orderKeyIDField;
    /**
     * The shipToKeyIDField
     * @var int
     */
    public $shipToKeyIDField;
    /**
     * Constructor method for OrderDetailActualDetailType
     * @uses OrderDetailActualDetailType::setAccountKeyIDField()
     * @uses OrderDetailActualDetailType::setLineItemField()
     * @uses OrderDetailActualDetailType::setOrderIDField()
     * @uses OrderDetailActualDetailType::setOrderKeyIDField()
     * @uses OrderDetailActualDetailType::setShipToKeyIDField()
     * @param int $accountKeyIDField
     * @param \ArrayType\ArrayOfLineItemDetailActualType $lineItemField
     * @param string $orderIDField
     * @param int $orderKeyIDField
     * @param int $shipToKeyIDField
     */
    public function __construct($accountKeyIDField = null, \ArrayType\ArrayOfLineItemDetailActualType $lineItemField = null, $orderIDField = null, $orderKeyIDField = null, $shipToKeyIDField = null)
    {
        $this
            ->setAccountKeyIDField($accountKeyIDField)
            ->setLineItemField($lineItemField)
            ->setOrderIDField($orderIDField)
            ->setOrderKeyIDField($orderKeyIDField)
            ->setShipToKeyIDField($shipToKeyIDField);
    }
    /**
     * Get accountKeyIDField value
     * @return int|null
     */
    public function getAccountKeyIDField()
    {
        return $this->accountKeyIDField;
    }
    /**
     * Set accountKeyIDField value
     * @param int $accountKeyIDField
     * @return \StructType\OrderDetailActualDetailType
     */
    public function setAccountKeyIDField($accountKeyIDField = null)
    {
        // validation for constraint: int
        if (!is_null($accountKeyIDField) && !(is_int($accountKeyIDField) || ctype_digit($accountKeyIDField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountKeyIDField, true), gettype($accountKeyIDField)), __LINE__);
        }
        $this->accountKeyIDField = $accountKeyIDField;
        return $this;
    }
    /**
     * Get lineItemField value
     * @return \ArrayType\ArrayOfLineItemDetailActualType|null
     */
    public function getLineItemField()
    {
        return $this->lineItemField;
    }
    /**
     * Set lineItemField value
     * @param \ArrayType\ArrayOfLineItemDetailActualType $lineItemField
     * @return \StructType\OrderDetailActualDetailType
     */
    public function setLineItemField(\ArrayType\ArrayOfLineItemDetailActualType $lineItemField = null)
    {
        $this->lineItemField = $lineItemField;
        return $this;
    }
    /**
     * Get orderIDField value
     * @return string|null
     */
    public function getOrderIDField()
    {
        return $this->orderIDField;
    }
    /**
     * Set orderIDField value
     * @param string $orderIDField
     * @return \StructType\OrderDetailActualDetailType
     */
    public function setOrderIDField($orderIDField = null)
    {
        // validation for constraint: string
        if (!is_null($orderIDField) && !is_string($orderIDField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderIDField, true), gettype($orderIDField)), __LINE__);
        }
        $this->orderIDField = $orderIDField;
        return $this;
    }
    /**
     * Get orderKeyIDField value
     * @return int|null
     */
    public function getOrderKeyIDField()
    {
        return $this->orderKeyIDField;
    }
    /**
     * Set orderKeyIDField value
     * @param int $orderKeyIDField
     * @return \StructType\OrderDetailActualDetailType
     */
    public function setOrderKeyIDField($orderKeyIDField = null)
    {
        // validation for constraint: int
        if (!is_null($orderKeyIDField) && !(is_int($orderKeyIDField) || ctype_digit($orderKeyIDField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderKeyIDField, true), gettype($orderKeyIDField)), __LINE__);
        }
        $this->orderKeyIDField = $orderKeyIDField;
        return $this;
    }
    /**
     * Get shipToKeyIDField value
     * @return int|null
     */
    public function getShipToKeyIDField()
    {
        return $this->shipToKeyIDField;
    }
    /**
     * Set shipToKeyIDField value
     * @param int $shipToKeyIDField
     * @return \StructType\OrderDetailActualDetailType
     */
    public function setShipToKeyIDField($shipToKeyIDField = null)
    {
        // validation for constraint: int
        if (!is_null($shipToKeyIDField) && !(is_int($shipToKeyIDField) || ctype_digit($shipToKeyIDField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($shipToKeyIDField, true), gettype($shipToKeyIDField)), __LINE__);
        }
        $this->shipToKeyIDField = $shipToKeyIDField;
        return $this;
    }
}
