<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LineItemDetailActualType StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:LineItemDetailActualType
 * @subpackage Structs
 */
class LineItemDetailActualType extends AbstractStructBase
{
    /**
     * The actualField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\LineItemActualType
     */
    public $actualField;
    /**
     * The lineItemIDField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $lineItemIDField;
    /**
     * The lineItemKeyIDField
     * @var int
     */
    public $lineItemKeyIDField;
    /**
     * Constructor method for LineItemDetailActualType
     * @uses LineItemDetailActualType::setActualField()
     * @uses LineItemDetailActualType::setLineItemIDField()
     * @uses LineItemDetailActualType::setLineItemKeyIDField()
     * @param \StructType\LineItemActualType $actualField
     * @param string $lineItemIDField
     * @param int $lineItemKeyIDField
     */
    public function __construct(\StructType\LineItemActualType $actualField = null, $lineItemIDField = null, $lineItemKeyIDField = null)
    {
        $this
            ->setActualField($actualField)
            ->setLineItemIDField($lineItemIDField)
            ->setLineItemKeyIDField($lineItemKeyIDField);
    }
    /**
     * Get actualField value
     * @return \StructType\LineItemActualType|null
     */
    public function getActualField()
    {
        return $this->actualField;
    }
    /**
     * Set actualField value
     * @param \StructType\LineItemActualType $actualField
     * @return \StructType\LineItemDetailActualType
     */
    public function setActualField(\StructType\LineItemActualType $actualField = null)
    {
        $this->actualField = $actualField;
        return $this;
    }
    /**
     * Get lineItemIDField value
     * @return string|null
     */
    public function getLineItemIDField()
    {
        return $this->lineItemIDField;
    }
    /**
     * Set lineItemIDField value
     * @param string $lineItemIDField
     * @return \StructType\LineItemDetailActualType
     */
    public function setLineItemIDField($lineItemIDField = null)
    {
        // validation for constraint: string
        if (!is_null($lineItemIDField) && !is_string($lineItemIDField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lineItemIDField, true), gettype($lineItemIDField)), __LINE__);
        }
        $this->lineItemIDField = $lineItemIDField;
        return $this;
    }
    /**
     * Get lineItemKeyIDField value
     * @return int|null
     */
    public function getLineItemKeyIDField()
    {
        return $this->lineItemKeyIDField;
    }
    /**
     * Set lineItemKeyIDField value
     * @param int $lineItemKeyIDField
     * @return \StructType\LineItemDetailActualType
     */
    public function setLineItemKeyIDField($lineItemKeyIDField = null)
    {
        // validation for constraint: int
        if (!is_null($lineItemKeyIDField) && !(is_int($lineItemKeyIDField) || ctype_digit($lineItemKeyIDField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lineItemKeyIDField, true), gettype($lineItemKeyIDField)), __LINE__);
        }
        $this->lineItemKeyIDField = $lineItemKeyIDField;
        return $this;
    }
}
