<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LineItem StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:LineItem
 * @subpackage Structs
 */
class LineItem extends AbstractStructBase
{
    /**
     * The fixedTimeField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $fixedTimeField;
    /**
     * The idField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $idField;
    /**
     * The keyField
     * @var int
     */
    public $keyField;
    /**
     * The userFieldField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfUserField
     */
    public $userFieldField;
    /**
     * The volumeField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfVolume
     */
    public $volumeField;
    /**
     * Constructor method for LineItem
     * @uses LineItem::setFixedTimeField()
     * @uses LineItem::setIdField()
     * @uses LineItem::setKeyField()
     * @uses LineItem::setUserFieldField()
     * @uses LineItem::setVolumeField()
     * @param string $fixedTimeField
     * @param string $idField
     * @param int $keyField
     * @param \ArrayType\ArrayOfUserField $userFieldField
     * @param \ArrayType\ArrayOfVolume $volumeField
     */
    public function __construct($fixedTimeField = null, $idField = null, $keyField = null, \ArrayType\ArrayOfUserField $userFieldField = null, \ArrayType\ArrayOfVolume $volumeField = null)
    {
        $this
            ->setFixedTimeField($fixedTimeField)
            ->setIdField($idField)
            ->setKeyField($keyField)
            ->setUserFieldField($userFieldField)
            ->setVolumeField($volumeField);
    }
    /**
     * Get fixedTimeField value
     * @return string|null
     */
    public function getFixedTimeField()
    {
        return $this->fixedTimeField;
    }
    /**
     * Set fixedTimeField value
     * @param string $fixedTimeField
     * @return \StructType\LineItem
     */
    public function setFixedTimeField($fixedTimeField = null)
    {
        // validation for constraint: string
        if (!is_null($fixedTimeField) && !is_string($fixedTimeField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fixedTimeField, true), gettype($fixedTimeField)), __LINE__);
        }
        $this->fixedTimeField = $fixedTimeField;
        return $this;
    }
    /**
     * Get idField value
     * @return string|null
     */
    public function getIdField()
    {
        return $this->idField;
    }
    /**
     * Set idField value
     * @param string $idField
     * @return \StructType\LineItem
     */
    public function setIdField($idField = null)
    {
        // validation for constraint: string
        if (!is_null($idField) && !is_string($idField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idField, true), gettype($idField)), __LINE__);
        }
        $this->idField = $idField;
        return $this;
    }
    /**
     * Get keyField value
     * @return int|null
     */
    public function getKeyField()
    {
        return $this->keyField;
    }
    /**
     * Set keyField value
     * @param int $keyField
     * @return \StructType\LineItem
     */
    public function setKeyField($keyField = null)
    {
        // validation for constraint: int
        if (!is_null($keyField) && !(is_int($keyField) || ctype_digit($keyField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($keyField, true), gettype($keyField)), __LINE__);
        }
        $this->keyField = $keyField;
        return $this;
    }
    /**
     * Get userFieldField value
     * @return \ArrayType\ArrayOfUserField|null
     */
    public function getUserFieldField()
    {
        return $this->userFieldField;
    }
    /**
     * Set userFieldField value
     * @param \ArrayType\ArrayOfUserField $userFieldField
     * @return \StructType\LineItem
     */
    public function setUserFieldField(\ArrayType\ArrayOfUserField $userFieldField = null)
    {
        $this->userFieldField = $userFieldField;
        return $this;
    }
    /**
     * Get volumeField value
     * @return \ArrayType\ArrayOfVolume|null
     */
    public function getVolumeField()
    {
        return $this->volumeField;
    }
    /**
     * Set volumeField value
     * @param \ArrayType\ArrayOfVolume $volumeField
     * @return \StructType\LineItem
     */
    public function setVolumeField(\ArrayType\ArrayOfVolume $volumeField = null)
    {
        $this->volumeField = $volumeField;
        return $this;
    }
}
