<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImportRoutes StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ImportRoutes
 * @subpackage Structs
 */
class ImportRoutes extends AbstractStructBase
{
    /**
     * The auth
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Authentication
     */
    public $auth;
    /**
     * The requestEnvelope
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ImportRoutesRequestEnvelope
     */
    public $requestEnvelope;
    /**
     * The branchIDField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $branchIDField;
    /**
     * The dRSolutionSummaryStatisticsField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\DRSolutionSummaryStatistics
     */
    public $dRSolutionSummaryStatisticsField;
    /**
     * The dRTrackPreferencesField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\DRTrackPreferences
     */
    public $dRTrackPreferencesField;
    /**
     * The dispatchDateField
     * @var string
     */
    public $dispatchDateField;
    /**
     * The isMasterRouteField
     * @var bool
     */
    public $isMasterRouteField;
    /**
     * The masterProfileEndDateField
     * @var string
     */
    public $masterProfileEndDateField;
    /**
     * The masterProfileNameField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $masterProfileNameField;
    /**
     * The masterProfileStartDateField
     * @var string
     */
    public $masterProfileStartDateField;
    /**
     * The parametersField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\Parameters
     */
    public $parametersField;
    /**
     * The routesField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfImportRoutesRoute
     */
    public $routesField;
    /**
     * The shouldMasterRouteBeDeletedField
     * @var bool
     */
    public $shouldMasterRouteBeDeletedField;
    /**
     * The statusMessageField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfKeyValuePair
     */
    public $statusMessageField;
    /**
     * The truckProfileNameField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $truckProfileNameField;
    /**
     * The unldStopsField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfStop
     */
    public $unldStopsField;
    /**
     * The userSolutionSummaryStatisticsField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\UserSolutionSummaryStatistics
     */
    public $userSolutionSummaryStatisticsField;
    /**
     * The versionField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $versionField;
    /**
     * Constructor method for ImportRoutes
     * @uses ImportRoutes::setAuth()
     * @uses ImportRoutes::setRequestEnvelope()
     * @uses ImportRoutes::setBranchIDField()
     * @uses ImportRoutes::setDRSolutionSummaryStatisticsField()
     * @uses ImportRoutes::setDRTrackPreferencesField()
     * @uses ImportRoutes::setDispatchDateField()
     * @uses ImportRoutes::setIsMasterRouteField()
     * @uses ImportRoutes::setMasterProfileEndDateField()
     * @uses ImportRoutes::setMasterProfileNameField()
     * @uses ImportRoutes::setMasterProfileStartDateField()
     * @uses ImportRoutes::setParametersField()
     * @uses ImportRoutes::setRoutesField()
     * @uses ImportRoutes::setShouldMasterRouteBeDeletedField()
     * @uses ImportRoutes::setStatusMessageField()
     * @uses ImportRoutes::setTruckProfileNameField()
     * @uses ImportRoutes::setUnldStopsField()
     * @uses ImportRoutes::setUserSolutionSummaryStatisticsField()
     * @uses ImportRoutes::setVersionField()
     * @param \StructType\Authentication $auth
     * @param \StructType\ImportRoutesRequestEnvelope $requestEnvelope
     * @param string $branchIDField
     * @param \StructType\DRSolutionSummaryStatistics $dRSolutionSummaryStatisticsField
     * @param \StructType\DRTrackPreferences $dRTrackPreferencesField
     * @param string $dispatchDateField
     * @param bool $isMasterRouteField
     * @param string $masterProfileEndDateField
     * @param string $masterProfileNameField
     * @param string $masterProfileStartDateField
     * @param \StructType\Parameters $parametersField
     * @param \ArrayType\ArrayOfImportRoutesRoute $routesField
     * @param bool $shouldMasterRouteBeDeletedField
     * @param \ArrayType\ArrayOfKeyValuePair $statusMessageField
     * @param string $truckProfileNameField
     * @param \ArrayType\ArrayOfStop $unldStopsField
     * @param \StructType\UserSolutionSummaryStatistics $userSolutionSummaryStatisticsField
     * @param string $versionField
     */
    public function __construct(\StructType\Authentication $auth = null, \StructType\ImportRoutesRequestEnvelope $requestEnvelope = null, $branchIDField = null, \StructType\DRSolutionSummaryStatistics $dRSolutionSummaryStatisticsField = null, \StructType\DRTrackPreferences $dRTrackPreferencesField = null, $dispatchDateField = null, $isMasterRouteField = null, $masterProfileEndDateField = null, $masterProfileNameField = null, $masterProfileStartDateField = null, \StructType\Parameters $parametersField = null, \ArrayType\ArrayOfImportRoutesRoute $routesField = null, $shouldMasterRouteBeDeletedField = null, \ArrayType\ArrayOfKeyValuePair $statusMessageField = null, $truckProfileNameField = null, \ArrayType\ArrayOfStop $unldStopsField = null, \StructType\UserSolutionSummaryStatistics $userSolutionSummaryStatisticsField = null, $versionField = null)
    {
        $this
            ->setAuth($auth)
            ->setRequestEnvelope($requestEnvelope)
            ->setBranchIDField($branchIDField)
            ->setDRSolutionSummaryStatisticsField($dRSolutionSummaryStatisticsField)
            ->setDRTrackPreferencesField($dRTrackPreferencesField)
            ->setDispatchDateField($dispatchDateField)
            ->setIsMasterRouteField($isMasterRouteField)
            ->setMasterProfileEndDateField($masterProfileEndDateField)
            ->setMasterProfileNameField($masterProfileNameField)
            ->setMasterProfileStartDateField($masterProfileStartDateField)
            ->setParametersField($parametersField)
            ->setRoutesField($routesField)
            ->setShouldMasterRouteBeDeletedField($shouldMasterRouteBeDeletedField)
            ->setStatusMessageField($statusMessageField)
            ->setTruckProfileNameField($truckProfileNameField)
            ->setUnldStopsField($unldStopsField)
            ->setUserSolutionSummaryStatisticsField($userSolutionSummaryStatisticsField)
            ->setVersionField($versionField);
    }
    /**
     * Get auth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Authentication|null
     */
    public function getAuth()
    {
        return isset($this->auth) ? $this->auth : null;
    }
    /**
     * Set auth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Authentication $auth
     * @return \StructType\ImportRoutes
     */
    public function setAuth(\StructType\Authentication $auth = null)
    {
        if (is_null($auth) || (is_array($auth) && empty($auth))) {
            unset($this->auth);
        } else {
            $this->auth = $auth;
        }
        return $this;
    }
    /**
     * Get requestEnvelope value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ImportRoutesRequestEnvelope|null
     */
    public function getRequestEnvelope()
    {
        return isset($this->requestEnvelope) ? $this->requestEnvelope : null;
    }
    /**
     * Set requestEnvelope value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ImportRoutesRequestEnvelope $requestEnvelope
     * @return \StructType\ImportRoutes
     */
    public function setRequestEnvelope(\StructType\ImportRoutesRequestEnvelope $requestEnvelope = null)
    {
        if (is_null($requestEnvelope) || (is_array($requestEnvelope) && empty($requestEnvelope))) {
            unset($this->requestEnvelope);
        } else {
            $this->requestEnvelope = $requestEnvelope;
        }
        return $this;
    }
    /**
     * Get branchIDField value
     * @return string|null
     */
    public function getBranchIDField()
    {
        return $this->branchIDField;
    }
    /**
     * Set branchIDField value
     * @param string $branchIDField
     * @return \StructType\ImportRoutes
     */
    public function setBranchIDField($branchIDField = null)
    {
        // validation for constraint: string
        if (!is_null($branchIDField) && !is_string($branchIDField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($branchIDField, true), gettype($branchIDField)), __LINE__);
        }
        $this->branchIDField = $branchIDField;
        return $this;
    }
    /**
     * Get dRSolutionSummaryStatisticsField value
     * @return \StructType\DRSolutionSummaryStatistics|null
     */
    public function getDRSolutionSummaryStatisticsField()
    {
        return $this->dRSolutionSummaryStatisticsField;
    }
    /**
     * Set dRSolutionSummaryStatisticsField value
     * @param \StructType\DRSolutionSummaryStatistics $dRSolutionSummaryStatisticsField
     * @return \StructType\ImportRoutes
     */
    public function setDRSolutionSummaryStatisticsField(\StructType\DRSolutionSummaryStatistics $dRSolutionSummaryStatisticsField = null)
    {
        $this->dRSolutionSummaryStatisticsField = $dRSolutionSummaryStatisticsField;
        return $this;
    }
    /**
     * Get dRTrackPreferencesField value
     * @return \StructType\DRTrackPreferences|null
     */
    public function getDRTrackPreferencesField()
    {
        return $this->dRTrackPreferencesField;
    }
    /**
     * Set dRTrackPreferencesField value
     * @param \StructType\DRTrackPreferences $dRTrackPreferencesField
     * @return \StructType\ImportRoutes
     */
    public function setDRTrackPreferencesField(\StructType\DRTrackPreferences $dRTrackPreferencesField = null)
    {
        $this->dRTrackPreferencesField = $dRTrackPreferencesField;
        return $this;
    }
    /**
     * Get dispatchDateField value
     * @return string|null
     */
    public function getDispatchDateField()
    {
        return $this->dispatchDateField;
    }
    /**
     * Set dispatchDateField value
     * @param string $dispatchDateField
     * @return \StructType\ImportRoutes
     */
    public function setDispatchDateField($dispatchDateField = null)
    {
        // validation for constraint: string
        if (!is_null($dispatchDateField) && !is_string($dispatchDateField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dispatchDateField, true), gettype($dispatchDateField)), __LINE__);
        }
        $this->dispatchDateField = $dispatchDateField;
        return $this;
    }
    /**
     * Get isMasterRouteField value
     * @return bool|null
     */
    public function getIsMasterRouteField()
    {
        return $this->isMasterRouteField;
    }
    /**
     * Set isMasterRouteField value
     * @param bool $isMasterRouteField
     * @return \StructType\ImportRoutes
     */
    public function setIsMasterRouteField($isMasterRouteField = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMasterRouteField) && !is_bool($isMasterRouteField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isMasterRouteField, true), gettype($isMasterRouteField)), __LINE__);
        }
        $this->isMasterRouteField = $isMasterRouteField;
        return $this;
    }
    /**
     * Get masterProfileEndDateField value
     * @return string|null
     */
    public function getMasterProfileEndDateField()
    {
        return $this->masterProfileEndDateField;
    }
    /**
     * Set masterProfileEndDateField value
     * @param string $masterProfileEndDateField
     * @return \StructType\ImportRoutes
     */
    public function setMasterProfileEndDateField($masterProfileEndDateField = null)
    {
        // validation for constraint: string
        if (!is_null($masterProfileEndDateField) && !is_string($masterProfileEndDateField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($masterProfileEndDateField, true), gettype($masterProfileEndDateField)), __LINE__);
        }
        $this->masterProfileEndDateField = $masterProfileEndDateField;
        return $this;
    }
    /**
     * Get masterProfileNameField value
     * @return string|null
     */
    public function getMasterProfileNameField()
    {
        return $this->masterProfileNameField;
    }
    /**
     * Set masterProfileNameField value
     * @param string $masterProfileNameField
     * @return \StructType\ImportRoutes
     */
    public function setMasterProfileNameField($masterProfileNameField = null)
    {
        // validation for constraint: string
        if (!is_null($masterProfileNameField) && !is_string($masterProfileNameField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($masterProfileNameField, true), gettype($masterProfileNameField)), __LINE__);
        }
        $this->masterProfileNameField = $masterProfileNameField;
        return $this;
    }
    /**
     * Get masterProfileStartDateField value
     * @return string|null
     */
    public function getMasterProfileStartDateField()
    {
        return $this->masterProfileStartDateField;
    }
    /**
     * Set masterProfileStartDateField value
     * @param string $masterProfileStartDateField
     * @return \StructType\ImportRoutes
     */
    public function setMasterProfileStartDateField($masterProfileStartDateField = null)
    {
        // validation for constraint: string
        if (!is_null($masterProfileStartDateField) && !is_string($masterProfileStartDateField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($masterProfileStartDateField, true), gettype($masterProfileStartDateField)), __LINE__);
        }
        $this->masterProfileStartDateField = $masterProfileStartDateField;
        return $this;
    }
    /**
     * Get parametersField value
     * @return \StructType\Parameters|null
     */
    public function getParametersField()
    {
        return $this->parametersField;
    }
    /**
     * Set parametersField value
     * @param \StructType\Parameters $parametersField
     * @return \StructType\ImportRoutes
     */
    public function setParametersField(\StructType\Parameters $parametersField = null)
    {
        $this->parametersField = $parametersField;
        return $this;
    }
    /**
     * Get routesField value
     * @return \ArrayType\ArrayOfImportRoutesRoute|null
     */
    public function getRoutesField()
    {
        return $this->routesField;
    }
    /**
     * Set routesField value
     * @param \ArrayType\ArrayOfImportRoutesRoute $routesField
     * @return \StructType\ImportRoutes
     */
    public function setRoutesField(\ArrayType\ArrayOfImportRoutesRoute $routesField = null)
    {
        $this->routesField = $routesField;
        return $this;
    }
    /**
     * Get shouldMasterRouteBeDeletedField value
     * @return bool|null
     */
    public function getShouldMasterRouteBeDeletedField()
    {
        return $this->shouldMasterRouteBeDeletedField;
    }
    /**
     * Set shouldMasterRouteBeDeletedField value
     * @param bool $shouldMasterRouteBeDeletedField
     * @return \StructType\ImportRoutes
     */
    public function setShouldMasterRouteBeDeletedField($shouldMasterRouteBeDeletedField = null)
    {
        // validation for constraint: boolean
        if (!is_null($shouldMasterRouteBeDeletedField) && !is_bool($shouldMasterRouteBeDeletedField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($shouldMasterRouteBeDeletedField, true), gettype($shouldMasterRouteBeDeletedField)), __LINE__);
        }
        $this->shouldMasterRouteBeDeletedField = $shouldMasterRouteBeDeletedField;
        return $this;
    }
    /**
     * Get statusMessageField value
     * @return \ArrayType\ArrayOfKeyValuePair|null
     */
    public function getStatusMessageField()
    {
        return $this->statusMessageField;
    }
    /**
     * Set statusMessageField value
     * @param \ArrayType\ArrayOfKeyValuePair $statusMessageField
     * @return \StructType\ImportRoutes
     */
    public function setStatusMessageField(\ArrayType\ArrayOfKeyValuePair $statusMessageField = null)
    {
        $this->statusMessageField = $statusMessageField;
        return $this;
    }
    /**
     * Get truckProfileNameField value
     * @return string|null
     */
    public function getTruckProfileNameField()
    {
        return $this->truckProfileNameField;
    }
    /**
     * Set truckProfileNameField value
     * @param string $truckProfileNameField
     * @return \StructType\ImportRoutes
     */
    public function setTruckProfileNameField($truckProfileNameField = null)
    {
        // validation for constraint: string
        if (!is_null($truckProfileNameField) && !is_string($truckProfileNameField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($truckProfileNameField, true), gettype($truckProfileNameField)), __LINE__);
        }
        $this->truckProfileNameField = $truckProfileNameField;
        return $this;
    }
    /**
     * Get unldStopsField value
     * @return \ArrayType\ArrayOfStop|null
     */
    public function getUnldStopsField()
    {
        return $this->unldStopsField;
    }
    /**
     * Set unldStopsField value
     * @param \ArrayType\ArrayOfStop $unldStopsField
     * @return \StructType\ImportRoutes
     */
    public function setUnldStopsField(\ArrayType\ArrayOfStop $unldStopsField = null)
    {
        $this->unldStopsField = $unldStopsField;
        return $this;
    }
    /**
     * Get userSolutionSummaryStatisticsField value
     * @return \StructType\UserSolutionSummaryStatistics|null
     */
    public function getUserSolutionSummaryStatisticsField()
    {
        return $this->userSolutionSummaryStatisticsField;
    }
    /**
     * Set userSolutionSummaryStatisticsField value
     * @param \StructType\UserSolutionSummaryStatistics $userSolutionSummaryStatisticsField
     * @return \StructType\ImportRoutes
     */
    public function setUserSolutionSummaryStatisticsField(\StructType\UserSolutionSummaryStatistics $userSolutionSummaryStatisticsField = null)
    {
        $this->userSolutionSummaryStatisticsField = $userSolutionSummaryStatisticsField;
        return $this;
    }
    /**
     * Get versionField value
     * @return string|null
     */
    public function getVersionField()
    {
        return $this->versionField;
    }
    /**
     * Set versionField value
     * @param string $versionField
     * @return \StructType\ImportRoutes
     */
    public function setVersionField($versionField = null)
    {
        // validation for constraint: string
        if (!is_null($versionField) && !is_string($versionField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($versionField, true), gettype($versionField)), __LINE__);
        }
        $this->versionField = $versionField;
        return $this;
    }
}
