<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeviceDetails StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DeviceDetails
 * @subpackage Structs
 */
class DeviceDetails extends AbstractStructBase
{
    /**
     * The branchIDField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $branchIDField;
    /**
     * The deviceIDField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $deviceIDField;
    /**
     * The deviceTypeField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $deviceTypeField;
    /**
     * The gPSIntervalField
     * @var int
     */
    public $gPSIntervalField;
    /**
     * The gPSReadFrequencyField
     * @var int
     */
    public $gPSReadFrequencyField;
    /**
     * The passwordField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $passwordField;
    /**
     * The phoneNumberField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $phoneNumberField;
    /**
     * The sendIntervalField
     * @var int
     */
    public $sendIntervalField;
    /**
     * The uniqueIDField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $uniqueIDField;
    /**
     * Constructor method for DeviceDetails
     * @uses DeviceDetails::setBranchIDField()
     * @uses DeviceDetails::setDeviceIDField()
     * @uses DeviceDetails::setDeviceTypeField()
     * @uses DeviceDetails::setGPSIntervalField()
     * @uses DeviceDetails::setGPSReadFrequencyField()
     * @uses DeviceDetails::setPasswordField()
     * @uses DeviceDetails::setPhoneNumberField()
     * @uses DeviceDetails::setSendIntervalField()
     * @uses DeviceDetails::setUniqueIDField()
     * @param string $branchIDField
     * @param string $deviceIDField
     * @param string $deviceTypeField
     * @param int $gPSIntervalField
     * @param int $gPSReadFrequencyField
     * @param string $passwordField
     * @param string $phoneNumberField
     * @param int $sendIntervalField
     * @param string $uniqueIDField
     */
    public function __construct($branchIDField = null, $deviceIDField = null, $deviceTypeField = null, $gPSIntervalField = null, $gPSReadFrequencyField = null, $passwordField = null, $phoneNumberField = null, $sendIntervalField = null, $uniqueIDField = null)
    {
        $this
            ->setBranchIDField($branchIDField)
            ->setDeviceIDField($deviceIDField)
            ->setDeviceTypeField($deviceTypeField)
            ->setGPSIntervalField($gPSIntervalField)
            ->setGPSReadFrequencyField($gPSReadFrequencyField)
            ->setPasswordField($passwordField)
            ->setPhoneNumberField($phoneNumberField)
            ->setSendIntervalField($sendIntervalField)
            ->setUniqueIDField($uniqueIDField);
    }
    /**
     * Get branchIDField value
     * @return string|null
     */
    public function getBranchIDField()
    {
        return $this->branchIDField;
    }
    /**
     * Set branchIDField value
     * @param string $branchIDField
     * @return \StructType\DeviceDetails
     */
    public function setBranchIDField($branchIDField = null)
    {
        // validation for constraint: string
        if (!is_null($branchIDField) && !is_string($branchIDField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($branchIDField, true), gettype($branchIDField)), __LINE__);
        }
        $this->branchIDField = $branchIDField;
        return $this;
    }
    /**
     * Get deviceIDField value
     * @return string|null
     */
    public function getDeviceIDField()
    {
        return $this->deviceIDField;
    }
    /**
     * Set deviceIDField value
     * @param string $deviceIDField
     * @return \StructType\DeviceDetails
     */
    public function setDeviceIDField($deviceIDField = null)
    {
        // validation for constraint: string
        if (!is_null($deviceIDField) && !is_string($deviceIDField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceIDField, true), gettype($deviceIDField)), __LINE__);
        }
        $this->deviceIDField = $deviceIDField;
        return $this;
    }
    /**
     * Get deviceTypeField value
     * @return string|null
     */
    public function getDeviceTypeField()
    {
        return $this->deviceTypeField;
    }
    /**
     * Set deviceTypeField value
     * @param string $deviceTypeField
     * @return \StructType\DeviceDetails
     */
    public function setDeviceTypeField($deviceTypeField = null)
    {
        // validation for constraint: string
        if (!is_null($deviceTypeField) && !is_string($deviceTypeField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceTypeField, true), gettype($deviceTypeField)), __LINE__);
        }
        $this->deviceTypeField = $deviceTypeField;
        return $this;
    }
    /**
     * Get gPSIntervalField value
     * @return int|null
     */
    public function getGPSIntervalField()
    {
        return $this->gPSIntervalField;
    }
    /**
     * Set gPSIntervalField value
     * @param int $gPSIntervalField
     * @return \StructType\DeviceDetails
     */
    public function setGPSIntervalField($gPSIntervalField = null)
    {
        // validation for constraint: int
        if (!is_null($gPSIntervalField) && !(is_int($gPSIntervalField) || ctype_digit($gPSIntervalField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($gPSIntervalField, true), gettype($gPSIntervalField)), __LINE__);
        }
        $this->gPSIntervalField = $gPSIntervalField;
        return $this;
    }
    /**
     * Get gPSReadFrequencyField value
     * @return int|null
     */
    public function getGPSReadFrequencyField()
    {
        return $this->gPSReadFrequencyField;
    }
    /**
     * Set gPSReadFrequencyField value
     * @param int $gPSReadFrequencyField
     * @return \StructType\DeviceDetails
     */
    public function setGPSReadFrequencyField($gPSReadFrequencyField = null)
    {
        // validation for constraint: int
        if (!is_null($gPSReadFrequencyField) && !(is_int($gPSReadFrequencyField) || ctype_digit($gPSReadFrequencyField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($gPSReadFrequencyField, true), gettype($gPSReadFrequencyField)), __LINE__);
        }
        $this->gPSReadFrequencyField = $gPSReadFrequencyField;
        return $this;
    }
    /**
     * Get passwordField value
     * @return string|null
     */
    public function getPasswordField()
    {
        return $this->passwordField;
    }
    /**
     * Set passwordField value
     * @param string $passwordField
     * @return \StructType\DeviceDetails
     */
    public function setPasswordField($passwordField = null)
    {
        // validation for constraint: string
        if (!is_null($passwordField) && !is_string($passwordField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($passwordField, true), gettype($passwordField)), __LINE__);
        }
        $this->passwordField = $passwordField;
        return $this;
    }
    /**
     * Get phoneNumberField value
     * @return string|null
     */
    public function getPhoneNumberField()
    {
        return $this->phoneNumberField;
    }
    /**
     * Set phoneNumberField value
     * @param string $phoneNumberField
     * @return \StructType\DeviceDetails
     */
    public function setPhoneNumberField($phoneNumberField = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumberField) && !is_string($phoneNumberField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneNumberField, true), gettype($phoneNumberField)), __LINE__);
        }
        $this->phoneNumberField = $phoneNumberField;
        return $this;
    }
    /**
     * Get sendIntervalField value
     * @return int|null
     */
    public function getSendIntervalField()
    {
        return $this->sendIntervalField;
    }
    /**
     * Set sendIntervalField value
     * @param int $sendIntervalField
     * @return \StructType\DeviceDetails
     */
    public function setSendIntervalField($sendIntervalField = null)
    {
        // validation for constraint: int
        if (!is_null($sendIntervalField) && !(is_int($sendIntervalField) || ctype_digit($sendIntervalField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sendIntervalField, true), gettype($sendIntervalField)), __LINE__);
        }
        $this->sendIntervalField = $sendIntervalField;
        return $this;
    }
    /**
     * Get uniqueIDField value
     * @return string|null
     */
    public function getUniqueIDField()
    {
        return $this->uniqueIDField;
    }
    /**
     * Set uniqueIDField value
     * @param string $uniqueIDField
     * @return \StructType\DeviceDetails
     */
    public function setUniqueIDField($uniqueIDField = null)
    {
        // validation for constraint: string
        if (!is_null($uniqueIDField) && !is_string($uniqueIDField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uniqueIDField, true), gettype($uniqueIDField)), __LINE__);
        }
        $this->uniqueIDField = $uniqueIDField;
        return $this;
    }
}
