<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeviceDataGPS StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DeviceDataGPS
 * @subpackage Structs
 */
class DeviceDataGPS extends AbstractStructBase
{
    /**
     * The gPSTimeField
     * @var string
     */
    public $gPSTimeField;
    /**
     * The headingField
     * @var int
     */
    public $headingField;
    /**
     * The latLongErrorField
     * @var int
     */
    public $latLongErrorField;
    /**
     * The latitudeField
     * @var float
     */
    public $latitudeField;
    /**
     * The longitudeField
     * @var float
     */
    public $longitudeField;
    /**
     * The nSatellitesField
     * @var string
     */
    public $nSatellitesField;
    /**
     * The nSatellitesFieldSpecified
     * @var bool
     */
    public $nSatellitesFieldSpecified;
    /**
     * The odometerField
     * @var float
     */
    public $odometerField;
    /**
     * The speedErrorField
     * @var int
     */
    public $speedErrorField;
    /**
     * The speedField
     * @var int
     */
    public $speedField;
    /**
     * Constructor method for DeviceDataGPS
     * @uses DeviceDataGPS::setGPSTimeField()
     * @uses DeviceDataGPS::setHeadingField()
     * @uses DeviceDataGPS::setLatLongErrorField()
     * @uses DeviceDataGPS::setLatitudeField()
     * @uses DeviceDataGPS::setLongitudeField()
     * @uses DeviceDataGPS::setNSatellitesField()
     * @uses DeviceDataGPS::setNSatellitesFieldSpecified()
     * @uses DeviceDataGPS::setOdometerField()
     * @uses DeviceDataGPS::setSpeedErrorField()
     * @uses DeviceDataGPS::setSpeedField()
     * @param string $gPSTimeField
     * @param int $headingField
     * @param int $latLongErrorField
     * @param float $latitudeField
     * @param float $longitudeField
     * @param string $nSatellitesField
     * @param bool $nSatellitesFieldSpecified
     * @param float $odometerField
     * @param int $speedErrorField
     * @param int $speedField
     */
    public function __construct($gPSTimeField = null, $headingField = null, $latLongErrorField = null, $latitudeField = null, $longitudeField = null, $nSatellitesField = null, $nSatellitesFieldSpecified = null, $odometerField = null, $speedErrorField = null, $speedField = null)
    {
        $this
            ->setGPSTimeField($gPSTimeField)
            ->setHeadingField($headingField)
            ->setLatLongErrorField($latLongErrorField)
            ->setLatitudeField($latitudeField)
            ->setLongitudeField($longitudeField)
            ->setNSatellitesField($nSatellitesField)
            ->setNSatellitesFieldSpecified($nSatellitesFieldSpecified)
            ->setOdometerField($odometerField)
            ->setSpeedErrorField($speedErrorField)
            ->setSpeedField($speedField);
    }
    /**
     * Get gPSTimeField value
     * @return string|null
     */
    public function getGPSTimeField()
    {
        return $this->gPSTimeField;
    }
    /**
     * Set gPSTimeField value
     * @param string $gPSTimeField
     * @return \StructType\DeviceDataGPS
     */
    public function setGPSTimeField($gPSTimeField = null)
    {
        // validation for constraint: string
        if (!is_null($gPSTimeField) && !is_string($gPSTimeField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gPSTimeField, true), gettype($gPSTimeField)), __LINE__);
        }
        $this->gPSTimeField = $gPSTimeField;
        return $this;
    }
    /**
     * Get headingField value
     * @return int|null
     */
    public function getHeadingField()
    {
        return $this->headingField;
    }
    /**
     * Set headingField value
     * @param int $headingField
     * @return \StructType\DeviceDataGPS
     */
    public function setHeadingField($headingField = null)
    {
        // validation for constraint: int
        if (!is_null($headingField) && !(is_int($headingField) || ctype_digit($headingField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($headingField, true), gettype($headingField)), __LINE__);
        }
        $this->headingField = $headingField;
        return $this;
    }
    /**
     * Get latLongErrorField value
     * @return int|null
     */
    public function getLatLongErrorField()
    {
        return $this->latLongErrorField;
    }
    /**
     * Set latLongErrorField value
     * @param int $latLongErrorField
     * @return \StructType\DeviceDataGPS
     */
    public function setLatLongErrorField($latLongErrorField = null)
    {
        // validation for constraint: int
        if (!is_null($latLongErrorField) && !(is_int($latLongErrorField) || ctype_digit($latLongErrorField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($latLongErrorField, true), gettype($latLongErrorField)), __LINE__);
        }
        $this->latLongErrorField = $latLongErrorField;
        return $this;
    }
    /**
     * Get latitudeField value
     * @return float|null
     */
    public function getLatitudeField()
    {
        return $this->latitudeField;
    }
    /**
     * Set latitudeField value
     * @param float $latitudeField
     * @return \StructType\DeviceDataGPS
     */
    public function setLatitudeField($latitudeField = null)
    {
        // validation for constraint: float
        if (!is_null($latitudeField) && !(is_float($latitudeField) || is_numeric($latitudeField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($latitudeField, true), gettype($latitudeField)), __LINE__);
        }
        $this->latitudeField = $latitudeField;
        return $this;
    }
    /**
     * Get longitudeField value
     * @return float|null
     */
    public function getLongitudeField()
    {
        return $this->longitudeField;
    }
    /**
     * Set longitudeField value
     * @param float $longitudeField
     * @return \StructType\DeviceDataGPS
     */
    public function setLongitudeField($longitudeField = null)
    {
        // validation for constraint: float
        if (!is_null($longitudeField) && !(is_float($longitudeField) || is_numeric($longitudeField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($longitudeField, true), gettype($longitudeField)), __LINE__);
        }
        $this->longitudeField = $longitudeField;
        return $this;
    }
    /**
     * Get nSatellitesField value
     * @return string|null
     */
    public function getNSatellitesField()
    {
        return $this->nSatellitesField;
    }
    /**
     * Set nSatellitesField value
     * @param string $nSatellitesField
     * @return \StructType\DeviceDataGPS
     */
    public function setNSatellitesField($nSatellitesField = null)
    {
        // validation for constraint: string
        if (!is_null($nSatellitesField) && !is_string($nSatellitesField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nSatellitesField, true), gettype($nSatellitesField)), __LINE__);
        }
        $this->nSatellitesField = $nSatellitesField;
        return $this;
    }
    /**
     * Get nSatellitesFieldSpecified value
     * @return bool|null
     */
    public function getNSatellitesFieldSpecified()
    {
        return $this->nSatellitesFieldSpecified;
    }
    /**
     * Set nSatellitesFieldSpecified value
     * @param bool $nSatellitesFieldSpecified
     * @return \StructType\DeviceDataGPS
     */
    public function setNSatellitesFieldSpecified($nSatellitesFieldSpecified = null)
    {
        // validation for constraint: boolean
        if (!is_null($nSatellitesFieldSpecified) && !is_bool($nSatellitesFieldSpecified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($nSatellitesFieldSpecified, true), gettype($nSatellitesFieldSpecified)), __LINE__);
        }
        $this->nSatellitesFieldSpecified = $nSatellitesFieldSpecified;
        return $this;
    }
    /**
     * Get odometerField value
     * @return float|null
     */
    public function getOdometerField()
    {
        return $this->odometerField;
    }
    /**
     * Set odometerField value
     * @param float $odometerField
     * @return \StructType\DeviceDataGPS
     */
    public function setOdometerField($odometerField = null)
    {
        // validation for constraint: float
        if (!is_null($odometerField) && !(is_float($odometerField) || is_numeric($odometerField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($odometerField, true), gettype($odometerField)), __LINE__);
        }
        $this->odometerField = $odometerField;
        return $this;
    }
    /**
     * Get speedErrorField value
     * @return int|null
     */
    public function getSpeedErrorField()
    {
        return $this->speedErrorField;
    }
    /**
     * Set speedErrorField value
     * @param int $speedErrorField
     * @return \StructType\DeviceDataGPS
     */
    public function setSpeedErrorField($speedErrorField = null)
    {
        // validation for constraint: int
        if (!is_null($speedErrorField) && !(is_int($speedErrorField) || ctype_digit($speedErrorField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($speedErrorField, true), gettype($speedErrorField)), __LINE__);
        }
        $this->speedErrorField = $speedErrorField;
        return $this;
    }
    /**
     * Get speedField value
     * @return int|null
     */
    public function getSpeedField()
    {
        return $this->speedField;
    }
    /**
     * Set speedField value
     * @param int $speedField
     * @return \StructType\DeviceDataGPS
     */
    public function setSpeedField($speedField = null)
    {
        // validation for constraint: int
        if (!is_null($speedField) && !(is_int($speedField) || ctype_digit($speedField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($speedField, true), gettype($speedField)), __LINE__);
        }
        $this->speedField = $speedField;
        return $this;
    }
}
