<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeviceDataEvent StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DeviceDataEvent
 * @subpackage Structs
 */
class DeviceDataEvent extends AbstractStructBase
{
    /**
     * The dateTimeField
     * @var string
     */
    public $dateTimeField;
    /**
     * The eventIDField
     * @var string
     */
    public $eventIDField;
    /**
     * The internalRouteIDField
     * @var int
     */
    public $internalRouteIDField;
    /**
     * The ordersField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfDeviceDataEventOrders
     */
    public $ordersField;
    /**
     * Constructor method for DeviceDataEvent
     * @uses DeviceDataEvent::setDateTimeField()
     * @uses DeviceDataEvent::setEventIDField()
     * @uses DeviceDataEvent::setInternalRouteIDField()
     * @uses DeviceDataEvent::setOrdersField()
     * @param string $dateTimeField
     * @param string $eventIDField
     * @param int $internalRouteIDField
     * @param \ArrayType\ArrayOfDeviceDataEventOrders $ordersField
     */
    public function __construct($dateTimeField = null, $eventIDField = null, $internalRouteIDField = null, \ArrayType\ArrayOfDeviceDataEventOrders $ordersField = null)
    {
        $this
            ->setDateTimeField($dateTimeField)
            ->setEventIDField($eventIDField)
            ->setInternalRouteIDField($internalRouteIDField)
            ->setOrdersField($ordersField);
    }
    /**
     * Get dateTimeField value
     * @return string|null
     */
    public function getDateTimeField()
    {
        return $this->dateTimeField;
    }
    /**
     * Set dateTimeField value
     * @param string $dateTimeField
     * @return \StructType\DeviceDataEvent
     */
    public function setDateTimeField($dateTimeField = null)
    {
        // validation for constraint: string
        if (!is_null($dateTimeField) && !is_string($dateTimeField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTimeField, true), gettype($dateTimeField)), __LINE__);
        }
        $this->dateTimeField = $dateTimeField;
        return $this;
    }
    /**
     * Get eventIDField value
     * @return string|null
     */
    public function getEventIDField()
    {
        return $this->eventIDField;
    }
    /**
     * Set eventIDField value
     * @uses \EnumType\EventID::valueIsValid()
     * @uses \EnumType\EventID::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $eventIDField
     * @return \StructType\DeviceDataEvent
     */
    public function setEventIDField($eventIDField = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EventID::valueIsValid($eventIDField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EventID', is_array($eventIDField) ? implode(', ', $eventIDField) : var_export($eventIDField, true), implode(', ', \EnumType\EventID::getValidValues())), __LINE__);
        }
        $this->eventIDField = $eventIDField;
        return $this;
    }
    /**
     * Get internalRouteIDField value
     * @return int|null
     */
    public function getInternalRouteIDField()
    {
        return $this->internalRouteIDField;
    }
    /**
     * Set internalRouteIDField value
     * @param int $internalRouteIDField
     * @return \StructType\DeviceDataEvent
     */
    public function setInternalRouteIDField($internalRouteIDField = null)
    {
        // validation for constraint: int
        if (!is_null($internalRouteIDField) && !(is_int($internalRouteIDField) || ctype_digit($internalRouteIDField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($internalRouteIDField, true), gettype($internalRouteIDField)), __LINE__);
        }
        $this->internalRouteIDField = $internalRouteIDField;
        return $this;
    }
    /**
     * Get ordersField value
     * @return \ArrayType\ArrayOfDeviceDataEventOrders|null
     */
    public function getOrdersField()
    {
        return $this->ordersField;
    }
    /**
     * Set ordersField value
     * @param \ArrayType\ArrayOfDeviceDataEventOrders $ordersField
     * @return \StructType\DeviceDataEvent
     */
    public function setOrdersField(\ArrayType\ArrayOfDeviceDataEventOrders $ordersField = null)
    {
        $this->ordersField = $ordersField;
        return $this;
    }
}
