<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeviceData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DeviceData
 * @subpackage Structs
 */
class DeviceData extends AbstractStructBase
{
    /**
     * The deviceIDField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $deviceIDField;
    /**
     * The deviceTypeField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $deviceTypeField;
    /**
     * The doStopDetectionField
     * @var bool
     */
    public $doStopDetectionField;
    /**
     * The doStopMatchingField
     * @var bool
     */
    public $doStopMatchingField;
    /**
     * The driverIDField
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $driverIDField;
    /**
     * The eventsField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfDeviceDataEvent
     */
    public $eventsField;
    /**
     * The gPSErrorsField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfDeviceDataGPS1
     */
    public $gPSErrorsField;
    /**
     * The gPSListField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfDeviceDataGPS
     */
    public $gPSListField;
    /**
     * The stopListField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfDeviceDataStop
     */
    public $stopListField;
    /**
     * The uniqueIDField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $uniqueIDField;
    /**
     * Constructor method for DeviceData
     * @uses DeviceData::setDeviceIDField()
     * @uses DeviceData::setDeviceTypeField()
     * @uses DeviceData::setDoStopDetectionField()
     * @uses DeviceData::setDoStopMatchingField()
     * @uses DeviceData::setDriverIDField()
     * @uses DeviceData::setEventsField()
     * @uses DeviceData::setGPSErrorsField()
     * @uses DeviceData::setGPSListField()
     * @uses DeviceData::setStopListField()
     * @uses DeviceData::setUniqueIDField()
     * @param string $deviceIDField
     * @param string $deviceTypeField
     * @param bool $doStopDetectionField
     * @param bool $doStopMatchingField
     * @param string $driverIDField
     * @param \ArrayType\ArrayOfDeviceDataEvent $eventsField
     * @param \ArrayType\ArrayOfDeviceDataGPS1 $gPSErrorsField
     * @param \ArrayType\ArrayOfDeviceDataGPS $gPSListField
     * @param \ArrayType\ArrayOfDeviceDataStop $stopListField
     * @param string $uniqueIDField
     */
    public function __construct($deviceIDField = null, $deviceTypeField = null, $doStopDetectionField = null, $doStopMatchingField = null, $driverIDField = null, \ArrayType\ArrayOfDeviceDataEvent $eventsField = null, \ArrayType\ArrayOfDeviceDataGPS1 $gPSErrorsField = null, \ArrayType\ArrayOfDeviceDataGPS $gPSListField = null, \ArrayType\ArrayOfDeviceDataStop $stopListField = null, $uniqueIDField = null)
    {
        $this
            ->setDeviceIDField($deviceIDField)
            ->setDeviceTypeField($deviceTypeField)
            ->setDoStopDetectionField($doStopDetectionField)
            ->setDoStopMatchingField($doStopMatchingField)
            ->setDriverIDField($driverIDField)
            ->setEventsField($eventsField)
            ->setGPSErrorsField($gPSErrorsField)
            ->setGPSListField($gPSListField)
            ->setStopListField($stopListField)
            ->setUniqueIDField($uniqueIDField);
    }
    /**
     * Get deviceIDField value
     * @return string|null
     */
    public function getDeviceIDField()
    {
        return $this->deviceIDField;
    }
    /**
     * Set deviceIDField value
     * @param string $deviceIDField
     * @return \StructType\DeviceData
     */
    public function setDeviceIDField($deviceIDField = null)
    {
        // validation for constraint: string
        if (!is_null($deviceIDField) && !is_string($deviceIDField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceIDField, true), gettype($deviceIDField)), __LINE__);
        }
        $this->deviceIDField = $deviceIDField;
        return $this;
    }
    /**
     * Get deviceTypeField value
     * @return string|null
     */
    public function getDeviceTypeField()
    {
        return $this->deviceTypeField;
    }
    /**
     * Set deviceTypeField value
     * @param string $deviceTypeField
     * @return \StructType\DeviceData
     */
    public function setDeviceTypeField($deviceTypeField = null)
    {
        // validation for constraint: string
        if (!is_null($deviceTypeField) && !is_string($deviceTypeField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceTypeField, true), gettype($deviceTypeField)), __LINE__);
        }
        $this->deviceTypeField = $deviceTypeField;
        return $this;
    }
    /**
     * Get doStopDetectionField value
     * @return bool|null
     */
    public function getDoStopDetectionField()
    {
        return $this->doStopDetectionField;
    }
    /**
     * Set doStopDetectionField value
     * @param bool $doStopDetectionField
     * @return \StructType\DeviceData
     */
    public function setDoStopDetectionField($doStopDetectionField = null)
    {
        // validation for constraint: boolean
        if (!is_null($doStopDetectionField) && !is_bool($doStopDetectionField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($doStopDetectionField, true), gettype($doStopDetectionField)), __LINE__);
        }
        $this->doStopDetectionField = $doStopDetectionField;
        return $this;
    }
    /**
     * Get doStopMatchingField value
     * @return bool|null
     */
    public function getDoStopMatchingField()
    {
        return $this->doStopMatchingField;
    }
    /**
     * Set doStopMatchingField value
     * @param bool $doStopMatchingField
     * @return \StructType\DeviceData
     */
    public function setDoStopMatchingField($doStopMatchingField = null)
    {
        // validation for constraint: boolean
        if (!is_null($doStopMatchingField) && !is_bool($doStopMatchingField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($doStopMatchingField, true), gettype($doStopMatchingField)), __LINE__);
        }
        $this->doStopMatchingField = $doStopMatchingField;
        return $this;
    }
    /**
     * Get driverIDField value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDriverIDField()
    {
        return isset($this->driverIDField) ? $this->driverIDField : null;
    }
    /**
     * Set driverIDField value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $driverIDField
     * @return \StructType\DeviceData
     */
    public function setDriverIDField($driverIDField = null)
    {
        // validation for constraint: string
        if (!is_null($driverIDField) && !is_string($driverIDField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($driverIDField, true), gettype($driverIDField)), __LINE__);
        }
        if (is_null($driverIDField) || (is_array($driverIDField) && empty($driverIDField))) {
            unset($this->driverIDField);
        } else {
            $this->driverIDField = $driverIDField;
        }
        return $this;
    }
    /**
     * Get eventsField value
     * @return \ArrayType\ArrayOfDeviceDataEvent|null
     */
    public function getEventsField()
    {
        return $this->eventsField;
    }
    /**
     * Set eventsField value
     * @param \ArrayType\ArrayOfDeviceDataEvent $eventsField
     * @return \StructType\DeviceData
     */
    public function setEventsField(\ArrayType\ArrayOfDeviceDataEvent $eventsField = null)
    {
        $this->eventsField = $eventsField;
        return $this;
    }
    /**
     * Get gPSErrorsField value
     * @return \ArrayType\ArrayOfDeviceDataGPS1|null
     */
    public function getGPSErrorsField()
    {
        return $this->gPSErrorsField;
    }
    /**
     * Set gPSErrorsField value
     * @param \ArrayType\ArrayOfDeviceDataGPS1 $gPSErrorsField
     * @return \StructType\DeviceData
     */
    public function setGPSErrorsField(\ArrayType\ArrayOfDeviceDataGPS1 $gPSErrorsField = null)
    {
        $this->gPSErrorsField = $gPSErrorsField;
        return $this;
    }
    /**
     * Get gPSListField value
     * @return \ArrayType\ArrayOfDeviceDataGPS|null
     */
    public function getGPSListField()
    {
        return $this->gPSListField;
    }
    /**
     * Set gPSListField value
     * @param \ArrayType\ArrayOfDeviceDataGPS $gPSListField
     * @return \StructType\DeviceData
     */
    public function setGPSListField(\ArrayType\ArrayOfDeviceDataGPS $gPSListField = null)
    {
        $this->gPSListField = $gPSListField;
        return $this;
    }
    /**
     * Get stopListField value
     * @return \ArrayType\ArrayOfDeviceDataStop|null
     */
    public function getStopListField()
    {
        return $this->stopListField;
    }
    /**
     * Set stopListField value
     * @param \ArrayType\ArrayOfDeviceDataStop $stopListField
     * @return \StructType\DeviceData
     */
    public function setStopListField(\ArrayType\ArrayOfDeviceDataStop $stopListField = null)
    {
        $this->stopListField = $stopListField;
        return $this;
    }
    /**
     * Get uniqueIDField value
     * @return string|null
     */
    public function getUniqueIDField()
    {
        return $this->uniqueIDField;
    }
    /**
     * Set uniqueIDField value
     * @param string $uniqueIDField
     * @return \StructType\DeviceData
     */
    public function setUniqueIDField($uniqueIDField = null)
    {
        // validation for constraint: string
        if (!is_null($uniqueIDField) && !is_string($uniqueIDField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uniqueIDField, true), gettype($uniqueIDField)), __LINE__);
        }
        $this->uniqueIDField = $uniqueIDField;
        return $this;
    }
}
