<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DROrderType StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DROrderType
 * @subpackage Structs
 */
class DROrderType extends DRStopType
{
    /**
     * The earliestDateField
     * @var string
     */
    public $earliestDateField;
    /**
     * The externalIdField
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $externalIdField;
    /**
     * The iD2Field
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $iD2Field;
    /**
     * The latestDateField
     * @var string
     */
    public $latestDateField;
    /**
     * The priorityBumpField
     * @var int
     */
    public $priorityBumpField;
    /**
     * The priorityField
     * @var int
     */
    public $priorityField;
    /**
     * The reservationIDField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $reservationIDField;
    /**
     * The typeField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $typeField;
    /**
     * Constructor method for DROrderType
     * @uses DROrderType::setEarliestDateField()
     * @uses DROrderType::setExternalIdField()
     * @uses DROrderType::setID2Field()
     * @uses DROrderType::setLatestDateField()
     * @uses DROrderType::setPriorityBumpField()
     * @uses DROrderType::setPriorityField()
     * @uses DROrderType::setReservationIDField()
     * @uses DROrderType::setTypeField()
     * @param string $earliestDateField
     * @param string $externalIdField
     * @param string $iD2Field
     * @param string $latestDateField
     * @param int $priorityBumpField
     * @param int $priorityField
     * @param string $reservationIDField
     * @param string $typeField
     */
    public function __construct($earliestDateField = null, $externalIdField = null, $iD2Field = null, $latestDateField = null, $priorityBumpField = null, $priorityField = null, $reservationIDField = null, $typeField = null)
    {
        $this
            ->setEarliestDateField($earliestDateField)
            ->setExternalIdField($externalIdField)
            ->setID2Field($iD2Field)
            ->setLatestDateField($latestDateField)
            ->setPriorityBumpField($priorityBumpField)
            ->setPriorityField($priorityField)
            ->setReservationIDField($reservationIDField)
            ->setTypeField($typeField);
    }
    /**
     * Get earliestDateField value
     * @return string|null
     */
    public function getEarliestDateField()
    {
        return $this->earliestDateField;
    }
    /**
     * Set earliestDateField value
     * @param string $earliestDateField
     * @return \StructType\DROrderType
     */
    public function setEarliestDateField($earliestDateField = null)
    {
        // validation for constraint: string
        if (!is_null($earliestDateField) && !is_string($earliestDateField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($earliestDateField, true), gettype($earliestDateField)), __LINE__);
        }
        $this->earliestDateField = $earliestDateField;
        return $this;
    }
    /**
     * Get externalIdField value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalIdField()
    {
        return isset($this->externalIdField) ? $this->externalIdField : null;
    }
    /**
     * Set externalIdField value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalIdField
     * @return \StructType\DROrderType
     */
    public function setExternalIdField($externalIdField = null)
    {
        // validation for constraint: string
        if (!is_null($externalIdField) && !is_string($externalIdField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalIdField, true), gettype($externalIdField)), __LINE__);
        }
        if (is_null($externalIdField) || (is_array($externalIdField) && empty($externalIdField))) {
            unset($this->externalIdField);
        } else {
            $this->externalIdField = $externalIdField;
        }
        return $this;
    }
    /**
     * Get iD2Field value
     * @return string|null
     */
    public function getID2Field()
    {
        return $this->iD2Field;
    }
    /**
     * Set iD2Field value
     * @param string $iD2Field
     * @return \StructType\DROrderType
     */
    public function setID2Field($iD2Field = null)
    {
        // validation for constraint: string
        if (!is_null($iD2Field) && !is_string($iD2Field)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD2Field, true), gettype($iD2Field)), __LINE__);
        }
        $this->iD2Field = $iD2Field;
        return $this;
    }
    /**
     * Get latestDateField value
     * @return string|null
     */
    public function getLatestDateField()
    {
        return $this->latestDateField;
    }
    /**
     * Set latestDateField value
     * @param string $latestDateField
     * @return \StructType\DROrderType
     */
    public function setLatestDateField($latestDateField = null)
    {
        // validation for constraint: string
        if (!is_null($latestDateField) && !is_string($latestDateField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($latestDateField, true), gettype($latestDateField)), __LINE__);
        }
        $this->latestDateField = $latestDateField;
        return $this;
    }
    /**
     * Get priorityBumpField value
     * @return int|null
     */
    public function getPriorityBumpField()
    {
        return $this->priorityBumpField;
    }
    /**
     * Set priorityBumpField value
     * @param int $priorityBumpField
     * @return \StructType\DROrderType
     */
    public function setPriorityBumpField($priorityBumpField = null)
    {
        // validation for constraint: int
        if (!is_null($priorityBumpField) && !(is_int($priorityBumpField) || ctype_digit($priorityBumpField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priorityBumpField, true), gettype($priorityBumpField)), __LINE__);
        }
        $this->priorityBumpField = $priorityBumpField;
        return $this;
    }
    /**
     * Get priorityField value
     * @return int|null
     */
    public function getPriorityField()
    {
        return $this->priorityField;
    }
    /**
     * Set priorityField value
     * @param int $priorityField
     * @return \StructType\DROrderType
     */
    public function setPriorityField($priorityField = null)
    {
        // validation for constraint: int
        if (!is_null($priorityField) && !(is_int($priorityField) || ctype_digit($priorityField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priorityField, true), gettype($priorityField)), __LINE__);
        }
        $this->priorityField = $priorityField;
        return $this;
    }
    /**
     * Get reservationIDField value
     * @return string|null
     */
    public function getReservationIDField()
    {
        return $this->reservationIDField;
    }
    /**
     * Set reservationIDField value
     * @param string $reservationIDField
     * @return \StructType\DROrderType
     */
    public function setReservationIDField($reservationIDField = null)
    {
        // validation for constraint: string
        if (!is_null($reservationIDField) && !is_string($reservationIDField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reservationIDField, true), gettype($reservationIDField)), __LINE__);
        }
        $this->reservationIDField = $reservationIDField;
        return $this;
    }
    /**
     * Get typeField value
     * @return string|null
     */
    public function getTypeField()
    {
        return $this->typeField;
    }
    /**
     * Set typeField value
     * @param string $typeField
     * @return \StructType\DROrderType
     */
    public function setTypeField($typeField = null)
    {
        // validation for constraint: string
        if (!is_null($typeField) && !is_string($typeField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeField, true), gettype($typeField)), __LINE__);
        }
        $this->typeField = $typeField;
        return $this;
    }
}
