<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DRAccountType StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DRAccountType
 * @subpackage Structs
 */
class DRAccountType extends AbstractStructBase
{
    /**
     * The aMAdjField
     * @var int
     */
    public $aMAdjField;
    /**
     * The aMEndField
     * @var string
     */
    public $aMEndField;
    /**
     * The aMStartField
     * @var string
     */
    public $aMStartField;
    /**
     * The address2Field
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $address2Field;
    /**
     * The addressField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $addressField;
    /**
     * The branchField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $branchField;
    /**
     * The cityField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $cityField;
    /**
     * The closeTWField
     * @var bool
     */
    public $closeTWField;
    /**
     * The colorField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $colorField;
    /**
     * The contactField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $contactField;
    /**
     * The dRAccountScheduleField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\DRAccountSchedule
     */
    public $dRAccountScheduleField;
    /**
     * The dRMasterStopEnvelopeField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfDRStop
     */
    public $dRMasterStopEnvelopeField;
    /**
     * The dRTimeWindowField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfDRTimeWindow
     */
    public $dRTimeWindowField;
    /**
     * The dRUserFieldField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfDRUserField
     */
    public $dRUserFieldField;
    /**
     * The dRVolumeField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfDRVolume
     */
    public $dRVolumeField;
    /**
     * The earlyBufferField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $earlyBufferField;
    /**
     * The eqCodeField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $eqCodeField;
    /**
     * The fixedTimeField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $fixedTimeField;
    /**
     * The geoFenceField
     * @var int
     */
    public $geoFenceField;
    /**
     * The geoResultField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $geoResultField;
    /**
     * The iD1Field
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $iD1Field;
    /**
     * The importAccountTypeField
     * @var string
     */
    public $importAccountTypeField;
    /**
     * The lateBufferField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $lateBufferField;
    /**
     * The latitudeField
     * @var float
     */
    public $latitudeField;
    /**
     * The longitudeField
     * @var float
     */
    public $longitudeField;
    /**
     * The maxSplitsField
     * @var int
     */
    public $maxSplitsField;
    /**
     * The nameField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $nameField;
    /**
     * The onFinalizeField
     * @var string
     */
    public $onFinalizeField;
    /**
     * The pMAdjField
     * @var int
     */
    public $pMAdjField;
    /**
     * The pMEndField
     * @var string
     */
    public $pMEndField;
    /**
     * The pMStartField
     * @var string
     */
    public $pMStartField;
    /**
     * The penaltyCostField
     * @var float
     */
    public $penaltyCostField;
    /**
     * The phoneField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $phoneField;
    /**
     * The rotationField
     * @var int
     */
    public $rotationField;
    /**
     * The shipToField
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfInsertShipToDetails
     */
    public $shipToField;
    /**
     * The sizeField
     * @var int
     */
    public $sizeField;
    /**
     * The sizeRestrictionField
     * @var float
     */
    public $sizeRestrictionField;
    /**
     * The stateField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $stateField;
    /**
     * The symbolField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $symbolField;
    /**
     * The zipField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $zipField;
    /**
     * The zoneField
     * @var int
     */
    public $zoneField;
    /**
     * Constructor method for DRAccountType
     * @uses DRAccountType::setAMAdjField()
     * @uses DRAccountType::setAMEndField()
     * @uses DRAccountType::setAMStartField()
     * @uses DRAccountType::setAddress2Field()
     * @uses DRAccountType::setAddressField()
     * @uses DRAccountType::setBranchField()
     * @uses DRAccountType::setCityField()
     * @uses DRAccountType::setCloseTWField()
     * @uses DRAccountType::setColorField()
     * @uses DRAccountType::setContactField()
     * @uses DRAccountType::setDRAccountScheduleField()
     * @uses DRAccountType::setDRMasterStopEnvelopeField()
     * @uses DRAccountType::setDRTimeWindowField()
     * @uses DRAccountType::setDRUserFieldField()
     * @uses DRAccountType::setDRVolumeField()
     * @uses DRAccountType::setEarlyBufferField()
     * @uses DRAccountType::setEqCodeField()
     * @uses DRAccountType::setFixedTimeField()
     * @uses DRAccountType::setGeoFenceField()
     * @uses DRAccountType::setGeoResultField()
     * @uses DRAccountType::setID1Field()
     * @uses DRAccountType::setImportAccountTypeField()
     * @uses DRAccountType::setLateBufferField()
     * @uses DRAccountType::setLatitudeField()
     * @uses DRAccountType::setLongitudeField()
     * @uses DRAccountType::setMaxSplitsField()
     * @uses DRAccountType::setNameField()
     * @uses DRAccountType::setOnFinalizeField()
     * @uses DRAccountType::setPMAdjField()
     * @uses DRAccountType::setPMEndField()
     * @uses DRAccountType::setPMStartField()
     * @uses DRAccountType::setPenaltyCostField()
     * @uses DRAccountType::setPhoneField()
     * @uses DRAccountType::setRotationField()
     * @uses DRAccountType::setShipToField()
     * @uses DRAccountType::setSizeField()
     * @uses DRAccountType::setSizeRestrictionField()
     * @uses DRAccountType::setStateField()
     * @uses DRAccountType::setSymbolField()
     * @uses DRAccountType::setZipField()
     * @uses DRAccountType::setZoneField()
     * @param int $aMAdjField
     * @param string $aMEndField
     * @param string $aMStartField
     * @param string $address2Field
     * @param string $addressField
     * @param string $branchField
     * @param string $cityField
     * @param bool $closeTWField
     * @param string $colorField
     * @param string $contactField
     * @param \StructType\DRAccountSchedule $dRAccountScheduleField
     * @param \ArrayType\ArrayOfDRStop $dRMasterStopEnvelopeField
     * @param \ArrayType\ArrayOfDRTimeWindow $dRTimeWindowField
     * @param \ArrayType\ArrayOfDRUserField $dRUserFieldField
     * @param \ArrayType\ArrayOfDRVolume $dRVolumeField
     * @param string $earlyBufferField
     * @param string $eqCodeField
     * @param string $fixedTimeField
     * @param int $geoFenceField
     * @param string $geoResultField
     * @param string $iD1Field
     * @param string $importAccountTypeField
     * @param string $lateBufferField
     * @param float $latitudeField
     * @param float $longitudeField
     * @param int $maxSplitsField
     * @param string $nameField
     * @param string $onFinalizeField
     * @param int $pMAdjField
     * @param string $pMEndField
     * @param string $pMStartField
     * @param float $penaltyCostField
     * @param string $phoneField
     * @param int $rotationField
     * @param \ArrayType\ArrayOfInsertShipToDetails $shipToField
     * @param int $sizeField
     * @param float $sizeRestrictionField
     * @param string $stateField
     * @param string $symbolField
     * @param string $zipField
     * @param int $zoneField
     */
    public function __construct($aMAdjField = null, $aMEndField = null, $aMStartField = null, $address2Field = null, $addressField = null, $branchField = null, $cityField = null, $closeTWField = null, $colorField = null, $contactField = null, \StructType\DRAccountSchedule $dRAccountScheduleField = null, \ArrayType\ArrayOfDRStop $dRMasterStopEnvelopeField = null, \ArrayType\ArrayOfDRTimeWindow $dRTimeWindowField = null, \ArrayType\ArrayOfDRUserField $dRUserFieldField = null, \ArrayType\ArrayOfDRVolume $dRVolumeField = null, $earlyBufferField = null, $eqCodeField = null, $fixedTimeField = null, $geoFenceField = null, $geoResultField = null, $iD1Field = null, $importAccountTypeField = null, $lateBufferField = null, $latitudeField = null, $longitudeField = null, $maxSplitsField = null, $nameField = null, $onFinalizeField = null, $pMAdjField = null, $pMEndField = null, $pMStartField = null, $penaltyCostField = null, $phoneField = null, $rotationField = null, \ArrayType\ArrayOfInsertShipToDetails $shipToField = null, $sizeField = null, $sizeRestrictionField = null, $stateField = null, $symbolField = null, $zipField = null, $zoneField = null)
    {
        $this
            ->setAMAdjField($aMAdjField)
            ->setAMEndField($aMEndField)
            ->setAMStartField($aMStartField)
            ->setAddress2Field($address2Field)
            ->setAddressField($addressField)
            ->setBranchField($branchField)
            ->setCityField($cityField)
            ->setCloseTWField($closeTWField)
            ->setColorField($colorField)
            ->setContactField($contactField)
            ->setDRAccountScheduleField($dRAccountScheduleField)
            ->setDRMasterStopEnvelopeField($dRMasterStopEnvelopeField)
            ->setDRTimeWindowField($dRTimeWindowField)
            ->setDRUserFieldField($dRUserFieldField)
            ->setDRVolumeField($dRVolumeField)
            ->setEarlyBufferField($earlyBufferField)
            ->setEqCodeField($eqCodeField)
            ->setFixedTimeField($fixedTimeField)
            ->setGeoFenceField($geoFenceField)
            ->setGeoResultField($geoResultField)
            ->setID1Field($iD1Field)
            ->setImportAccountTypeField($importAccountTypeField)
            ->setLateBufferField($lateBufferField)
            ->setLatitudeField($latitudeField)
            ->setLongitudeField($longitudeField)
            ->setMaxSplitsField($maxSplitsField)
            ->setNameField($nameField)
            ->setOnFinalizeField($onFinalizeField)
            ->setPMAdjField($pMAdjField)
            ->setPMEndField($pMEndField)
            ->setPMStartField($pMStartField)
            ->setPenaltyCostField($penaltyCostField)
            ->setPhoneField($phoneField)
            ->setRotationField($rotationField)
            ->setShipToField($shipToField)
            ->setSizeField($sizeField)
            ->setSizeRestrictionField($sizeRestrictionField)
            ->setStateField($stateField)
            ->setSymbolField($symbolField)
            ->setZipField($zipField)
            ->setZoneField($zoneField);
    }
    /**
     * Get aMAdjField value
     * @return int|null
     */
    public function getAMAdjField()
    {
        return $this->aMAdjField;
    }
    /**
     * Set aMAdjField value
     * @param int $aMAdjField
     * @return \StructType\DRAccountType
     */
    public function setAMAdjField($aMAdjField = null)
    {
        // validation for constraint: int
        if (!is_null($aMAdjField) && !(is_int($aMAdjField) || ctype_digit($aMAdjField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aMAdjField, true), gettype($aMAdjField)), __LINE__);
        }
        $this->aMAdjField = $aMAdjField;
        return $this;
    }
    /**
     * Get aMEndField value
     * @return string|null
     */
    public function getAMEndField()
    {
        return $this->aMEndField;
    }
    /**
     * Set aMEndField value
     * @param string $aMEndField
     * @return \StructType\DRAccountType
     */
    public function setAMEndField($aMEndField = null)
    {
        // validation for constraint: string
        if (!is_null($aMEndField) && !is_string($aMEndField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aMEndField, true), gettype($aMEndField)), __LINE__);
        }
        $this->aMEndField = $aMEndField;
        return $this;
    }
    /**
     * Get aMStartField value
     * @return string|null
     */
    public function getAMStartField()
    {
        return $this->aMStartField;
    }
    /**
     * Set aMStartField value
     * @param string $aMStartField
     * @return \StructType\DRAccountType
     */
    public function setAMStartField($aMStartField = null)
    {
        // validation for constraint: string
        if (!is_null($aMStartField) && !is_string($aMStartField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aMStartField, true), gettype($aMStartField)), __LINE__);
        }
        $this->aMStartField = $aMStartField;
        return $this;
    }
    /**
     * Get address2Field value
     * @return string|null
     */
    public function getAddress2Field()
    {
        return $this->address2Field;
    }
    /**
     * Set address2Field value
     * @param string $address2Field
     * @return \StructType\DRAccountType
     */
    public function setAddress2Field($address2Field = null)
    {
        // validation for constraint: string
        if (!is_null($address2Field) && !is_string($address2Field)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address2Field, true), gettype($address2Field)), __LINE__);
        }
        $this->address2Field = $address2Field;
        return $this;
    }
    /**
     * Get addressField value
     * @return string|null
     */
    public function getAddressField()
    {
        return $this->addressField;
    }
    /**
     * Set addressField value
     * @param string $addressField
     * @return \StructType\DRAccountType
     */
    public function setAddressField($addressField = null)
    {
        // validation for constraint: string
        if (!is_null($addressField) && !is_string($addressField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressField, true), gettype($addressField)), __LINE__);
        }
        $this->addressField = $addressField;
        return $this;
    }
    /**
     * Get branchField value
     * @return string|null
     */
    public function getBranchField()
    {
        return $this->branchField;
    }
    /**
     * Set branchField value
     * @param string $branchField
     * @return \StructType\DRAccountType
     */
    public function setBranchField($branchField = null)
    {
        // validation for constraint: string
        if (!is_null($branchField) && !is_string($branchField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($branchField, true), gettype($branchField)), __LINE__);
        }
        $this->branchField = $branchField;
        return $this;
    }
    /**
     * Get cityField value
     * @return string|null
     */
    public function getCityField()
    {
        return $this->cityField;
    }
    /**
     * Set cityField value
     * @param string $cityField
     * @return \StructType\DRAccountType
     */
    public function setCityField($cityField = null)
    {
        // validation for constraint: string
        if (!is_null($cityField) && !is_string($cityField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cityField, true), gettype($cityField)), __LINE__);
        }
        $this->cityField = $cityField;
        return $this;
    }
    /**
     * Get closeTWField value
     * @return bool|null
     */
    public function getCloseTWField()
    {
        return $this->closeTWField;
    }
    /**
     * Set closeTWField value
     * @param bool $closeTWField
     * @return \StructType\DRAccountType
     */
    public function setCloseTWField($closeTWField = null)
    {
        // validation for constraint: boolean
        if (!is_null($closeTWField) && !is_bool($closeTWField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($closeTWField, true), gettype($closeTWField)), __LINE__);
        }
        $this->closeTWField = $closeTWField;
        return $this;
    }
    /**
     * Get colorField value
     * @return string|null
     */
    public function getColorField()
    {
        return $this->colorField;
    }
    /**
     * Set colorField value
     * @param string $colorField
     * @return \StructType\DRAccountType
     */
    public function setColorField($colorField = null)
    {
        // validation for constraint: string
        if (!is_null($colorField) && !is_string($colorField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($colorField, true), gettype($colorField)), __LINE__);
        }
        $this->colorField = $colorField;
        return $this;
    }
    /**
     * Get contactField value
     * @return string|null
     */
    public function getContactField()
    {
        return $this->contactField;
    }
    /**
     * Set contactField value
     * @param string $contactField
     * @return \StructType\DRAccountType
     */
    public function setContactField($contactField = null)
    {
        // validation for constraint: string
        if (!is_null($contactField) && !is_string($contactField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactField, true), gettype($contactField)), __LINE__);
        }
        $this->contactField = $contactField;
        return $this;
    }
    /**
     * Get dRAccountScheduleField value
     * @return \StructType\DRAccountSchedule|null
     */
    public function getDRAccountScheduleField()
    {
        return $this->dRAccountScheduleField;
    }
    /**
     * Set dRAccountScheduleField value
     * @param \StructType\DRAccountSchedule $dRAccountScheduleField
     * @return \StructType\DRAccountType
     */
    public function setDRAccountScheduleField(\StructType\DRAccountSchedule $dRAccountScheduleField = null)
    {
        $this->dRAccountScheduleField = $dRAccountScheduleField;
        return $this;
    }
    /**
     * Get dRMasterStopEnvelopeField value
     * @return \ArrayType\ArrayOfDRStop|null
     */
    public function getDRMasterStopEnvelopeField()
    {
        return $this->dRMasterStopEnvelopeField;
    }
    /**
     * Set dRMasterStopEnvelopeField value
     * @param \ArrayType\ArrayOfDRStop $dRMasterStopEnvelopeField
     * @return \StructType\DRAccountType
     */
    public function setDRMasterStopEnvelopeField(\ArrayType\ArrayOfDRStop $dRMasterStopEnvelopeField = null)
    {
        $this->dRMasterStopEnvelopeField = $dRMasterStopEnvelopeField;
        return $this;
    }
    /**
     * Get dRTimeWindowField value
     * @return \ArrayType\ArrayOfDRTimeWindow|null
     */
    public function getDRTimeWindowField()
    {
        return $this->dRTimeWindowField;
    }
    /**
     * Set dRTimeWindowField value
     * @param \ArrayType\ArrayOfDRTimeWindow $dRTimeWindowField
     * @return \StructType\DRAccountType
     */
    public function setDRTimeWindowField(\ArrayType\ArrayOfDRTimeWindow $dRTimeWindowField = null)
    {
        $this->dRTimeWindowField = $dRTimeWindowField;
        return $this;
    }
    /**
     * Get dRUserFieldField value
     * @return \ArrayType\ArrayOfDRUserField|null
     */
    public function getDRUserFieldField()
    {
        return $this->dRUserFieldField;
    }
    /**
     * Set dRUserFieldField value
     * @param \ArrayType\ArrayOfDRUserField $dRUserFieldField
     * @return \StructType\DRAccountType
     */
    public function setDRUserFieldField(\ArrayType\ArrayOfDRUserField $dRUserFieldField = null)
    {
        $this->dRUserFieldField = $dRUserFieldField;
        return $this;
    }
    /**
     * Get dRVolumeField value
     * @return \ArrayType\ArrayOfDRVolume|null
     */
    public function getDRVolumeField()
    {
        return $this->dRVolumeField;
    }
    /**
     * Set dRVolumeField value
     * @param \ArrayType\ArrayOfDRVolume $dRVolumeField
     * @return \StructType\DRAccountType
     */
    public function setDRVolumeField(\ArrayType\ArrayOfDRVolume $dRVolumeField = null)
    {
        $this->dRVolumeField = $dRVolumeField;
        return $this;
    }
    /**
     * Get earlyBufferField value
     * @return string|null
     */
    public function getEarlyBufferField()
    {
        return $this->earlyBufferField;
    }
    /**
     * Set earlyBufferField value
     * @param string $earlyBufferField
     * @return \StructType\DRAccountType
     */
    public function setEarlyBufferField($earlyBufferField = null)
    {
        // validation for constraint: string
        if (!is_null($earlyBufferField) && !is_string($earlyBufferField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($earlyBufferField, true), gettype($earlyBufferField)), __LINE__);
        }
        $this->earlyBufferField = $earlyBufferField;
        return $this;
    }
    /**
     * Get eqCodeField value
     * @return string|null
     */
    public function getEqCodeField()
    {
        return $this->eqCodeField;
    }
    /**
     * Set eqCodeField value
     * @param string $eqCodeField
     * @return \StructType\DRAccountType
     */
    public function setEqCodeField($eqCodeField = null)
    {
        // validation for constraint: string
        if (!is_null($eqCodeField) && !is_string($eqCodeField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eqCodeField, true), gettype($eqCodeField)), __LINE__);
        }
        $this->eqCodeField = $eqCodeField;
        return $this;
    }
    /**
     * Get fixedTimeField value
     * @return string|null
     */
    public function getFixedTimeField()
    {
        return $this->fixedTimeField;
    }
    /**
     * Set fixedTimeField value
     * @param string $fixedTimeField
     * @return \StructType\DRAccountType
     */
    public function setFixedTimeField($fixedTimeField = null)
    {
        // validation for constraint: string
        if (!is_null($fixedTimeField) && !is_string($fixedTimeField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fixedTimeField, true), gettype($fixedTimeField)), __LINE__);
        }
        $this->fixedTimeField = $fixedTimeField;
        return $this;
    }
    /**
     * Get geoFenceField value
     * @return int|null
     */
    public function getGeoFenceField()
    {
        return $this->geoFenceField;
    }
    /**
     * Set geoFenceField value
     * @param int $geoFenceField
     * @return \StructType\DRAccountType
     */
    public function setGeoFenceField($geoFenceField = null)
    {
        // validation for constraint: int
        if (!is_null($geoFenceField) && !(is_int($geoFenceField) || ctype_digit($geoFenceField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($geoFenceField, true), gettype($geoFenceField)), __LINE__);
        }
        $this->geoFenceField = $geoFenceField;
        return $this;
    }
    /**
     * Get geoResultField value
     * @return string|null
     */
    public function getGeoResultField()
    {
        return $this->geoResultField;
    }
    /**
     * Set geoResultField value
     * @param string $geoResultField
     * @return \StructType\DRAccountType
     */
    public function setGeoResultField($geoResultField = null)
    {
        // validation for constraint: string
        if (!is_null($geoResultField) && !is_string($geoResultField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($geoResultField, true), gettype($geoResultField)), __LINE__);
        }
        $this->geoResultField = $geoResultField;
        return $this;
    }
    /**
     * Get iD1Field value
     * @return string|null
     */
    public function getID1Field()
    {
        return $this->iD1Field;
    }
    /**
     * Set iD1Field value
     * @param string $iD1Field
     * @return \StructType\DRAccountType
     */
    public function setID1Field($iD1Field = null)
    {
        // validation for constraint: string
        if (!is_null($iD1Field) && !is_string($iD1Field)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD1Field, true), gettype($iD1Field)), __LINE__);
        }
        $this->iD1Field = $iD1Field;
        return $this;
    }
    /**
     * Get importAccountTypeField value
     * @return string|null
     */
    public function getImportAccountTypeField()
    {
        return $this->importAccountTypeField;
    }
    /**
     * Set importAccountTypeField value
     * @uses \EnumType\ImportAccountType::valueIsValid()
     * @uses \EnumType\ImportAccountType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $importAccountTypeField
     * @return \StructType\DRAccountType
     */
    public function setImportAccountTypeField($importAccountTypeField = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ImportAccountType::valueIsValid($importAccountTypeField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ImportAccountType', is_array($importAccountTypeField) ? implode(', ', $importAccountTypeField) : var_export($importAccountTypeField, true), implode(', ', \EnumType\ImportAccountType::getValidValues())), __LINE__);
        }
        $this->importAccountTypeField = $importAccountTypeField;
        return $this;
    }
    /**
     * Get lateBufferField value
     * @return string|null
     */
    public function getLateBufferField()
    {
        return $this->lateBufferField;
    }
    /**
     * Set lateBufferField value
     * @param string $lateBufferField
     * @return \StructType\DRAccountType
     */
    public function setLateBufferField($lateBufferField = null)
    {
        // validation for constraint: string
        if (!is_null($lateBufferField) && !is_string($lateBufferField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lateBufferField, true), gettype($lateBufferField)), __LINE__);
        }
        $this->lateBufferField = $lateBufferField;
        return $this;
    }
    /**
     * Get latitudeField value
     * @return float|null
     */
    public function getLatitudeField()
    {
        return $this->latitudeField;
    }
    /**
     * Set latitudeField value
     * @param float $latitudeField
     * @return \StructType\DRAccountType
     */
    public function setLatitudeField($latitudeField = null)
    {
        // validation for constraint: float
        if (!is_null($latitudeField) && !(is_float($latitudeField) || is_numeric($latitudeField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($latitudeField, true), gettype($latitudeField)), __LINE__);
        }
        $this->latitudeField = $latitudeField;
        return $this;
    }
    /**
     * Get longitudeField value
     * @return float|null
     */
    public function getLongitudeField()
    {
        return $this->longitudeField;
    }
    /**
     * Set longitudeField value
     * @param float $longitudeField
     * @return \StructType\DRAccountType
     */
    public function setLongitudeField($longitudeField = null)
    {
        // validation for constraint: float
        if (!is_null($longitudeField) && !(is_float($longitudeField) || is_numeric($longitudeField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($longitudeField, true), gettype($longitudeField)), __LINE__);
        }
        $this->longitudeField = $longitudeField;
        return $this;
    }
    /**
     * Get maxSplitsField value
     * @return int|null
     */
    public function getMaxSplitsField()
    {
        return $this->maxSplitsField;
    }
    /**
     * Set maxSplitsField value
     * @param int $maxSplitsField
     * @return \StructType\DRAccountType
     */
    public function setMaxSplitsField($maxSplitsField = null)
    {
        // validation for constraint: int
        if (!is_null($maxSplitsField) && !(is_int($maxSplitsField) || ctype_digit($maxSplitsField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxSplitsField, true), gettype($maxSplitsField)), __LINE__);
        }
        $this->maxSplitsField = $maxSplitsField;
        return $this;
    }
    /**
     * Get nameField value
     * @return string|null
     */
    public function getNameField()
    {
        return $this->nameField;
    }
    /**
     * Set nameField value
     * @param string $nameField
     * @return \StructType\DRAccountType
     */
    public function setNameField($nameField = null)
    {
        // validation for constraint: string
        if (!is_null($nameField) && !is_string($nameField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nameField, true), gettype($nameField)), __LINE__);
        }
        $this->nameField = $nameField;
        return $this;
    }
    /**
     * Get onFinalizeField value
     * @return string|null
     */
    public function getOnFinalizeField()
    {
        return $this->onFinalizeField;
    }
    /**
     * Set onFinalizeField value
     * @uses \EnumType\OnFinalize::valueIsValid()
     * @uses \EnumType\OnFinalize::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $onFinalizeField
     * @return \StructType\DRAccountType
     */
    public function setOnFinalizeField($onFinalizeField = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OnFinalize::valueIsValid($onFinalizeField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\OnFinalize', is_array($onFinalizeField) ? implode(', ', $onFinalizeField) : var_export($onFinalizeField, true), implode(', ', \EnumType\OnFinalize::getValidValues())), __LINE__);
        }
        $this->onFinalizeField = $onFinalizeField;
        return $this;
    }
    /**
     * Get pMAdjField value
     * @return int|null
     */
    public function getPMAdjField()
    {
        return $this->pMAdjField;
    }
    /**
     * Set pMAdjField value
     * @param int $pMAdjField
     * @return \StructType\DRAccountType
     */
    public function setPMAdjField($pMAdjField = null)
    {
        // validation for constraint: int
        if (!is_null($pMAdjField) && !(is_int($pMAdjField) || ctype_digit($pMAdjField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pMAdjField, true), gettype($pMAdjField)), __LINE__);
        }
        $this->pMAdjField = $pMAdjField;
        return $this;
    }
    /**
     * Get pMEndField value
     * @return string|null
     */
    public function getPMEndField()
    {
        return $this->pMEndField;
    }
    /**
     * Set pMEndField value
     * @param string $pMEndField
     * @return \StructType\DRAccountType
     */
    public function setPMEndField($pMEndField = null)
    {
        // validation for constraint: string
        if (!is_null($pMEndField) && !is_string($pMEndField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pMEndField, true), gettype($pMEndField)), __LINE__);
        }
        $this->pMEndField = $pMEndField;
        return $this;
    }
    /**
     * Get pMStartField value
     * @return string|null
     */
    public function getPMStartField()
    {
        return $this->pMStartField;
    }
    /**
     * Set pMStartField value
     * @param string $pMStartField
     * @return \StructType\DRAccountType
     */
    public function setPMStartField($pMStartField = null)
    {
        // validation for constraint: string
        if (!is_null($pMStartField) && !is_string($pMStartField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pMStartField, true), gettype($pMStartField)), __LINE__);
        }
        $this->pMStartField = $pMStartField;
        return $this;
    }
    /**
     * Get penaltyCostField value
     * @return float|null
     */
    public function getPenaltyCostField()
    {
        return $this->penaltyCostField;
    }
    /**
     * Set penaltyCostField value
     * @param float $penaltyCostField
     * @return \StructType\DRAccountType
     */
    public function setPenaltyCostField($penaltyCostField = null)
    {
        // validation for constraint: float
        if (!is_null($penaltyCostField) && !(is_float($penaltyCostField) || is_numeric($penaltyCostField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($penaltyCostField, true), gettype($penaltyCostField)), __LINE__);
        }
        $this->penaltyCostField = $penaltyCostField;
        return $this;
    }
    /**
     * Get phoneField value
     * @return string|null
     */
    public function getPhoneField()
    {
        return $this->phoneField;
    }
    /**
     * Set phoneField value
     * @param string $phoneField
     * @return \StructType\DRAccountType
     */
    public function setPhoneField($phoneField = null)
    {
        // validation for constraint: string
        if (!is_null($phoneField) && !is_string($phoneField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneField, true), gettype($phoneField)), __LINE__);
        }
        $this->phoneField = $phoneField;
        return $this;
    }
    /**
     * Get rotationField value
     * @return int|null
     */
    public function getRotationField()
    {
        return $this->rotationField;
    }
    /**
     * Set rotationField value
     * @param int $rotationField
     * @return \StructType\DRAccountType
     */
    public function setRotationField($rotationField = null)
    {
        // validation for constraint: int
        if (!is_null($rotationField) && !(is_int($rotationField) || ctype_digit($rotationField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rotationField, true), gettype($rotationField)), __LINE__);
        }
        $this->rotationField = $rotationField;
        return $this;
    }
    /**
     * Get shipToField value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfInsertShipToDetails|null
     */
    public function getShipToField()
    {
        return isset($this->shipToField) ? $this->shipToField : null;
    }
    /**
     * Set shipToField value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfInsertShipToDetails $shipToField
     * @return \StructType\DRAccountType
     */
    public function setShipToField(\ArrayType\ArrayOfInsertShipToDetails $shipToField = null)
    {
        if (is_null($shipToField) || (is_array($shipToField) && empty($shipToField))) {
            unset($this->shipToField);
        } else {
            $this->shipToField = $shipToField;
        }
        return $this;
    }
    /**
     * Get sizeField value
     * @return int|null
     */
    public function getSizeField()
    {
        return $this->sizeField;
    }
    /**
     * Set sizeField value
     * @param int $sizeField
     * @return \StructType\DRAccountType
     */
    public function setSizeField($sizeField = null)
    {
        // validation for constraint: int
        if (!is_null($sizeField) && !(is_int($sizeField) || ctype_digit($sizeField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sizeField, true), gettype($sizeField)), __LINE__);
        }
        $this->sizeField = $sizeField;
        return $this;
    }
    /**
     * Get sizeRestrictionField value
     * @return float|null
     */
    public function getSizeRestrictionField()
    {
        return $this->sizeRestrictionField;
    }
    /**
     * Set sizeRestrictionField value
     * @param float $sizeRestrictionField
     * @return \StructType\DRAccountType
     */
    public function setSizeRestrictionField($sizeRestrictionField = null)
    {
        // validation for constraint: float
        if (!is_null($sizeRestrictionField) && !(is_float($sizeRestrictionField) || is_numeric($sizeRestrictionField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sizeRestrictionField, true), gettype($sizeRestrictionField)), __LINE__);
        }
        $this->sizeRestrictionField = $sizeRestrictionField;
        return $this;
    }
    /**
     * Get stateField value
     * @return string|null
     */
    public function getStateField()
    {
        return $this->stateField;
    }
    /**
     * Set stateField value
     * @param string $stateField
     * @return \StructType\DRAccountType
     */
    public function setStateField($stateField = null)
    {
        // validation for constraint: string
        if (!is_null($stateField) && !is_string($stateField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stateField, true), gettype($stateField)), __LINE__);
        }
        $this->stateField = $stateField;
        return $this;
    }
    /**
     * Get symbolField value
     * @return string|null
     */
    public function getSymbolField()
    {
        return $this->symbolField;
    }
    /**
     * Set symbolField value
     * @param string $symbolField
     * @return \StructType\DRAccountType
     */
    public function setSymbolField($symbolField = null)
    {
        // validation for constraint: string
        if (!is_null($symbolField) && !is_string($symbolField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($symbolField, true), gettype($symbolField)), __LINE__);
        }
        $this->symbolField = $symbolField;
        return $this;
    }
    /**
     * Get zipField value
     * @return string|null
     */
    public function getZipField()
    {
        return $this->zipField;
    }
    /**
     * Set zipField value
     * @param string $zipField
     * @return \StructType\DRAccountType
     */
    public function setZipField($zipField = null)
    {
        // validation for constraint: string
        if (!is_null($zipField) && !is_string($zipField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipField, true), gettype($zipField)), __LINE__);
        }
        $this->zipField = $zipField;
        return $this;
    }
    /**
     * Get zoneField value
     * @return int|null
     */
    public function getZoneField()
    {
        return $this->zoneField;
    }
    /**
     * Set zoneField value
     * @param int $zoneField
     * @return \StructType\DRAccountType
     */
    public function setZoneField($zoneField = null)
    {
        // validation for constraint: int
        if (!is_null($zoneField) && !(is_int($zoneField) || ctype_digit($zoneField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($zoneField, true), gettype($zoneField)), __LINE__);
        }
        $this->zoneField = $zoneField;
        return $this;
    }
}
