<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BranchType StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BranchType
 * @subpackage Structs
 */
class BranchType extends AbstractStructBase
{
    /**
     * The addressField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $addressField;
    /**
     * The autoLogoffField
     * @var bool
     */
    public $autoLogoffField;
    /**
     * The branchIDField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $branchIDField;
    /**
     * The cityField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $cityField;
    /**
     * The coordinatesField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\Coordinates
     */
    public $coordinatesField;
    /**
     * The daylightSavingsField
     * @var bool
     */
    public $daylightSavingsField;
    /**
     * The descriptionField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $descriptionField;
    /**
     * The emailAddressField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $emailAddressField;
    /**
     * The phoneField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $phoneField;
    /**
     * The stateField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $stateField;
    /**
     * The timeZoneField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $timeZoneField;
    /**
     * The zipField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $zipField;
    /**
     * Constructor method for BranchType
     * @uses BranchType::setAddressField()
     * @uses BranchType::setAutoLogoffField()
     * @uses BranchType::setBranchIDField()
     * @uses BranchType::setCityField()
     * @uses BranchType::setCoordinatesField()
     * @uses BranchType::setDaylightSavingsField()
     * @uses BranchType::setDescriptionField()
     * @uses BranchType::setEmailAddressField()
     * @uses BranchType::setPhoneField()
     * @uses BranchType::setStateField()
     * @uses BranchType::setTimeZoneField()
     * @uses BranchType::setZipField()
     * @param string $addressField
     * @param bool $autoLogoffField
     * @param string $branchIDField
     * @param string $cityField
     * @param \StructType\Coordinates $coordinatesField
     * @param bool $daylightSavingsField
     * @param string $descriptionField
     * @param string $emailAddressField
     * @param string $phoneField
     * @param string $stateField
     * @param string $timeZoneField
     * @param string $zipField
     */
    public function __construct($addressField = null, $autoLogoffField = null, $branchIDField = null, $cityField = null, \StructType\Coordinates $coordinatesField = null, $daylightSavingsField = null, $descriptionField = null, $emailAddressField = null, $phoneField = null, $stateField = null, $timeZoneField = null, $zipField = null)
    {
        $this
            ->setAddressField($addressField)
            ->setAutoLogoffField($autoLogoffField)
            ->setBranchIDField($branchIDField)
            ->setCityField($cityField)
            ->setCoordinatesField($coordinatesField)
            ->setDaylightSavingsField($daylightSavingsField)
            ->setDescriptionField($descriptionField)
            ->setEmailAddressField($emailAddressField)
            ->setPhoneField($phoneField)
            ->setStateField($stateField)
            ->setTimeZoneField($timeZoneField)
            ->setZipField($zipField);
    }
    /**
     * Get addressField value
     * @return string|null
     */
    public function getAddressField()
    {
        return $this->addressField;
    }
    /**
     * Set addressField value
     * @param string $addressField
     * @return \StructType\BranchType
     */
    public function setAddressField($addressField = null)
    {
        // validation for constraint: string
        if (!is_null($addressField) && !is_string($addressField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressField, true), gettype($addressField)), __LINE__);
        }
        $this->addressField = $addressField;
        return $this;
    }
    /**
     * Get autoLogoffField value
     * @return bool|null
     */
    public function getAutoLogoffField()
    {
        return $this->autoLogoffField;
    }
    /**
     * Set autoLogoffField value
     * @param bool $autoLogoffField
     * @return \StructType\BranchType
     */
    public function setAutoLogoffField($autoLogoffField = null)
    {
        // validation for constraint: boolean
        if (!is_null($autoLogoffField) && !is_bool($autoLogoffField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($autoLogoffField, true), gettype($autoLogoffField)), __LINE__);
        }
        $this->autoLogoffField = $autoLogoffField;
        return $this;
    }
    /**
     * Get branchIDField value
     * @return string|null
     */
    public function getBranchIDField()
    {
        return $this->branchIDField;
    }
    /**
     * Set branchIDField value
     * @param string $branchIDField
     * @return \StructType\BranchType
     */
    public function setBranchIDField($branchIDField = null)
    {
        // validation for constraint: string
        if (!is_null($branchIDField) && !is_string($branchIDField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($branchIDField, true), gettype($branchIDField)), __LINE__);
        }
        $this->branchIDField = $branchIDField;
        return $this;
    }
    /**
     * Get cityField value
     * @return string|null
     */
    public function getCityField()
    {
        return $this->cityField;
    }
    /**
     * Set cityField value
     * @param string $cityField
     * @return \StructType\BranchType
     */
    public function setCityField($cityField = null)
    {
        // validation for constraint: string
        if (!is_null($cityField) && !is_string($cityField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cityField, true), gettype($cityField)), __LINE__);
        }
        $this->cityField = $cityField;
        return $this;
    }
    /**
     * Get coordinatesField value
     * @return \StructType\Coordinates|null
     */
    public function getCoordinatesField()
    {
        return $this->coordinatesField;
    }
    /**
     * Set coordinatesField value
     * @param \StructType\Coordinates $coordinatesField
     * @return \StructType\BranchType
     */
    public function setCoordinatesField(\StructType\Coordinates $coordinatesField = null)
    {
        $this->coordinatesField = $coordinatesField;
        return $this;
    }
    /**
     * Get daylightSavingsField value
     * @return bool|null
     */
    public function getDaylightSavingsField()
    {
        return $this->daylightSavingsField;
    }
    /**
     * Set daylightSavingsField value
     * @param bool $daylightSavingsField
     * @return \StructType\BranchType
     */
    public function setDaylightSavingsField($daylightSavingsField = null)
    {
        // validation for constraint: boolean
        if (!is_null($daylightSavingsField) && !is_bool($daylightSavingsField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($daylightSavingsField, true), gettype($daylightSavingsField)), __LINE__);
        }
        $this->daylightSavingsField = $daylightSavingsField;
        return $this;
    }
    /**
     * Get descriptionField value
     * @return string|null
     */
    public function getDescriptionField()
    {
        return $this->descriptionField;
    }
    /**
     * Set descriptionField value
     * @param string $descriptionField
     * @return \StructType\BranchType
     */
    public function setDescriptionField($descriptionField = null)
    {
        // validation for constraint: string
        if (!is_null($descriptionField) && !is_string($descriptionField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descriptionField, true), gettype($descriptionField)), __LINE__);
        }
        $this->descriptionField = $descriptionField;
        return $this;
    }
    /**
     * Get emailAddressField value
     * @return string|null
     */
    public function getEmailAddressField()
    {
        return $this->emailAddressField;
    }
    /**
     * Set emailAddressField value
     * @param string $emailAddressField
     * @return \StructType\BranchType
     */
    public function setEmailAddressField($emailAddressField = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddressField) && !is_string($emailAddressField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailAddressField, true), gettype($emailAddressField)), __LINE__);
        }
        $this->emailAddressField = $emailAddressField;
        return $this;
    }
    /**
     * Get phoneField value
     * @return string|null
     */
    public function getPhoneField()
    {
        return $this->phoneField;
    }
    /**
     * Set phoneField value
     * @param string $phoneField
     * @return \StructType\BranchType
     */
    public function setPhoneField($phoneField = null)
    {
        // validation for constraint: string
        if (!is_null($phoneField) && !is_string($phoneField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneField, true), gettype($phoneField)), __LINE__);
        }
        $this->phoneField = $phoneField;
        return $this;
    }
    /**
     * Get stateField value
     * @return string|null
     */
    public function getStateField()
    {
        return $this->stateField;
    }
    /**
     * Set stateField value
     * @param string $stateField
     * @return \StructType\BranchType
     */
    public function setStateField($stateField = null)
    {
        // validation for constraint: string
        if (!is_null($stateField) && !is_string($stateField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stateField, true), gettype($stateField)), __LINE__);
        }
        $this->stateField = $stateField;
        return $this;
    }
    /**
     * Get timeZoneField value
     * @return string|null
     */
    public function getTimeZoneField()
    {
        return $this->timeZoneField;
    }
    /**
     * Set timeZoneField value
     * @param string $timeZoneField
     * @return \StructType\BranchType
     */
    public function setTimeZoneField($timeZoneField = null)
    {
        // validation for constraint: string
        if (!is_null($timeZoneField) && !is_string($timeZoneField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeZoneField, true), gettype($timeZoneField)), __LINE__);
        }
        $this->timeZoneField = $timeZoneField;
        return $this;
    }
    /**
     * Get zipField value
     * @return string|null
     */
    public function getZipField()
    {
        return $this->zipField;
    }
    /**
     * Set zipField value
     * @param string $zipField
     * @return \StructType\BranchType
     */
    public function setZipField($zipField = null)
    {
        // validation for constraint: string
        if (!is_null($zipField) && !is_string($zipField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipField, true), gettype($zipField)), __LINE__);
        }
        $this->zipField = $zipField;
        return $this;
    }
}
