<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BranchListBranch StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BranchListBranch
 * @subpackage Structs
 */
class BranchListBranch extends AbstractStructBase
{
    /**
     * The branchIDField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $branchIDField;
    /**
     * The branchKeyIDField
     * @var int
     */
    public $branchKeyIDField;
    /**
     * The descriptionField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $descriptionField;
    /**
     * The timeZoneField
     * @var string
     */
    public $timeZoneField;
    /**
     * Constructor method for BranchListBranch
     * @uses BranchListBranch::setBranchIDField()
     * @uses BranchListBranch::setBranchKeyIDField()
     * @uses BranchListBranch::setDescriptionField()
     * @uses BranchListBranch::setTimeZoneField()
     * @param string $branchIDField
     * @param int $branchKeyIDField
     * @param string $descriptionField
     * @param string $timeZoneField
     */
    public function __construct($branchIDField = null, $branchKeyIDField = null, $descriptionField = null, $timeZoneField = null)
    {
        $this
            ->setBranchIDField($branchIDField)
            ->setBranchKeyIDField($branchKeyIDField)
            ->setDescriptionField($descriptionField)
            ->setTimeZoneField($timeZoneField);
    }
    /**
     * Get branchIDField value
     * @return string|null
     */
    public function getBranchIDField()
    {
        return $this->branchIDField;
    }
    /**
     * Set branchIDField value
     * @param string $branchIDField
     * @return \StructType\BranchListBranch
     */
    public function setBranchIDField($branchIDField = null)
    {
        // validation for constraint: string
        if (!is_null($branchIDField) && !is_string($branchIDField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($branchIDField, true), gettype($branchIDField)), __LINE__);
        }
        $this->branchIDField = $branchIDField;
        return $this;
    }
    /**
     * Get branchKeyIDField value
     * @return int|null
     */
    public function getBranchKeyIDField()
    {
        return $this->branchKeyIDField;
    }
    /**
     * Set branchKeyIDField value
     * @param int $branchKeyIDField
     * @return \StructType\BranchListBranch
     */
    public function setBranchKeyIDField($branchKeyIDField = null)
    {
        // validation for constraint: int
        if (!is_null($branchKeyIDField) && !(is_int($branchKeyIDField) || ctype_digit($branchKeyIDField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($branchKeyIDField, true), gettype($branchKeyIDField)), __LINE__);
        }
        $this->branchKeyIDField = $branchKeyIDField;
        return $this;
    }
    /**
     * Get descriptionField value
     * @return string|null
     */
    public function getDescriptionField()
    {
        return $this->descriptionField;
    }
    /**
     * Set descriptionField value
     * @param string $descriptionField
     * @return \StructType\BranchListBranch
     */
    public function setDescriptionField($descriptionField = null)
    {
        // validation for constraint: string
        if (!is_null($descriptionField) && !is_string($descriptionField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descriptionField, true), gettype($descriptionField)), __LINE__);
        }
        $this->descriptionField = $descriptionField;
        return $this;
    }
    /**
     * Get timeZoneField value
     * @return string|null
     */
    public function getTimeZoneField()
    {
        return $this->timeZoneField;
    }
    /**
     * Set timeZoneField value
     * @uses \EnumType\TimeZoneType::valueIsValid()
     * @uses \EnumType\TimeZoneType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timeZoneField
     * @return \StructType\BranchListBranch
     */
    public function setTimeZoneField($timeZoneField = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TimeZoneType::valueIsValid($timeZoneField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TimeZoneType', is_array($timeZoneField) ? implode(', ', $timeZoneField) : var_export($timeZoneField, true), implode(', ', \EnumType\TimeZoneType::getValidValues())), __LINE__);
        }
        $this->timeZoneField = $timeZoneField;
        return $this;
    }
}
