<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AllRouteDetailRequestEnvelope StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AllRouteDetailRequestEnvelope
 * @subpackage Structs
 */
class AllRouteDetailRequestEnvelope extends AbstractStructBase
{
    /**
     * The fromDateField
     * @var string
     */
    public $fromDateField;
    /**
     * The routeDetailReturnOptionsField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\RouteDetailReturnOptions
     */
    public $routeDetailReturnOptionsField;
    /**
     * The routeDetailSearchByOptionsField
     * @var string
     */
    public $routeDetailSearchByOptionsField;
    /**
     * The toDateField
     * @var string
     */
    public $toDateField;
    /**
     * Constructor method for AllRouteDetailRequestEnvelope
     * @uses AllRouteDetailRequestEnvelope::setFromDateField()
     * @uses AllRouteDetailRequestEnvelope::setRouteDetailReturnOptionsField()
     * @uses AllRouteDetailRequestEnvelope::setRouteDetailSearchByOptionsField()
     * @uses AllRouteDetailRequestEnvelope::setToDateField()
     * @param string $fromDateField
     * @param \StructType\RouteDetailReturnOptions $routeDetailReturnOptionsField
     * @param string $routeDetailSearchByOptionsField
     * @param string $toDateField
     */
    public function __construct($fromDateField = null, \StructType\RouteDetailReturnOptions $routeDetailReturnOptionsField = null, $routeDetailSearchByOptionsField = null, $toDateField = null)
    {
        $this
            ->setFromDateField($fromDateField)
            ->setRouteDetailReturnOptionsField($routeDetailReturnOptionsField)
            ->setRouteDetailSearchByOptionsField($routeDetailSearchByOptionsField)
            ->setToDateField($toDateField);
    }
    /**
     * Get fromDateField value
     * @return string|null
     */
    public function getFromDateField()
    {
        return $this->fromDateField;
    }
    /**
     * Set fromDateField value
     * @param string $fromDateField
     * @return \StructType\AllRouteDetailRequestEnvelope
     */
    public function setFromDateField($fromDateField = null)
    {
        // validation for constraint: string
        if (!is_null($fromDateField) && !is_string($fromDateField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromDateField, true), gettype($fromDateField)), __LINE__);
        }
        $this->fromDateField = $fromDateField;
        return $this;
    }
    /**
     * Get routeDetailReturnOptionsField value
     * @return \StructType\RouteDetailReturnOptions|null
     */
    public function getRouteDetailReturnOptionsField()
    {
        return $this->routeDetailReturnOptionsField;
    }
    /**
     * Set routeDetailReturnOptionsField value
     * @param \StructType\RouteDetailReturnOptions $routeDetailReturnOptionsField
     * @return \StructType\AllRouteDetailRequestEnvelope
     */
    public function setRouteDetailReturnOptionsField(\StructType\RouteDetailReturnOptions $routeDetailReturnOptionsField = null)
    {
        $this->routeDetailReturnOptionsField = $routeDetailReturnOptionsField;
        return $this;
    }
    /**
     * Get routeDetailSearchByOptionsField value
     * @return string|null
     */
    public function getRouteDetailSearchByOptionsField()
    {
        return $this->routeDetailSearchByOptionsField;
    }
    /**
     * Set routeDetailSearchByOptionsField value
     * @uses \EnumType\RouteDetailSearchByOptions::valueIsValid()
     * @uses \EnumType\RouteDetailSearchByOptions::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $routeDetailSearchByOptionsField
     * @return \StructType\AllRouteDetailRequestEnvelope
     */
    public function setRouteDetailSearchByOptionsField($routeDetailSearchByOptionsField = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RouteDetailSearchByOptions::valueIsValid($routeDetailSearchByOptionsField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RouteDetailSearchByOptions', is_array($routeDetailSearchByOptionsField) ? implode(', ', $routeDetailSearchByOptionsField) : var_export($routeDetailSearchByOptionsField, true), implode(', ', \EnumType\RouteDetailSearchByOptions::getValidValues())), __LINE__);
        }
        $this->routeDetailSearchByOptionsField = $routeDetailSearchByOptionsField;
        return $this;
    }
    /**
     * Get toDateField value
     * @return string|null
     */
    public function getToDateField()
    {
        return $this->toDateField;
    }
    /**
     * Set toDateField value
     * @param string $toDateField
     * @return \StructType\AllRouteDetailRequestEnvelope
     */
    public function setToDateField($toDateField = null)
    {
        // validation for constraint: string
        if (!is_null($toDateField) && !is_string($toDateField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toDateField, true), gettype($toDateField)), __LINE__);
        }
        $this->toDateField = $toDateField;
        return $this;
    }
}
