<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Suggest ServiceType
 * @subpackage Services
 */
class Suggest extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SuggestRoutes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SuggestRoutes $parameters
     * @return \StructType\SuggestRoutesResponse|bool
     */
    public function SuggestRoutes(\StructType\SuggestRoutes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SuggestRoutes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SuggestRoutesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
