<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Export ServiceType
 * @subpackage Services
 */
class Export extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ExportAccounts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExportAccounts $parameters
     * @return \StructType\ExportAccountsResponse|bool
     */
    public function ExportAccounts(\StructType\ExportAccounts $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ExportAccounts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ExportAccountsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
