<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfViolation ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfViolation
 * @subpackage Arrays
 */
class ArrayOfViolation extends AbstractStructArrayBase
{
    /**
     * The Violation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Violation;
    /**
     * Constructor method for ArrayOfViolation
     * @uses ArrayOfViolation::setViolation()
     * @param string[] $violation
     */
    public function __construct(array $violation = array())
    {
        $this
            ->setViolation($violation);
    }
    /**
     * Get Violation value
     * @return string[]|null
     */
    public function getViolation()
    {
        return $this->Violation;
    }
    /**
     * This method is responsible for validating the values passed to the setViolation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setViolation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateViolationForArrayConstraintsFromSetViolation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfViolationViolationItem) {
            // validation for constraint: enumeration
            if (!\EnumType\Violation::valueIsValid($arrayOfViolationViolationItem)) {
                $invalidValues[] = is_object($arrayOfViolationViolationItem) ? get_class($arrayOfViolationViolationItem) : sprintf('%s(%s)', gettype($arrayOfViolationViolationItem), var_export($arrayOfViolationViolationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Violation', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\Violation::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Violation value
     * @uses \EnumType\Violation::valueIsValid()
     * @uses \EnumType\Violation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $violation
     * @return \ArrayType\ArrayOfViolation
     */
    public function setViolation(array $violation = array())
    {
        // validation for constraint: array
        if ('' !== ($violationArrayErrorMessage = self::validateViolationForArrayConstraintsFromSetViolation($violation))) {
            throw new \InvalidArgumentException($violationArrayErrorMessage, __LINE__);
        }
        $this->Violation = $violation;
        return $this;
    }
    /**
     * Add item to Violation value
     * @uses \EnumType\Violation::valueIsValid()
     * @uses \EnumType\Violation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ArrayType\ArrayOfViolation
     */
    public function addToViolation($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Violation::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Violation', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \EnumType\Violation::getValidValues())), __LINE__);
        }
        $this->Violation[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Add element to array
     * @see AbstractStructArrayBase::add()
     * @throws \InvalidArgumentException
     * @uses \EnumType\Violation::valueIsValid()
     * @param string $item
     * @return \ArrayType\ArrayOfViolation
     */
    public function add($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Violation::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Violation', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \EnumType\Violation::getValidValues())), __LINE__);
        }
        return parent::add($item);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Violation
     */
    public function getAttributeName()
    {
        return 'Violation';
    }
}
