<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfLineItemType ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfLineItemType
 * @subpackage Arrays
 */
class ArrayOfLineItemType extends AbstractStructArrayBase
{
    /**
     * The LineItemType
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\LineItemType[]
     */
    public $LineItemType;
    /**
     * Constructor method for ArrayOfLineItemType
     * @uses ArrayOfLineItemType::setLineItemType()
     * @param \StructType\LineItemType[] $lineItemType
     */
    public function __construct(array $lineItemType = array())
    {
        $this
            ->setLineItemType($lineItemType);
    }
    /**
     * Get LineItemType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\LineItemType[]|null
     */
    public function getLineItemType()
    {
        return isset($this->LineItemType) ? $this->LineItemType : null;
    }
    /**
     * This method is responsible for validating the values passed to the setLineItemType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLineItemType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLineItemTypeForArrayConstraintsFromSetLineItemType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfLineItemTypeLineItemTypeItem) {
            // validation for constraint: itemType
            if (!$arrayOfLineItemTypeLineItemTypeItem instanceof \StructType\LineItemType) {
                $invalidValues[] = is_object($arrayOfLineItemTypeLineItemTypeItem) ? get_class($arrayOfLineItemTypeLineItemTypeItem) : sprintf('%s(%s)', gettype($arrayOfLineItemTypeLineItemTypeItem), var_export($arrayOfLineItemTypeLineItemTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LineItemType property can only contain items of type \StructType\LineItemType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LineItemType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\LineItemType[] $lineItemType
     * @return \ArrayType\ArrayOfLineItemType
     */
    public function setLineItemType(array $lineItemType = array())
    {
        // validation for constraint: array
        if ('' !== ($lineItemTypeArrayErrorMessage = self::validateLineItemTypeForArrayConstraintsFromSetLineItemType($lineItemType))) {
            throw new \InvalidArgumentException($lineItemTypeArrayErrorMessage, __LINE__);
        }
        if (is_null($lineItemType) || (is_array($lineItemType) && empty($lineItemType))) {
            unset($this->LineItemType);
        } else {
            $this->LineItemType = $lineItemType;
        }
        return $this;
    }
    /**
     * Add item to LineItemType value
     * @throws \InvalidArgumentException
     * @param \StructType\LineItemType $item
     * @return \ArrayType\ArrayOfLineItemType
     */
    public function addToLineItemType(\StructType\LineItemType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LineItemType) {
            throw new \InvalidArgumentException(sprintf('The LineItemType property can only contain items of type \StructType\LineItemType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LineItemType[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\LineItemType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\LineItemType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\LineItemType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\LineItemType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\LineItemType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string LineItemType
     */
    public function getAttributeName()
    {
        return 'LineItemType';
    }
}
