<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfLeg ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfLeg
 * @subpackage Arrays
 */
class ArrayOfLeg extends AbstractStructArrayBase
{
    /**
     * The Leg
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Leg[]
     */
    public $Leg;
    /**
     * Constructor method for ArrayOfLeg
     * @uses ArrayOfLeg::setLeg()
     * @param \StructType\Leg[] $leg
     */
    public function __construct(array $leg = array())
    {
        $this
            ->setLeg($leg);
    }
    /**
     * Get Leg value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Leg[]|null
     */
    public function getLeg()
    {
        return isset($this->Leg) ? $this->Leg : null;
    }
    /**
     * This method is responsible for validating the values passed to the setLeg method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLeg method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLegForArrayConstraintsFromSetLeg(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfLegLegItem) {
            // validation for constraint: itemType
            if (!$arrayOfLegLegItem instanceof \StructType\Leg) {
                $invalidValues[] = is_object($arrayOfLegLegItem) ? get_class($arrayOfLegLegItem) : sprintf('%s(%s)', gettype($arrayOfLegLegItem), var_export($arrayOfLegLegItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Leg property can only contain items of type \StructType\Leg, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Leg value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Leg[] $leg
     * @return \ArrayType\ArrayOfLeg
     */
    public function setLeg(array $leg = array())
    {
        // validation for constraint: array
        if ('' !== ($legArrayErrorMessage = self::validateLegForArrayConstraintsFromSetLeg($leg))) {
            throw new \InvalidArgumentException($legArrayErrorMessage, __LINE__);
        }
        if (is_null($leg) || (is_array($leg) && empty($leg))) {
            unset($this->Leg);
        } else {
            $this->Leg = $leg;
        }
        return $this;
    }
    /**
     * Add item to Leg value
     * @throws \InvalidArgumentException
     * @param \StructType\Leg $item
     * @return \ArrayType\ArrayOfLeg
     */
    public function addToLeg(\StructType\Leg $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Leg) {
            throw new \InvalidArgumentException(sprintf('The Leg property can only contain items of type \StructType\Leg, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Leg[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Leg|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Leg|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Leg|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Leg|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Leg|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Leg
     */
    public function getAttributeName()
    {
        return 'Leg';
    }
}
