<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TRAVELPOINT StructType
 * @subpackage Structs
 */
class TRAVELPOINT extends AbstractStructBase
{
    /**
     * The TRAVELPOINT_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $TRAVELPOINT_OBJID;
    /**
     * The TRAVELPOINT_CENTRALID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $TRAVELPOINT_CENTRALID;
    /**
     * The lastnamefirstname
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $lastnamefirstname;
    /**
     * The name1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $name1;
    /**
     * The name2
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $name2;
    /**
     * The country
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $country;
    /**
     * The subcountry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $subcountry;
    /**
     * The postcode
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $postcode;
    /**
     * The city
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $city;
    /**
     * The street
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $street;
    /**
     * The phone
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $phone;
    /**
     * The email1
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $email1;
    /**
     * The mobile1
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $mobile1;
    /**
     * The hqmatchadm
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $hqmatchadm;
    /**
     * The hqmatchisn
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $hqmatchisn;
    /**
     * The hqmatchsm
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $hqmatchsm;
    /**
     * The matchcode
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $matchcode;
    /**
     * The iata
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $iata;
    /**
     * The guestType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $guestType;
    /**
     * Constructor method for TRAVELPOINT
     * @uses TRAVELPOINT::setTRAVELPOINT_OBJID()
     * @uses TRAVELPOINT::setTRAVELPOINT_CENTRALID()
     * @uses TRAVELPOINT::setLastnamefirstname()
     * @uses TRAVELPOINT::setName1()
     * @uses TRAVELPOINT::setName2()
     * @uses TRAVELPOINT::setCountry()
     * @uses TRAVELPOINT::setSubcountry()
     * @uses TRAVELPOINT::setPostcode()
     * @uses TRAVELPOINT::setCity()
     * @uses TRAVELPOINT::setStreet()
     * @uses TRAVELPOINT::setPhone()
     * @uses TRAVELPOINT::setEmail1()
     * @uses TRAVELPOINT::setMobile1()
     * @uses TRAVELPOINT::setHqmatchadm()
     * @uses TRAVELPOINT::setHqmatchisn()
     * @uses TRAVELPOINT::setHqmatchsm()
     * @uses TRAVELPOINT::setMatchcode()
     * @uses TRAVELPOINT::setIata()
     * @uses TRAVELPOINT::setGuestType()
     * @param string $tRAVELPOINT_OBJID
     * @param string $tRAVELPOINT_CENTRALID
     * @param string $lastnamefirstname
     * @param string $name1
     * @param string $name2
     * @param string $country
     * @param string $subcountry
     * @param string $postcode
     * @param string $city
     * @param string $street
     * @param string $phone
     * @param string $email1
     * @param string $mobile1
     * @param string $hqmatchadm
     * @param string $hqmatchisn
     * @param string $hqmatchsm
     * @param string $matchcode
     * @param string $iata
     * @param string $guestType
     */
    public function __construct($tRAVELPOINT_OBJID = null, $tRAVELPOINT_CENTRALID = null, $lastnamefirstname = null, $name1 = null, $name2 = null, $country = null, $subcountry = null, $postcode = null, $city = null, $street = null, $phone = null, $email1 = null, $mobile1 = null, $hqmatchadm = null, $hqmatchisn = null, $hqmatchsm = null, $matchcode = null, $iata = null, $guestType = null)
    {
        $this
            ->setTRAVELPOINT_OBJID($tRAVELPOINT_OBJID)
            ->setTRAVELPOINT_CENTRALID($tRAVELPOINT_CENTRALID)
            ->setLastnamefirstname($lastnamefirstname)
            ->setName1($name1)
            ->setName2($name2)
            ->setCountry($country)
            ->setSubcountry($subcountry)
            ->setPostcode($postcode)
            ->setCity($city)
            ->setStreet($street)
            ->setPhone($phone)
            ->setEmail1($email1)
            ->setMobile1($mobile1)
            ->setHqmatchadm($hqmatchadm)
            ->setHqmatchisn($hqmatchisn)
            ->setHqmatchsm($hqmatchsm)
            ->setMatchcode($matchcode)
            ->setIata($iata)
            ->setGuestType($guestType);
    }
    /**
     * Get TRAVELPOINT_OBJID value
     * @return string
     */
    public function getTRAVELPOINT_OBJID()
    {
        return $this->{'TRAVELPOINT-OBJID'};
    }
    /**
     * Set TRAVELPOINT_OBJID value
     * @param string $tRAVELPOINT_OBJID
     * @return \StructType\TRAVELPOINT
     */
    public function setTRAVELPOINT_OBJID($tRAVELPOINT_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($tRAVELPOINT_OBJID) && !is_string($tRAVELPOINT_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tRAVELPOINT_OBJID, true), gettype($tRAVELPOINT_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($tRAVELPOINT_OBJID) && !preg_match('/([0-9])*/', $tRAVELPOINT_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($tRAVELPOINT_OBJID, true)), __LINE__);
        }
        $this->TRAVELPOINT_OBJID = $this->{'TRAVELPOINT-OBJID'} = $tRAVELPOINT_OBJID;
        return $this;
    }
    /**
     * Get TRAVELPOINT_CENTRALID value
     * @return string
     */
    public function getTRAVELPOINT_CENTRALID()
    {
        return $this->{'TRAVELPOINT-CENTRALID'};
    }
    /**
     * Set TRAVELPOINT_CENTRALID value
     * @param string $tRAVELPOINT_CENTRALID
     * @return \StructType\TRAVELPOINT
     */
    public function setTRAVELPOINT_CENTRALID($tRAVELPOINT_CENTRALID = null)
    {
        // validation for constraint: string
        if (!is_null($tRAVELPOINT_CENTRALID) && !is_string($tRAVELPOINT_CENTRALID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tRAVELPOINT_CENTRALID, true), gettype($tRAVELPOINT_CENTRALID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($tRAVELPOINT_CENTRALID) && !preg_match('/([0-9])*/', $tRAVELPOINT_CENTRALID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($tRAVELPOINT_CENTRALID, true)), __LINE__);
        }
        $this->TRAVELPOINT_CENTRALID = $this->{'TRAVELPOINT-CENTRALID'} = $tRAVELPOINT_CENTRALID;
        return $this;
    }
    /**
     * Get lastnamefirstname value
     * @return string
     */
    public function getLastnamefirstname()
    {
        return $this->lastnamefirstname;
    }
    /**
     * Set lastnamefirstname value
     * @param string $lastnamefirstname
     * @return \StructType\TRAVELPOINT
     */
    public function setLastnamefirstname($lastnamefirstname = null)
    {
        // validation for constraint: string
        if (!is_null($lastnamefirstname) && !is_string($lastnamefirstname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastnamefirstname, true), gettype($lastnamefirstname)), __LINE__);
        }
        $this->lastnamefirstname = $lastnamefirstname;
        return $this;
    }
    /**
     * Get name1 value
     * @return string
     */
    public function getName1()
    {
        return $this->name1;
    }
    /**
     * Set name1 value
     * @param string $name1
     * @return \StructType\TRAVELPOINT
     */
    public function setName1($name1 = null)
    {
        // validation for constraint: string
        if (!is_null($name1) && !is_string($name1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name1, true), gettype($name1)), __LINE__);
        }
        $this->name1 = $name1;
        return $this;
    }
    /**
     * Get name2 value
     * @return string
     */
    public function getName2()
    {
        return $this->name2;
    }
    /**
     * Set name2 value
     * @param string $name2
     * @return \StructType\TRAVELPOINT
     */
    public function setName2($name2 = null)
    {
        // validation for constraint: string
        if (!is_null($name2) && !is_string($name2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name2, true), gettype($name2)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($name2) && mb_strlen($name2) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($name2)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($name2) && mb_strlen($name2) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($name2)), __LINE__);
        }
        $this->name2 = $name2;
        return $this;
    }
    /**
     * Get country value
     * @return string
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \StructType\TRAVELPOINT
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get subcountry value
     * @return string
     */
    public function getSubcountry()
    {
        return $this->subcountry;
    }
    /**
     * Set subcountry value
     * @param string $subcountry
     * @return \StructType\TRAVELPOINT
     */
    public function setSubcountry($subcountry = null)
    {
        // validation for constraint: string
        if (!is_null($subcountry) && !is_string($subcountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subcountry, true), gettype($subcountry)), __LINE__);
        }
        $this->subcountry = $subcountry;
        return $this;
    }
    /**
     * Get postcode value
     * @return string
     */
    public function getPostcode()
    {
        return $this->postcode;
    }
    /**
     * Set postcode value
     * @param string $postcode
     * @return \StructType\TRAVELPOINT
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postcode, true), gettype($postcode)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($postcode) && mb_strlen($postcode) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($postcode)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($postcode) && mb_strlen($postcode) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($postcode)), __LINE__);
        }
        $this->postcode = $postcode;
        return $this;
    }
    /**
     * Get city value
     * @return string
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \StructType\TRAVELPOINT
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($city) && mb_strlen($city) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($city)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($city) && mb_strlen($city) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get street value
     * @return string
     */
    public function getStreet()
    {
        return $this->street;
    }
    /**
     * Set street value
     * @param string $street
     * @return \StructType\TRAVELPOINT
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street, true), gettype($street)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($street) && mb_strlen($street) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($street)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($street) && mb_strlen($street) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($street)), __LINE__);
        }
        $this->street = $street;
        return $this;
    }
    /**
     * Get phone value
     * @return string
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param string $phone
     * @return \StructType\TRAVELPOINT
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($phone) && mb_strlen($phone) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($phone)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($phone) && mb_strlen($phone) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($phone)), __LINE__);
        }
        $this->phone = $phone;
        return $this;
    }
    /**
     * Get email1 value
     * @return string
     */
    public function getEmail1()
    {
        return $this->email1;
    }
    /**
     * Set email1 value
     * @param string $email1
     * @return \StructType\TRAVELPOINT
     */
    public function setEmail1($email1 = null)
    {
        // validation for constraint: string
        if (!is_null($email1) && !is_string($email1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email1, true), gettype($email1)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($email1) && mb_strlen($email1) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($email1)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($email1) && mb_strlen($email1) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($email1)), __LINE__);
        }
        $this->email1 = $email1;
        return $this;
    }
    /**
     * Get mobile1 value
     * @return string
     */
    public function getMobile1()
    {
        return $this->mobile1;
    }
    /**
     * Set mobile1 value
     * @param string $mobile1
     * @return \StructType\TRAVELPOINT
     */
    public function setMobile1($mobile1 = null)
    {
        // validation for constraint: string
        if (!is_null($mobile1) && !is_string($mobile1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobile1, true), gettype($mobile1)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($mobile1) && mb_strlen($mobile1) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($mobile1)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($mobile1) && mb_strlen($mobile1) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($mobile1)), __LINE__);
        }
        $this->mobile1 = $mobile1;
        return $this;
    }
    /**
     * Get hqmatchadm value
     * @return string
     */
    public function getHqmatchadm()
    {
        return $this->hqmatchadm;
    }
    /**
     * Set hqmatchadm value
     * @param string $hqmatchadm
     * @return \StructType\TRAVELPOINT
     */
    public function setHqmatchadm($hqmatchadm = null)
    {
        // validation for constraint: string
        if (!is_null($hqmatchadm) && !is_string($hqmatchadm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hqmatchadm, true), gettype($hqmatchadm)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($hqmatchadm) && mb_strlen($hqmatchadm) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($hqmatchadm)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($hqmatchadm) && mb_strlen($hqmatchadm) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($hqmatchadm)), __LINE__);
        }
        $this->hqmatchadm = $hqmatchadm;
        return $this;
    }
    /**
     * Get hqmatchisn value
     * @return string
     */
    public function getHqmatchisn()
    {
        return $this->hqmatchisn;
    }
    /**
     * Set hqmatchisn value
     * @param string $hqmatchisn
     * @return \StructType\TRAVELPOINT
     */
    public function setHqmatchisn($hqmatchisn = null)
    {
        // validation for constraint: string
        if (!is_null($hqmatchisn) && !is_string($hqmatchisn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hqmatchisn, true), gettype($hqmatchisn)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($hqmatchisn) && mb_strlen($hqmatchisn) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($hqmatchisn)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($hqmatchisn) && mb_strlen($hqmatchisn) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($hqmatchisn)), __LINE__);
        }
        $this->hqmatchisn = $hqmatchisn;
        return $this;
    }
    /**
     * Get hqmatchsm value
     * @return string
     */
    public function getHqmatchsm()
    {
        return $this->hqmatchsm;
    }
    /**
     * Set hqmatchsm value
     * @param string $hqmatchsm
     * @return \StructType\TRAVELPOINT
     */
    public function setHqmatchsm($hqmatchsm = null)
    {
        // validation for constraint: string
        if (!is_null($hqmatchsm) && !is_string($hqmatchsm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hqmatchsm, true), gettype($hqmatchsm)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($hqmatchsm) && mb_strlen($hqmatchsm) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($hqmatchsm)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($hqmatchsm) && mb_strlen($hqmatchsm) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($hqmatchsm)), __LINE__);
        }
        $this->hqmatchsm = $hqmatchsm;
        return $this;
    }
    /**
     * Get matchcode value
     * @return string
     */
    public function getMatchcode()
    {
        return $this->matchcode;
    }
    /**
     * Set matchcode value
     * @param string $matchcode
     * @return \StructType\TRAVELPOINT
     */
    public function setMatchcode($matchcode = null)
    {
        // validation for constraint: string
        if (!is_null($matchcode) && !is_string($matchcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($matchcode, true), gettype($matchcode)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($matchcode) && mb_strlen($matchcode) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($matchcode)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($matchcode) && mb_strlen($matchcode) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($matchcode)), __LINE__);
        }
        $this->matchcode = $matchcode;
        return $this;
    }
    /**
     * Get iata value
     * @return string
     */
    public function getIata()
    {
        return $this->iata;
    }
    /**
     * Set iata value
     * @param string $iata
     * @return \StructType\TRAVELPOINT
     */
    public function setIata($iata = null)
    {
        // validation for constraint: string
        if (!is_null($iata) && !is_string($iata)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iata, true), gettype($iata)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($iata) && mb_strlen($iata) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($iata)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($iata) && mb_strlen($iata) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($iata)), __LINE__);
        }
        $this->iata = $iata;
        return $this;
    }
    /**
     * Get guestType value
     * @return string
     */
    public function getGuestType()
    {
        return $this->guestType;
    }
    /**
     * Set guestType value
     * @param string $guestType
     * @return \StructType\TRAVELPOINT
     */
    public function setGuestType($guestType = null)
    {
        // validation for constraint: string
        if (!is_null($guestType) && !is_string($guestType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guestType, true), gettype($guestType)), __LINE__);
        }
        $this->guestType = $guestType;
        return $this;
    }
}
