<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TAX StructType
 * @subpackage Structs
 */
class TAX extends AbstractStructBase
{
    /**
     * The tax
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $tax;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $description;
    /**
     * The percent
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $percent;
    /**
     * The taxformel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $taxformel;
    /**
     * The taxpercent
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $taxpercent;
    /**
     * The amounttax
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $amounttax;
    /**
     * The amountnet
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $amountnet;
    /**
     * The amountgross
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $amountgross;
    /**
     * The revenueaccount
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $revenueaccount;
    /**
     * Constructor method for TAX
     * @uses TAX::setTax()
     * @uses TAX::setDescription()
     * @uses TAX::setPercent()
     * @uses TAX::setTaxformel()
     * @uses TAX::setTaxpercent()
     * @uses TAX::setAmounttax()
     * @uses TAX::setAmountnet()
     * @uses TAX::setAmountgross()
     * @uses TAX::setRevenueaccount()
     * @param string $tax
     * @param string $description
     * @param string $percent
     * @param string $taxformel
     * @param string $taxpercent
     * @param string $amounttax
     * @param string $amountnet
     * @param string $amountgross
     * @param string $revenueaccount
     */
    public function __construct($tax = null, $description = null, $percent = null, $taxformel = null, $taxpercent = null, $amounttax = null, $amountnet = null, $amountgross = null, $revenueaccount = null)
    {
        $this
            ->setTax($tax)
            ->setDescription($description)
            ->setPercent($percent)
            ->setTaxformel($taxformel)
            ->setTaxpercent($taxpercent)
            ->setAmounttax($amounttax)
            ->setAmountnet($amountnet)
            ->setAmountgross($amountgross)
            ->setRevenueaccount($revenueaccount);
    }
    /**
     * Get tax value
     * @return string
     */
    public function getTax()
    {
        return $this->tax;
    }
    /**
     * Set tax value
     * @param string $tax
     * @return \StructType\TAX
     */
    public function setTax($tax = null)
    {
        // validation for constraint: string
        if (!is_null($tax) && !is_string($tax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tax, true), gettype($tax)), __LINE__);
        }
        $this->tax = $tax;
        return $this;
    }
    /**
     * Get description value
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\TAX
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get percent value
     * @return string
     */
    public function getPercent()
    {
        return $this->percent;
    }
    /**
     * Set percent value
     * @param string $percent
     * @return \StructType\TAX
     */
    public function setPercent($percent = null)
    {
        // validation for constraint: string
        if (!is_null($percent) && !is_string($percent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($percent, true), gettype($percent)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($percent) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $percent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($percent, true)), __LINE__);
        }
        $this->percent = $percent;
        return $this;
    }
    /**
     * Get taxformel value
     * @return string
     */
    public function getTaxformel()
    {
        return $this->taxformel;
    }
    /**
     * Set taxformel value
     * @param string $taxformel
     * @return \StructType\TAX
     */
    public function setTaxformel($taxformel = null)
    {
        // validation for constraint: string
        if (!is_null($taxformel) && !is_string($taxformel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxformel, true), gettype($taxformel)), __LINE__);
        }
        $this->taxformel = $taxformel;
        return $this;
    }
    /**
     * Get taxpercent value
     * @return string
     */
    public function getTaxpercent()
    {
        return $this->taxpercent;
    }
    /**
     * Set taxpercent value
     * @param string $taxpercent
     * @return \StructType\TAX
     */
    public function setTaxpercent($taxpercent = null)
    {
        // validation for constraint: string
        if (!is_null($taxpercent) && !is_string($taxpercent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxpercent, true), gettype($taxpercent)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($taxpercent) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $taxpercent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($taxpercent, true)), __LINE__);
        }
        $this->taxpercent = $taxpercent;
        return $this;
    }
    /**
     * Get amounttax value
     * @return string
     */
    public function getAmounttax()
    {
        return $this->amounttax;
    }
    /**
     * Set amounttax value
     * @param string $amounttax
     * @return \StructType\TAX
     */
    public function setAmounttax($amounttax = null)
    {
        // validation for constraint: string
        if (!is_null($amounttax) && !is_string($amounttax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amounttax, true), gettype($amounttax)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($amounttax) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $amounttax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($amounttax, true)), __LINE__);
        }
        $this->amounttax = $amounttax;
        return $this;
    }
    /**
     * Get amountnet value
     * @return string
     */
    public function getAmountnet()
    {
        return $this->amountnet;
    }
    /**
     * Set amountnet value
     * @param string $amountnet
     * @return \StructType\TAX
     */
    public function setAmountnet($amountnet = null)
    {
        // validation for constraint: string
        if (!is_null($amountnet) && !is_string($amountnet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amountnet, true), gettype($amountnet)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($amountnet) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $amountnet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($amountnet, true)), __LINE__);
        }
        $this->amountnet = $amountnet;
        return $this;
    }
    /**
     * Get amountgross value
     * @return string
     */
    public function getAmountgross()
    {
        return $this->amountgross;
    }
    /**
     * Set amountgross value
     * @param string $amountgross
     * @return \StructType\TAX
     */
    public function setAmountgross($amountgross = null)
    {
        // validation for constraint: string
        if (!is_null($amountgross) && !is_string($amountgross)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amountgross, true), gettype($amountgross)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($amountgross) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $amountgross)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($amountgross, true)), __LINE__);
        }
        $this->amountgross = $amountgross;
        return $this;
    }
    /**
     * Get revenueaccount value
     * @return string
     */
    public function getRevenueaccount()
    {
        return $this->revenueaccount;
    }
    /**
     * Set revenueaccount value
     * @param string $revenueaccount
     * @return \StructType\TAX
     */
    public function setRevenueaccount($revenueaccount = null)
    {
        // validation for constraint: string
        if (!is_null($revenueaccount) && !is_string($revenueaccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($revenueaccount, true), gettype($revenueaccount)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($revenueaccount) && !preg_match('/([-+]){0,1}([0-9])*/', $revenueaccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($revenueaccount, true)), __LINE__);
        }
        $this->revenueaccount = $revenueaccount;
        return $this;
    }
}
