<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TARGET-GUEST StructType
 * @subpackage Structs
 */
class TARGET_GUEST extends AbstractStructBase
{
    /**
     * The GUEST_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $GUEST_OBJID;
    /**
     * Constructor method for TARGET-GUEST
     * @uses TARGET_GUEST::setGUEST_OBJID()
     * @param string $gUEST_OBJID
     */
    public function __construct($gUEST_OBJID = null)
    {
        $this
            ->setGUEST_OBJID($gUEST_OBJID);
    }
    /**
     * Get GUEST_OBJID value
     * @return string
     */
    public function getGUEST_OBJID()
    {
        return $this->{'GUEST-OBJID'};
    }
    /**
     * Set GUEST_OBJID value
     * @param string $gUEST_OBJID
     * @return \StructType\TARGET_GUEST
     */
    public function setGUEST_OBJID($gUEST_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($gUEST_OBJID) && !is_string($gUEST_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gUEST_OBJID, true), gettype($gUEST_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($gUEST_OBJID) && !preg_match('/([0-9])*/', $gUEST_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($gUEST_OBJID, true)), __LINE__);
        }
        $this->GUEST_OBJID = $this->{'GUEST-OBJID'} = $gUEST_OBJID;
        return $this;
    }
}
