<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubTrail StructType
 * @subpackage Structs
 */
class SubTrail extends AbstractStructBase
{
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $description;
    /**
     * The Node2Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Node2Type;
    /**
     * The SubTrailData
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SubTrailData[]
     */
    public $SubTrailData;
    /**
     * Constructor method for SubTrail
     * @uses SubTrail::setDescription()
     * @uses SubTrail::setNode2Type()
     * @uses SubTrail::setSubTrailData()
     * @param string $description
     * @param string $node2Type
     * @param \StructType\SubTrailData[] $subTrailData
     */
    public function __construct($description = null, $node2Type = null, array $subTrailData = array())
    {
        $this
            ->setDescription($description)
            ->setNode2Type($node2Type)
            ->setSubTrailData($subTrailData);
    }
    /**
     * Get description value
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\SubTrail
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get Node2Type value
     * @return string
     */
    public function getNode2Type()
    {
        return $this->Node2Type;
    }
    /**
     * Set Node2Type value
     * @param string $node2Type
     * @return \StructType\SubTrail
     */
    public function setNode2Type($node2Type = null)
    {
        // validation for constraint: string
        if (!is_null($node2Type) && !is_string($node2Type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($node2Type, true), gettype($node2Type)), __LINE__);
        }
        $this->Node2Type = $node2Type;
        return $this;
    }
    /**
     * Get SubTrailData value
     * @return \StructType\SubTrailData[]|null
     */
    public function getSubTrailData()
    {
        return $this->SubTrailData;
    }
    /**
     * This method is responsible for validating the values passed to the setSubTrailData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubTrailData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubTrailDataForArrayConstraintsFromSetSubTrailData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $subTrailSubTrailDataItem) {
            // validation for constraint: itemType
            if (!$subTrailSubTrailDataItem instanceof \StructType\SubTrailData) {
                $invalidValues[] = is_object($subTrailSubTrailDataItem) ? get_class($subTrailSubTrailDataItem) : sprintf('%s(%s)', gettype($subTrailSubTrailDataItem), var_export($subTrailSubTrailDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SubTrailData property can only contain items of type \StructType\SubTrailData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SubTrailData value
     * @throws \InvalidArgumentException
     * @param \StructType\SubTrailData[] $subTrailData
     * @return \StructType\SubTrail
     */
    public function setSubTrailData(array $subTrailData = array())
    {
        // validation for constraint: array
        if ('' !== ($subTrailDataArrayErrorMessage = self::validateSubTrailDataForArrayConstraintsFromSetSubTrailData($subTrailData))) {
            throw new \InvalidArgumentException($subTrailDataArrayErrorMessage, __LINE__);
        }
        $this->SubTrailData = $subTrailData;
        return $this;
    }
    /**
     * Add item to SubTrailData value
     * @throws \InvalidArgumentException
     * @param \StructType\SubTrailData $item
     * @return \StructType\SubTrail
     */
    public function addToSubTrailData(\StructType\SubTrailData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SubTrailData) {
            throw new \InvalidArgumentException(sprintf('The SubTrailData property can only contain items of type \StructType\SubTrailData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SubTrailData[] = $item;
        return $this;
    }
}
