<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SettlementProfileData StructType
 * @subpackage Structs
 */
class SettlementProfileData extends AbstractStructBase
{
    /**
     * The reference
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $reference;
    /**
     * The comment
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $comment;
    /**
     * Constructor method for SettlementProfileData
     * @uses SettlementProfileData::setReference()
     * @uses SettlementProfileData::setComment()
     * @param string $reference
     * @param string $comment
     */
    public function __construct($reference = null, $comment = null)
    {
        $this
            ->setReference($reference)
            ->setComment($comment);
    }
    /**
     * Get reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->reference;
    }
    /**
     * Set reference value
     * @param string $reference
     * @return \StructType\SettlementProfileData
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference, true), gettype($reference)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($reference) && mb_strlen($reference) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($reference)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($reference) && mb_strlen($reference) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($reference)), __LINE__);
        }
        $this->reference = $reference;
        return $this;
    }
    /**
     * Get comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return \StructType\SettlementProfileData
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($comment) && mb_strlen($comment) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($comment)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($comment) && mb_strlen($comment) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($comment)), __LINE__);
        }
        $this->comment = $comment;
        return $this;
    }
}
