<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceSearchEntry StructType
 * @subpackage Structs
 */
class ServiceSearchEntry extends AbstractStructBase
{
    /**
     * The Service
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Service;
    /**
     * The Mapping
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Mapping[]
     */
    public $Mapping;
    /**
     * Constructor method for ServiceSearchEntry
     * @uses ServiceSearchEntry::setService()
     * @uses ServiceSearchEntry::setMapping()
     * @param string $service
     * @param \StructType\Mapping[] $mapping
     */
    public function __construct($service = null, array $mapping = array())
    {
        $this
            ->setService($service)
            ->setMapping($mapping);
    }
    /**
     * Get Service value
     * @return string
     */
    public function getService()
    {
        return $this->Service;
    }
    /**
     * Set Service value
     * @param string $service
     * @return \StructType\ServiceSearchEntry
     */
    public function setService($service = null)
    {
        // validation for constraint: string
        if (!is_null($service) && !is_string($service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($service, true), gettype($service)), __LINE__);
        }
        $this->Service = $service;
        return $this;
    }
    /**
     * Get Mapping value
     * @return \StructType\Mapping[]|null
     */
    public function getMapping()
    {
        return $this->Mapping;
    }
    /**
     * This method is responsible for validating the values passed to the setMapping method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMapping method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMappingForArrayConstraintsFromSetMapping(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $serviceSearchEntryMappingItem) {
            // validation for constraint: itemType
            if (!$serviceSearchEntryMappingItem instanceof \StructType\Mapping) {
                $invalidValues[] = is_object($serviceSearchEntryMappingItem) ? get_class($serviceSearchEntryMappingItem) : sprintf('%s(%s)', gettype($serviceSearchEntryMappingItem), var_export($serviceSearchEntryMappingItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Mapping property can only contain items of type \StructType\Mapping, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Mapping value
     * @throws \InvalidArgumentException
     * @param \StructType\Mapping[] $mapping
     * @return \StructType\ServiceSearchEntry
     */
    public function setMapping(array $mapping = array())
    {
        // validation for constraint: array
        if ('' !== ($mappingArrayErrorMessage = self::validateMappingForArrayConstraintsFromSetMapping($mapping))) {
            throw new \InvalidArgumentException($mappingArrayErrorMessage, __LINE__);
        }
        $this->Mapping = $mapping;
        return $this;
    }
    /**
     * Add item to Mapping value
     * @throws \InvalidArgumentException
     * @param \StructType\Mapping $item
     * @return \StructType\ServiceSearchEntry
     */
    public function addToMapping(\StructType\Mapping $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Mapping) {
            throw new \InvalidArgumentException(sprintf('The Mapping property can only contain items of type \StructType\Mapping, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Mapping[] = $item;
        return $this;
    }
}
