<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceSearch StructType
 * @subpackage Structs
 */
class ServiceSearch extends AbstractStructBase
{
    /**
     * The service
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $service;
    /**
     * The servicecode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $servicecode;
    /**
     * The servicetype
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $servicetype;
    /**
     * The ratefilter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ratefilter;
    /**
     * The ratesegment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ratesegment;
    /**
     * The dateforprice
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $dateforprice;
    /**
     * The interfaceuse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $interfaceuse;
    /**
     * Constructor method for ServiceSearch
     * @uses ServiceSearch::setService()
     * @uses ServiceSearch::setServicecode()
     * @uses ServiceSearch::setServicetype()
     * @uses ServiceSearch::setRatefilter()
     * @uses ServiceSearch::setRatesegment()
     * @uses ServiceSearch::setDateforprice()
     * @uses ServiceSearch::setInterfaceuse()
     * @param string $service
     * @param string $servicecode
     * @param string $servicetype
     * @param string $ratefilter
     * @param string $ratesegment
     * @param string $dateforprice
     * @param string $interfaceuse
     */
    public function __construct($service = null, $servicecode = null, $servicetype = null, $ratefilter = null, $ratesegment = null, $dateforprice = null, $interfaceuse = null)
    {
        $this
            ->setService($service)
            ->setServicecode($servicecode)
            ->setServicetype($servicetype)
            ->setRatefilter($ratefilter)
            ->setRatesegment($ratesegment)
            ->setDateforprice($dateforprice)
            ->setInterfaceuse($interfaceuse);
    }
    /**
     * Get service value
     * @return string|null
     */
    public function getService()
    {
        return $this->service;
    }
    /**
     * Set service value
     * @param string $service
     * @return \StructType\ServiceSearch
     */
    public function setService($service = null)
    {
        // validation for constraint: string
        if (!is_null($service) && !is_string($service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($service, true), gettype($service)), __LINE__);
        }
        $this->service = $service;
        return $this;
    }
    /**
     * Get servicecode value
     * @return string|null
     */
    public function getServicecode()
    {
        return $this->servicecode;
    }
    /**
     * Set servicecode value
     * @param string $servicecode
     * @return \StructType\ServiceSearch
     */
    public function setServicecode($servicecode = null)
    {
        // validation for constraint: string
        if (!is_null($servicecode) && !is_string($servicecode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($servicecode, true), gettype($servicecode)), __LINE__);
        }
        $this->servicecode = $servicecode;
        return $this;
    }
    /**
     * Get servicetype value
     * @return string|null
     */
    public function getServicetype()
    {
        return $this->servicetype;
    }
    /**
     * Set servicetype value
     * @param string $servicetype
     * @return \StructType\ServiceSearch
     */
    public function setServicetype($servicetype = null)
    {
        // validation for constraint: string
        if (!is_null($servicetype) && !is_string($servicetype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($servicetype, true), gettype($servicetype)), __LINE__);
        }
        $this->servicetype = $servicetype;
        return $this;
    }
    /**
     * Get ratefilter value
     * @return string|null
     */
    public function getRatefilter()
    {
        return $this->ratefilter;
    }
    /**
     * Set ratefilter value
     * @param string $ratefilter
     * @return \StructType\ServiceSearch
     */
    public function setRatefilter($ratefilter = null)
    {
        // validation for constraint: string
        if (!is_null($ratefilter) && !is_string($ratefilter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratefilter, true), gettype($ratefilter)), __LINE__);
        }
        $this->ratefilter = $ratefilter;
        return $this;
    }
    /**
     * Get ratesegment value
     * @return string|null
     */
    public function getRatesegment()
    {
        return $this->ratesegment;
    }
    /**
     * Set ratesegment value
     * @param string $ratesegment
     * @return \StructType\ServiceSearch
     */
    public function setRatesegment($ratesegment = null)
    {
        // validation for constraint: string
        if (!is_null($ratesegment) && !is_string($ratesegment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratesegment, true), gettype($ratesegment)), __LINE__);
        }
        $this->ratesegment = $ratesegment;
        return $this;
    }
    /**
     * Get dateforprice value
     * @return string|null
     */
    public function getDateforprice()
    {
        return $this->dateforprice;
    }
    /**
     * Set dateforprice value
     * @param string $dateforprice
     * @return \StructType\ServiceSearch
     */
    public function setDateforprice($dateforprice = null)
    {
        // validation for constraint: string
        if (!is_null($dateforprice) && !is_string($dateforprice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateforprice, true), gettype($dateforprice)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($dateforprice) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $dateforprice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($dateforprice, true)), __LINE__);
        }
        $this->dateforprice = $dateforprice;
        return $this;
    }
    /**
     * Get interfaceuse value
     * @return string|null
     */
    public function getInterfaceuse()
    {
        return $this->interfaceuse;
    }
    /**
     * Set interfaceuse value
     * @param string $interfaceuse
     * @return \StructType\ServiceSearch
     */
    public function setInterfaceuse($interfaceuse = null)
    {
        // validation for constraint: string
        if (!is_null($interfaceuse) && !is_string($interfaceuse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($interfaceuse, true), gettype($interfaceuse)), __LINE__);
        }
        $this->interfaceuse = $interfaceuse;
        return $this;
    }
}
