<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceReservation StructType
 * @subpackage Structs
 */
class ServiceReservation extends AbstractStructBase
{
    /**
     * The SERVICE_RESERVATION_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $SERVICE_RESERVATION_OBJID;
    /**
     * Constructor method for ServiceReservation
     * @uses ServiceReservation::setSERVICE_RESERVATION_OBJID()
     * @param string $sERVICE_RESERVATION_OBJID
     */
    public function __construct($sERVICE_RESERVATION_OBJID = null)
    {
        $this
            ->setSERVICE_RESERVATION_OBJID($sERVICE_RESERVATION_OBJID);
    }
    /**
     * Get SERVICE_RESERVATION_OBJID value
     * @return string
     */
    public function getSERVICE_RESERVATION_OBJID()
    {
        return $this->{'SERVICE-RESERVATION-OBJID'};
    }
    /**
     * Set SERVICE_RESERVATION_OBJID value
     * @param string $sERVICE_RESERVATION_OBJID
     * @return \StructType\ServiceReservation
     */
    public function setSERVICE_RESERVATION_OBJID($sERVICE_RESERVATION_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($sERVICE_RESERVATION_OBJID) && !is_string($sERVICE_RESERVATION_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sERVICE_RESERVATION_OBJID, true), gettype($sERVICE_RESERVATION_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($sERVICE_RESERVATION_OBJID) && !preg_match('/([0-9])*/', $sERVICE_RESERVATION_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($sERVICE_RESERVATION_OBJID, true)), __LINE__);
        }
        $this->SERVICE_RESERVATION_OBJID = $this->{'SERVICE-RESERVATION-OBJID'} = $sERVICE_RESERVATION_OBJID;
        return $this;
    }
}
