<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Service StructType
 * @subpackage Structs
 */
class Service extends AbstractStructBase
{
    /**
     * The servicecode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $servicecode;
    /**
     * The datefrom
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $datefrom;
    /**
     * The dateto
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $dateto;
    /**
     * The timefrom
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|
     * @var string
     */
    public $timefrom;
    /**
     * The timeto
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|
     * @var string
     */
    public $timeto;
    /**
     * The SERVICE_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $SERVICE_OBJID;
    /**
     * The totalpriceoverperiod
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $totalpriceoverperiod;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $currency;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $quantity;
    /**
     * The priceperunit
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $priceperunit;
    /**
     * The totalprice
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $totalprice;
    /**
     * The totaladditionalservices
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $totaladditionalservices;
    /**
     * The totalsum
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $totalsum;
    /**
     * The refroomresobjid
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9])*
     * @var string
     */
    public $refroomresobjid;
    /**
     * The refmoduleresobjid
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9])*
     * @var string
     */
    public $refmoduleresobjid;
    /**
     * The numberliteral
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $numberliteral;
    /**
     * The postingtype
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $postingtype;
    /**
     * The MultiLanguageDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MultiLanguageDescription[]
     */
    public $MultiLanguageDescription;
    /**
     * Constructor method for Service
     * @uses Service::setServicecode()
     * @uses Service::setDatefrom()
     * @uses Service::setDateto()
     * @uses Service::setTimefrom()
     * @uses Service::setTimeto()
     * @uses Service::setSERVICE_OBJID()
     * @uses Service::setTotalpriceoverperiod()
     * @uses Service::setCurrency()
     * @uses Service::setQuantity()
     * @uses Service::setPriceperunit()
     * @uses Service::setTotalprice()
     * @uses Service::setTotaladditionalservices()
     * @uses Service::setTotalsum()
     * @uses Service::setRefroomresobjid()
     * @uses Service::setRefmoduleresobjid()
     * @uses Service::setNumberliteral()
     * @uses Service::setPostingtype()
     * @uses Service::setMultiLanguageDescription()
     * @param string $servicecode
     * @param string $datefrom
     * @param string $dateto
     * @param string $timefrom
     * @param string $timeto
     * @param string $sERVICE_OBJID
     * @param string $totalpriceoverperiod
     * @param string $currency
     * @param string $quantity
     * @param string $priceperunit
     * @param string $totalprice
     * @param string $totaladditionalservices
     * @param string $totalsum
     * @param string $refroomresobjid
     * @param string $refmoduleresobjid
     * @param string $numberliteral
     * @param string $postingtype
     * @param \StructType\MultiLanguageDescription[] $multiLanguageDescription
     */
    public function __construct($servicecode = null, $datefrom = null, $dateto = null, $timefrom = null, $timeto = null, $sERVICE_OBJID = null, $totalpriceoverperiod = null, $currency = null, $quantity = null, $priceperunit = null, $totalprice = null, $totaladditionalservices = null, $totalsum = null, $refroomresobjid = null, $refmoduleresobjid = null, $numberliteral = null, $postingtype = null, array $multiLanguageDescription = array())
    {
        $this
            ->setServicecode($servicecode)
            ->setDatefrom($datefrom)
            ->setDateto($dateto)
            ->setTimefrom($timefrom)
            ->setTimeto($timeto)
            ->setSERVICE_OBJID($sERVICE_OBJID)
            ->setTotalpriceoverperiod($totalpriceoverperiod)
            ->setCurrency($currency)
            ->setQuantity($quantity)
            ->setPriceperunit($priceperunit)
            ->setTotalprice($totalprice)
            ->setTotaladditionalservices($totaladditionalservices)
            ->setTotalsum($totalsum)
            ->setRefroomresobjid($refroomresobjid)
            ->setRefmoduleresobjid($refmoduleresobjid)
            ->setNumberliteral($numberliteral)
            ->setPostingtype($postingtype)
            ->setMultiLanguageDescription($multiLanguageDescription);
    }
    /**
     * Get servicecode value
     * @return string
     */
    public function getServicecode()
    {
        return $this->servicecode;
    }
    /**
     * Set servicecode value
     * @param string $servicecode
     * @return \StructType\Service
     */
    public function setServicecode($servicecode = null)
    {
        // validation for constraint: string
        if (!is_null($servicecode) && !is_string($servicecode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($servicecode, true), gettype($servicecode)), __LINE__);
        }
        $this->servicecode = $servicecode;
        return $this;
    }
    /**
     * Get datefrom value
     * @return string
     */
    public function getDatefrom()
    {
        return $this->datefrom;
    }
    /**
     * Set datefrom value
     * @param string $datefrom
     * @return \StructType\Service
     */
    public function setDatefrom($datefrom = null)
    {
        // validation for constraint: string
        if (!is_null($datefrom) && !is_string($datefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datefrom, true), gettype($datefrom)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($datefrom) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $datefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($datefrom, true)), __LINE__);
        }
        $this->datefrom = $datefrom;
        return $this;
    }
    /**
     * Get dateto value
     * @return string
     */
    public function getDateto()
    {
        return $this->dateto;
    }
    /**
     * Set dateto value
     * @param string $dateto
     * @return \StructType\Service
     */
    public function setDateto($dateto = null)
    {
        // validation for constraint: string
        if (!is_null($dateto) && !is_string($dateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateto, true), gettype($dateto)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($dateto) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $dateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($dateto, true)), __LINE__);
        }
        $this->dateto = $dateto;
        return $this;
    }
    /**
     * Get timefrom value
     * @return string
     */
    public function getTimefrom()
    {
        return $this->timefrom;
    }
    /**
     * Set timefrom value
     * @param string $timefrom
     * @return \StructType\Service
     */
    public function setTimefrom($timefrom = null)
    {
        // validation for constraint: string
        if (!is_null($timefrom) && !is_string($timefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timefrom, true), gettype($timefrom)), __LINE__);
        }
        // validation for constraint: pattern(([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|)
        if (!is_null($timefrom) && !preg_match('/([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|/', $timefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|', var_export($timefrom, true)), __LINE__);
        }
        $this->timefrom = $timefrom;
        return $this;
    }
    /**
     * Get timeto value
     * @return string
     */
    public function getTimeto()
    {
        return $this->timeto;
    }
    /**
     * Set timeto value
     * @param string $timeto
     * @return \StructType\Service
     */
    public function setTimeto($timeto = null)
    {
        // validation for constraint: string
        if (!is_null($timeto) && !is_string($timeto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeto, true), gettype($timeto)), __LINE__);
        }
        // validation for constraint: pattern(([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|)
        if (!is_null($timeto) && !preg_match('/([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|/', $timeto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|', var_export($timeto, true)), __LINE__);
        }
        $this->timeto = $timeto;
        return $this;
    }
    /**
     * Get SERVICE_OBJID value
     * @return string
     */
    public function getSERVICE_OBJID()
    {
        return $this->{'SERVICE-OBJID'};
    }
    /**
     * Set SERVICE_OBJID value
     * @param string $sERVICE_OBJID
     * @return \StructType\Service
     */
    public function setSERVICE_OBJID($sERVICE_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($sERVICE_OBJID) && !is_string($sERVICE_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sERVICE_OBJID, true), gettype($sERVICE_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($sERVICE_OBJID) && !preg_match('/([0-9])*/', $sERVICE_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($sERVICE_OBJID, true)), __LINE__);
        }
        $this->SERVICE_OBJID = $this->{'SERVICE-OBJID'} = $sERVICE_OBJID;
        return $this;
    }
    /**
     * Get totalpriceoverperiod value
     * @return string
     */
    public function getTotalpriceoverperiod()
    {
        return $this->totalpriceoverperiod;
    }
    /**
     * Set totalpriceoverperiod value
     * @param string $totalpriceoverperiod
     * @return \StructType\Service
     */
    public function setTotalpriceoverperiod($totalpriceoverperiod = null)
    {
        // validation for constraint: string
        if (!is_null($totalpriceoverperiod) && !is_string($totalpriceoverperiod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($totalpriceoverperiod, true), gettype($totalpriceoverperiod)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($totalpriceoverperiod) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $totalpriceoverperiod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($totalpriceoverperiod, true)), __LINE__);
        }
        $this->totalpriceoverperiod = $totalpriceoverperiod;
        return $this;
    }
    /**
     * Get currency value
     * @return string
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\Service
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get quantity value
     * @return string
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param string $quantity
     * @return \StructType\Service
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: string
        if (!is_null($quantity) && !is_string($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($quantity) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($quantity, true)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get priceperunit value
     * @return string
     */
    public function getPriceperunit()
    {
        return $this->priceperunit;
    }
    /**
     * Set priceperunit value
     * @param string $priceperunit
     * @return \StructType\Service
     */
    public function setPriceperunit($priceperunit = null)
    {
        // validation for constraint: string
        if (!is_null($priceperunit) && !is_string($priceperunit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceperunit, true), gettype($priceperunit)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($priceperunit) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $priceperunit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($priceperunit, true)), __LINE__);
        }
        $this->priceperunit = $priceperunit;
        return $this;
    }
    /**
     * Get totalprice value
     * @return string
     */
    public function getTotalprice()
    {
        return $this->totalprice;
    }
    /**
     * Set totalprice value
     * @param string $totalprice
     * @return \StructType\Service
     */
    public function setTotalprice($totalprice = null)
    {
        // validation for constraint: string
        if (!is_null($totalprice) && !is_string($totalprice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($totalprice, true), gettype($totalprice)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($totalprice) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $totalprice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($totalprice, true)), __LINE__);
        }
        $this->totalprice = $totalprice;
        return $this;
    }
    /**
     * Get totaladditionalservices value
     * @return string
     */
    public function getTotaladditionalservices()
    {
        return $this->totaladditionalservices;
    }
    /**
     * Set totaladditionalservices value
     * @param string $totaladditionalservices
     * @return \StructType\Service
     */
    public function setTotaladditionalservices($totaladditionalservices = null)
    {
        // validation for constraint: string
        if (!is_null($totaladditionalservices) && !is_string($totaladditionalservices)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($totaladditionalservices, true), gettype($totaladditionalservices)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($totaladditionalservices) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $totaladditionalservices)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($totaladditionalservices, true)), __LINE__);
        }
        $this->totaladditionalservices = $totaladditionalservices;
        return $this;
    }
    /**
     * Get totalsum value
     * @return string
     */
    public function getTotalsum()
    {
        return $this->totalsum;
    }
    /**
     * Set totalsum value
     * @param string $totalsum
     * @return \StructType\Service
     */
    public function setTotalsum($totalsum = null)
    {
        // validation for constraint: string
        if (!is_null($totalsum) && !is_string($totalsum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($totalsum, true), gettype($totalsum)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($totalsum) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $totalsum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($totalsum, true)), __LINE__);
        }
        $this->totalsum = $totalsum;
        return $this;
    }
    /**
     * Get refroomresobjid value
     * @return string|null
     */
    public function getRefroomresobjid()
    {
        return $this->refroomresobjid;
    }
    /**
     * Set refroomresobjid value
     * @param string $refroomresobjid
     * @return \StructType\Service
     */
    public function setRefroomresobjid($refroomresobjid = null)
    {
        // validation for constraint: string
        if (!is_null($refroomresobjid) && !is_string($refroomresobjid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refroomresobjid, true), gettype($refroomresobjid)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($refroomresobjid) && !preg_match('/([0-9])*/', $refroomresobjid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($refroomresobjid, true)), __LINE__);
        }
        $this->refroomresobjid = $refroomresobjid;
        return $this;
    }
    /**
     * Get refmoduleresobjid value
     * @return string|null
     */
    public function getRefmoduleresobjid()
    {
        return $this->refmoduleresobjid;
    }
    /**
     * Set refmoduleresobjid value
     * @param string $refmoduleresobjid
     * @return \StructType\Service
     */
    public function setRefmoduleresobjid($refmoduleresobjid = null)
    {
        // validation for constraint: string
        if (!is_null($refmoduleresobjid) && !is_string($refmoduleresobjid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refmoduleresobjid, true), gettype($refmoduleresobjid)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($refmoduleresobjid) && !preg_match('/([0-9])*/', $refmoduleresobjid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($refmoduleresobjid, true)), __LINE__);
        }
        $this->refmoduleresobjid = $refmoduleresobjid;
        return $this;
    }
    /**
     * Get numberliteral value
     * @return string|null
     */
    public function getNumberliteral()
    {
        return $this->numberliteral;
    }
    /**
     * Set numberliteral value
     * @param string $numberliteral
     * @return \StructType\Service
     */
    public function setNumberliteral($numberliteral = null)
    {
        // validation for constraint: string
        if (!is_null($numberliteral) && !is_string($numberliteral)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numberliteral, true), gettype($numberliteral)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($numberliteral) && !preg_match('/([-+]){0,1}([0-9])*/', $numberliteral)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($numberliteral, true)), __LINE__);
        }
        $this->numberliteral = $numberliteral;
        return $this;
    }
    /**
     * Get postingtype value
     * @return string|null
     */
    public function getPostingtype()
    {
        return $this->postingtype;
    }
    /**
     * Set postingtype value
     * @param string $postingtype
     * @return \StructType\Service
     */
    public function setPostingtype($postingtype = null)
    {
        // validation for constraint: string
        if (!is_null($postingtype) && !is_string($postingtype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postingtype, true), gettype($postingtype)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($postingtype) && mb_strlen($postingtype) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($postingtype)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($postingtype) && mb_strlen($postingtype) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($postingtype)), __LINE__);
        }
        $this->postingtype = $postingtype;
        return $this;
    }
    /**
     * Get MultiLanguageDescription value
     * @return \StructType\MultiLanguageDescription[]|null
     */
    public function getMultiLanguageDescription()
    {
        return $this->MultiLanguageDescription;
    }
    /**
     * This method is responsible for validating the values passed to the setMultiLanguageDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMultiLanguageDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMultiLanguageDescriptionForArrayConstraintsFromSetMultiLanguageDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $serviceMultiLanguageDescriptionItem) {
            // validation for constraint: itemType
            if (!$serviceMultiLanguageDescriptionItem instanceof \StructType\MultiLanguageDescription) {
                $invalidValues[] = is_object($serviceMultiLanguageDescriptionItem) ? get_class($serviceMultiLanguageDescriptionItem) : sprintf('%s(%s)', gettype($serviceMultiLanguageDescriptionItem), var_export($serviceMultiLanguageDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MultiLanguageDescription property can only contain items of type \StructType\MultiLanguageDescription, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MultiLanguageDescription value
     * @throws \InvalidArgumentException
     * @param \StructType\MultiLanguageDescription[] $multiLanguageDescription
     * @return \StructType\Service
     */
    public function setMultiLanguageDescription(array $multiLanguageDescription = array())
    {
        // validation for constraint: array
        if ('' !== ($multiLanguageDescriptionArrayErrorMessage = self::validateMultiLanguageDescriptionForArrayConstraintsFromSetMultiLanguageDescription($multiLanguageDescription))) {
            throw new \InvalidArgumentException($multiLanguageDescriptionArrayErrorMessage, __LINE__);
        }
        $this->MultiLanguageDescription = $multiLanguageDescription;
        return $this;
    }
    /**
     * Add item to MultiLanguageDescription value
     * @throws \InvalidArgumentException
     * @param \StructType\MultiLanguageDescription $item
     * @return \StructType\Service
     */
    public function addToMultiLanguageDescription(\StructType\MultiLanguageDescription $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MultiLanguageDescription) {
            throw new \InvalidArgumentException(sprintf('The MultiLanguageDescription property can only contain items of type \StructType\MultiLanguageDescription, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MultiLanguageDescription[] = $item;
        return $this;
    }
}
