<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeasonalRateCat StructType
 * @subpackage Structs
 */
class SeasonalRateCat extends AbstractStructBase
{
    /**
     * The ratecategory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ratecategory;
    /**
     * The SeasonalRateEntry
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SeasonalRateEntry[]
     */
    public $SeasonalRateEntry;
    /**
     * Constructor method for SeasonalRateCat
     * @uses SeasonalRateCat::setRatecategory()
     * @uses SeasonalRateCat::setSeasonalRateEntry()
     * @param string $ratecategory
     * @param \StructType\SeasonalRateEntry[] $seasonalRateEntry
     */
    public function __construct($ratecategory = null, array $seasonalRateEntry = array())
    {
        $this
            ->setRatecategory($ratecategory)
            ->setSeasonalRateEntry($seasonalRateEntry);
    }
    /**
     * Get ratecategory value
     * @return string
     */
    public function getRatecategory()
    {
        return $this->ratecategory;
    }
    /**
     * Set ratecategory value
     * @param string $ratecategory
     * @return \StructType\SeasonalRateCat
     */
    public function setRatecategory($ratecategory = null)
    {
        // validation for constraint: string
        if (!is_null($ratecategory) && !is_string($ratecategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratecategory, true), gettype($ratecategory)), __LINE__);
        }
        $this->ratecategory = $ratecategory;
        return $this;
    }
    /**
     * Get SeasonalRateEntry value
     * @return \StructType\SeasonalRateEntry[]|null
     */
    public function getSeasonalRateEntry()
    {
        return $this->SeasonalRateEntry;
    }
    /**
     * This method is responsible for validating the values passed to the setSeasonalRateEntry method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSeasonalRateEntry method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSeasonalRateEntryForArrayConstraintsFromSetSeasonalRateEntry(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seasonalRateCatSeasonalRateEntryItem) {
            // validation for constraint: itemType
            if (!$seasonalRateCatSeasonalRateEntryItem instanceof \StructType\SeasonalRateEntry) {
                $invalidValues[] = is_object($seasonalRateCatSeasonalRateEntryItem) ? get_class($seasonalRateCatSeasonalRateEntryItem) : sprintf('%s(%s)', gettype($seasonalRateCatSeasonalRateEntryItem), var_export($seasonalRateCatSeasonalRateEntryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SeasonalRateEntry property can only contain items of type \StructType\SeasonalRateEntry, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SeasonalRateEntry value
     * @throws \InvalidArgumentException
     * @param \StructType\SeasonalRateEntry[] $seasonalRateEntry
     * @return \StructType\SeasonalRateCat
     */
    public function setSeasonalRateEntry(array $seasonalRateEntry = array())
    {
        // validation for constraint: array
        if ('' !== ($seasonalRateEntryArrayErrorMessage = self::validateSeasonalRateEntryForArrayConstraintsFromSetSeasonalRateEntry($seasonalRateEntry))) {
            throw new \InvalidArgumentException($seasonalRateEntryArrayErrorMessage, __LINE__);
        }
        $this->SeasonalRateEntry = $seasonalRateEntry;
        return $this;
    }
    /**
     * Add item to SeasonalRateEntry value
     * @throws \InvalidArgumentException
     * @param \StructType\SeasonalRateEntry $item
     * @return \StructType\SeasonalRateCat
     */
    public function addToSeasonalRateEntry(\StructType\SeasonalRateEntry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SeasonalRateEntry) {
            throw new \InvalidArgumentException(sprintf('The SeasonalRateEntry property can only contain items of type \StructType\SeasonalRateEntry, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SeasonalRateEntry[] = $item;
        return $this;
    }
}
