<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for S_USER_INFO_GET_V001Response StructType
 * @subpackage Structs
 */
class S_USER_INFO_GET_V001Response extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Result
     */
    public $Result;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The UserInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\UserInfo[]
     */
    public $UserInfo;
    /**
     * Constructor method for S_USER_INFO_GET_V001Response
     * @uses S_USER_INFO_GET_V001Response::setResult()
     * @uses S_USER_INFO_GET_V001Response::setTransactionID()
     * @uses S_USER_INFO_GET_V001Response::setUserInfo()
     * @param \StructType\Result $result
     * @param string $transactionID
     * @param \StructType\UserInfo[] $userInfo
     */
    public function __construct(\StructType\Result $result = null, $transactionID = null, array $userInfo = array())
    {
        $this
            ->setResult($result)
            ->setTransactionID($transactionID)
            ->setUserInfo($userInfo);
    }
    /**
     * Get Result value
     * @return \StructType\Result
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \StructType\Result $result
     * @return \StructType\S_USER_INFO_GET_V001Response
     */
    public function setResult(\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\S_USER_INFO_GET_V001Response
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get UserInfo value
     * @return \StructType\UserInfo[]|null
     */
    public function getUserInfo()
    {
        return $this->UserInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setUserInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUserInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUserInfoForArrayConstraintsFromSetUserInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $s_USER_INFO_GET_V001ResponseUserInfoItem) {
            // validation for constraint: itemType
            if (!$s_USER_INFO_GET_V001ResponseUserInfoItem instanceof \StructType\UserInfo) {
                $invalidValues[] = is_object($s_USER_INFO_GET_V001ResponseUserInfoItem) ? get_class($s_USER_INFO_GET_V001ResponseUserInfoItem) : sprintf('%s(%s)', gettype($s_USER_INFO_GET_V001ResponseUserInfoItem), var_export($s_USER_INFO_GET_V001ResponseUserInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UserInfo property can only contain items of type \StructType\UserInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UserInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\UserInfo[] $userInfo
     * @return \StructType\S_USER_INFO_GET_V001Response
     */
    public function setUserInfo(array $userInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($userInfoArrayErrorMessage = self::validateUserInfoForArrayConstraintsFromSetUserInfo($userInfo))) {
            throw new \InvalidArgumentException($userInfoArrayErrorMessage, __LINE__);
        }
        $this->UserInfo = $userInfo;
        return $this;
    }
    /**
     * Add item to UserInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\UserInfo $item
     * @return \StructType\S_USER_INFO_GET_V001Response
     */
    public function addToUserInfo(\StructType\UserInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UserInfo) {
            throw new \InvalidArgumentException(sprintf('The UserInfo property can only contain items of type \StructType\UserInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->UserInfo[] = $item;
        return $this;
    }
}
